/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.preview;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.Size;
import com.ibm.team.calm.foundation.common.internal.preview.ICompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.internal.preview.JazzCompactRenderingDocument;
import com.ibm.team.calm.foundation.common.internal.preview.Messages;
import com.ibm.team.calm.foundation.common.internal.preview.OslcCompactRenderingDocument;
import com.ibm.team.calm.foundation.common.internal.preview.ResolutionError;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.CompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.DTO_ResolutionError;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;

public abstract class CompactRenderingDocument {
    private static final String ACCEPT_EITHER = String.valueOf(ContentType.UI_PREVIEW.getValue()) + ", " + ContentType.COMPACT_RENDERING.getValue() + "; q=0.5";
    private static final String PROTOCOL_HTTP = "http";
    protected final String fUri;
    protected final InputStream fInputStream;
    protected String fAbout;
    protected String fTitle;
    protected String fAbbreviation;
    protected String fIconURI;
    protected String fSmallPreview;
    protected Long fSmallPreviewWidth;
    protected Long fSmallPreviewHeight;
    protected Long fSmallPreviewInitialHeight = null;
    protected String fLargePreview;
    protected Long fLargePreviewWidth;
    protected Long fLargePreviewHeight;
    protected Long fLargePreviewInitialHeight = null;
    private ICompactRenderingRepresentation fRepresentation;
    private static final Log fgLogger = LogFactory.getLog(CompactRenderingDocument.class);

    protected CompactRenderingDocument(String documentUri, InputStream inputStream) {
        this.fUri = documentUri;
        this.fInputStream = inputStream;
    }

    ICompactRenderingRepresentation createRepresentation() throws TeamRepositoryException {
        if (this.fRepresentation == null) {
            this.readDocument();
            CompactRenderingRepresentation representation = RcpFactory.eINSTANCE.createCompactRenderingRepresentation();
            representation.setAbout(this.fAbout);
            representation.setTitle(this.fTitle);
            representation.setShortTitle(this.fAbbreviation);
            representation.setIconLocation(this.fIconURI);
            representation.setSmallPreviewLocation(this.fSmallPreview);
            representation.setSmallPreviewWidth(this.fSmallPreviewWidth);
            representation.setSmallPreviewHeight(this.fSmallPreviewHeight);
            representation.setSmallPreviewInitialHeight(this.fSmallPreviewInitialHeight);
            representation.setLargePreviewLocation(this.fLargePreview);
            representation.setLargePreviewWidth(this.fLargePreviewWidth);
            representation.setLargePreviewHeight(this.fLargePreviewHeight);
            representation.setLargePreviewInitialHeight(this.fLargePreviewInitialHeight);
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Title in createRepresentation:::" + (this.fTitle != null ? this.fTitle : "Title is null")));
            }
            this.fRepresentation = representation;
        }
        return this.fRepresentation;
    }

    protected abstract void readDocument() throws TeamRepositoryException;

    protected Long convertToPixels(String sizeText) {
        if (sizeText != null && sizeText.length() > 0) {
            try {
                String size = sizeText;
                if (sizeText.endsWith(Size.SizeUnit.em.toString()) || sizeText.endsWith(Size.SizeUnit.px.toString())) {
                    size = sizeText.substring(0, sizeText.length() - 2);
                }
                Long number = Long.parseLong(size);
                if (sizeText.endsWith(Size.SizeUnit.em.toString())) {
                    return number * 12L;
                }
                return number;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ICompactRenderingRepresentation getCompactRenderingRepresentation(String uri, IHttpClient httpClient) {
        if (uri == null || uri.length() == 0) {
            return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(Messages.getString("ResourcePreviewHelper_ERROR_NO_URI_PROVIDED")));
        }
        try {
            URI uriForValidation = new URI(uri);
            if (CompactRenderingDocument.getHostForUri(uriForValidation) == null) {
                String message = NLS.bind((String)Messages.getString("ResourcePreviewHelper_ERROR_COMPACT_RENDERING_NOT_SUPPORTED"), (Object)uri, (Object[])new Object[0]);
                return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(message));
            }
        }
        catch (URISyntaxException e) {
            return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(e.getLocalizedMessage()));
        }
        try {
            return CompactRenderingDocument.getCompactRenderingRepresentation(uri, ACCEPT_EITHER, httpClient);
        }
        catch (Exception e) {
            LogFactory.getLog(CompactRenderingDocument.class).error((Object)e.getLocalizedMessage(), (Throwable)e);
            return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(e.getLocalizedMessage()));
        }
    }

    private static HttpHost getHostForUri(URI uri) {
        int port;
        String scheme;
        HttpHost host = null;
        String hostStr = uri.getHost();
        String string = scheme = uri.getScheme() != null ? uri.getScheme() : PROTOCOL_HTTP;
        int n = uri.getPort() != -1 ? uri.getPort() : (port = PROTOCOL_HTTP.equals(scheme) ? 80 : 443);
        if (hostStr != null) {
            host = new HttpHost(hostStr, port, scheme);
        }
        return host;
    }

    private static ICompactRenderingRepresentation getCompactRenderingRepresentation(String uri, String acceptType, IHttpClient httpClient) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.addHeader("Accept", acceptType);
            IHttpClient.IResponse response = httpClient.performGet(uri, headers);
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Headers:::" + headers.toString()));
                fgLogger.debug((Object)("Get URI:::" + uri));
                IHttpClient.IResponse responseinDebug = httpClient.performGet(uri, headers);
                fgLogger.debug((Object)("get rest service response:: " + responseinDebug.getContent()));
                fgLogger.debug((Object)("get rest service status:: " + responseinDebug.getStatusCode()));
            }
            if (response.getStatusCode() != 200) {
                ResolutionError resolutionError = new ResolutionError(response);
                if (resolutionError.isAuthenticationError() || ContentType.COMPACT_RENDERING.getValue().equals(acceptType)) {
                    return CompactRenderingDocument.createRepresentationWithError(uri, resolutionError);
                }
                acceptType = ContentType.COMPACT_RENDERING.getValue();
                return CompactRenderingDocument.getCompactRenderingRepresentation(uri, acceptType, httpClient);
            }
            return CompactRenderingDocument.processCompactRenderingResponse(uri, response);
        }
        catch (NotLoggedInException e) {
            fgLogger.error((Object)"NotLoggedInException", e.getCause());
            return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(true));
        }
        catch (PermissionDeniedException e) {
            fgLogger.error((Object)"PermissionDeniedException", e.getCause());
            if (!httpClient.isModifyingResponse()) {
                return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(true));
            }
            return CompactRenderingDocument.handleTeamRepositoryException(uri, acceptType, httpClient, (TeamRepositoryException)((Object)e));
        }
        catch (TeamRepositoryException e) {
            fgLogger.error((Object)"TeamRepositoryException", e.getCause());
            return CompactRenderingDocument.handleTeamRepositoryException(uri, acceptType, httpClient, e);
        }
    }

    private static ICompactRenderingRepresentation handleTeamRepositoryException(String uri, String acceptType, IHttpClient httpClient, TeamRepositoryException e) {
        if (ACCEPT_EITHER.equals(acceptType)) {
            acceptType = ContentType.COMPACT_RENDERING.getValue();
            return CompactRenderingDocument.getCompactRenderingRepresentation(uri, acceptType, httpClient);
        }
        return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(e.getLocalizedMessage()));
    }

    private static ICompactRenderingRepresentation processCompactRenderingResponse(String uri, IHttpClient.IResponse response) throws TeamRepositoryException {
        if (response.getStatusCode() != 200) {
            ResolutionError resolutionError = new ResolutionError(response);
            return CompactRenderingDocument.createRepresentationWithError(uri, resolutionError);
        }
        String contentType = CompactRenderingDocument.getContentType(response);
        CompactRenderingDocument doc = CompactRenderingDocumentManager.createCompactRenderingDocument(uri, response.getResponseStream(), contentType);
        if (doc == null) {
            String message = NLS.bind((String)Messages.getString("ResourcePreviewHelper_ERROR_COMPACT_RENDERING_CONTENT_NOT_SUPPORTED"), (Object)uri, (Object[])new Object[]{contentType});
            return CompactRenderingDocument.createRepresentationWithError(uri, new ResolutionError(message));
        }
        return doc.createRepresentation();
    }

    private static String getContentType(IHttpClient.IResponse response) {
        String contentType = response.getResponseHeaders().getValue("Content-Type");
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(";");
        if (index > -1) {
            contentType = contentType.substring(0, index);
        }
        return contentType;
    }

    public static CompactRenderingRepresentation createRepresentationWithError(String about, ResolutionError resolutionError) {
        CompactRenderingRepresentation representation = RcpFactory.eINSTANCE.createCompactRenderingRepresentation();
        representation.setAbout(about);
        DTO_ResolutionError error = RcpFactory.eINSTANCE.createDTO_ResolutionError();
        error.setErrorCode(resolutionError.getErrorCode());
        error.setErrorMessage(resolutionError.getErrorMessage());
        error.setAuthenticationError(resolutionError.isAuthenticationError());
        representation.setError(error);
        return representation;
    }

    public static class CompactRenderingDocumentManager {
        public static CompactRenderingDocument createCompactRenderingDocument(String uri, InputStream inputStream, String contentType) throws CALMDocument.DocumentParseException {
            if (ContentType.COMPACT_RENDERING.getValue().equals(contentType)) {
                return new JazzCompactRenderingDocument(uri, inputStream);
            }
            if (ContentType.UI_PREVIEW.getValue().equals(contentType)) {
                return new OslcCompactRenderingDocument(uri, inputStream);
            }
            return null;
        }
    }
}

