/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RMBackLinkOperationV1
extends CALMBackLinkOperation {
    private static final String ELEMENT_LABEL = "label";
    private static final QName RDF_DESCRIPTION = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDFIdentifiers.DESCRIPTION.getName());
    private static final QName RDF_ABOUT = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDFIdentifiers.ABOUT.getName());
    private static final QName RDF_RESOURCE = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDFIdentifiers.RESOURCE.getName());
    private static final QName RDFS_LABEL = new QName("http://www.w3.org/2000/01/rdf-schema#", "label");
    private CALMDocument fDocument;

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        OSLCResource resource = super.loadResource(this.getBackLink().getSourceURL());
        this.fDocument = new CALMDocument(resource.getContent());
        NodeList nodes = this.fDocument.getNodes(this.getLinkPath());
        return this.parseLinks(nodes, this.fDocument);
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        String newContent = null;
        newContent = this.hasLinkRemoved() ? this.replaceResourceContent(newLinks) : this.addNewLinkToResource(this.getBackLink().getTargetURL(), this.getBackLink().getLinkComment());
        super.storeResource(newContent);
    }

    @Override
    public CALMBackLinkOperation clone() {
        RMBackLinkOperationV1 result = new RMBackLinkOperationV1();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }

    private List<CALMBackLink> parseLinks(NodeList nodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>(nodes.getLength());
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node curNode = nodes.item(idx);
            String curTarget = this.parseLinkURI(curNode, document);
            String curLabel = this.parseLinkLabel(curNode, document);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(this.createBackLink(curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private String parseLinkLabel(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery path = new XPathQuery("./").addRef(RDF_DESCRIPTION).add('/').addRef(RDFS_LABEL);
        return document.getText(path, (Object)node);
    }

    private String parseLinkURI(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery pathV1 = new XPathQuery("@").addRef(RDF_RESOURCE);
        XPathQuery pathPreV1 = new XPathQuery("./").addRef(RDF_DESCRIPTION).add("/@").addRef(RDF_ABOUT);
        String result = document.getText(pathV1, (Object)node);
        if (result != null && result.length() > 0) {
            return result;
        }
        return document.getText(pathPreV1, (Object)node);
    }

    private QName getLinkElement() {
        return this.getBackLinkElement().getQualifiedName();
    }

    private XPathQuery getLinkPath() {
        return new XPathQuery().add('/').addRef(this.getElementName()).add('/').addRef(this.getLinkElement());
    }

    private String replaceResourceContent(List<CALMBackLink> newLinks) throws CALMDocument.DocumentParseException {
        if (this.fDocument != null) {
            XPathQuery nodesPath = new XPathQuery(this.getElementName());
            NodeList roots = this.fDocument.getNodes(nodesPath);
            if (roots.getLength() == 1) {
                Element root = (Element)roots.item(0);
                NodeList nodes = root.getElementsByTagNameNS(this.getBackLinkElement().getNamespaceURI(), this.getBackLinkElement().getTypeId());
                int idx = nodes.getLength() - 1;
                while (idx >= 0) {
                    root.removeChild(nodes.item(idx));
                    --idx;
                }
                for (CALMBackLink curLink : newLinks) {
                    this.addLinkElementToResource(curLink.getTargetURL(), root);
                }
                return this.writeDocumentContent(root.getOwnerDocument());
            }
            throw new CALMDocument.DocumentParseException(NLS.bind((String)"Unexpected resource format for {0}. Expecting path {1}", (Object[])new String[]{this.getBackLink().getSourceURL(), nodesPath.getXPath()}));
        }
        return null;
    }

    private String addNewLinkToResource(String targetURL, String linkLabel) throws CALMDocument.DocumentParseException {
        if (this.fDocument != null) {
            XPathQuery nodesPath = new XPathQuery(this.getElementName());
            NodeList roots = this.fDocument.getNodes(nodesPath);
            if (roots.getLength() == 1) {
                Element root = (Element)roots.item(0);
                this.addLinkElementToResource(targetURL, root);
                return this.writeDocumentContent(root.getOwnerDocument());
            }
            throw new CALMDocument.DocumentParseException(NLS.bind((String)Messages.getString("RMBackLinkOperationV1_UNEXPECTED_RESOURCE_FORMAT"), (Object[])new String[]{this.getBackLink().getSourceURL(), nodesPath.getXPath()}));
        }
        return null;
    }

    private void addLinkElementToResource(String targetURL, Element root) {
        Element linkElem = this.fDocument.addNewElement(root, this.getLinkElement().getNamespaceURI(), this.getLinkElement().getLocalPart(), this.getNamespaces().getPrefix(this.getLinkElement().getNamespaceURI()));
        CALMDocument.setAttribute(linkElem, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDFIdentifiers.RESOURCE.getName(), "rdf", targetURL);
    }
}

