/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class RMBackLinkOperationPreV1
extends CALMBackLinkOperation {
    private static final String ELEMENT_LABEL = "label";
    private static final String ELEMENT_LINK_COLLECTION = "LinkCollection";
    private static final QName RDF_RDF = new QName(RDFIdentifiers.RDF.getNamespaceURI(), RDFIdentifiers.RDF.getName());
    private static final QName RDF_DESCRIPTION = new QName(RDFIdentifiers.DESCRIPTION.getNamespaceURI(), RDFIdentifiers.DESCRIPTION.getName());
    private static final QName RDF_ABOUT = new QName(RDFIdentifiers.ABOUT.getNamespaceURI(), RDFIdentifiers.ABOUT.getName());
    private static final QName RDF_RESOURCE = new QName(RDFIdentifiers.RESOURCE.getNamespaceURI(), RDFIdentifiers.RESOURCE.getName());
    private static final QName OSLC_RM_LINK_COLLECTION = new QName("http://open-services.net/xmlns/rm/1.0/", "LinkCollection");
    private static final QName RDFS_LABEL = new QName("http://www.w3.org/2000/01/rdf-schema#", "label");
    private static String APPLICATION_RDF_XML = "application/rdf+xml";
    private String fLinkCollectionUrl;
    private CALMDocument fDocument;
    private boolean fIsLinkFormatChangedPreV1 = true;

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        this.fLinkCollectionUrl = this.fetchLinkCollectionURL();
        return this.fetchLinks(this.fLinkCollectionUrl, APPLICATION_RDF_XML);
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        try {
            super.storeResource(this.createLinkCollectionDocument(newLinks));
        }
        catch (XMLHelper.XMLSerializeException ex) {
            throw this.newGeneralError(ex);
        }
    }

    @Override
    public CALMBackLinkOperation clone() {
        RMBackLinkOperationPreV1 result = new RMBackLinkOperationPreV1();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }

    private List<CALMBackLink> fetchLinks(String resourceUrl, String contentType) throws TeamRepositoryException, UnsupportedVersionException {
        OSLCResource resource = super.loadResource(resourceUrl);
        this.fDocument = new CALMDocument(resource.getContent());
        NodeList nodes = this.fDocument.getNodes(this.getLinkPath());
        return this.parseLinks(nodes, this.fDocument, contentType);
    }

    private String fetchLinkCollectionURL() throws TeamRepositoryException, UnsupportedVersionException {
        OSLCResource resource = super.loadResource(this.getBackLink().getSourceURL());
        CALMDocument resourceRepresentation = new CALMDocument(resource.getContent());
        String result = resourceRepresentation.getText(this.getLinkCollectionPath());
        try {
            new URI(result);
        }
        catch (URISyntaxException ex) {
            String resultUrl = String.valueOf(this.getLinkCollectionElement().getNamespaceURI()) + this.getLinkCollectionElement().getLocalPart();
            String message = MessageFormat.format(Messages.getString("RMBackLinkOperationPreV1_ERROR_NO_LINK_IN_RESOURCE"), resultUrl);
            throw new TeamRepositoryException(message);
        }
        return result;
    }

    private List<CALMBackLink> parseLinks(NodeList nodes, CALMDocument document, String contentType) throws CALMDocument.DocumentParseException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>(nodes.getLength());
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node curNode = nodes.item(idx);
            String curTarget = this.parseLinkURI(curNode, document);
            String curLabel = this.parseLinkLabel(curNode, document);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(this.createBackLink(curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private String parseLinkLabel(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery path = new XPathQuery("./").addRef(RDF_DESCRIPTION).add('/').addRef(RDFS_LABEL);
        return document.getText(path, (Object)node);
    }

    private String parseLinkURI(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery pathV1 = new XPathQuery("@").addRef(RDF_RESOURCE);
        XPathQuery pathPreV1 = new XPathQuery("./").addRef(RDF_DESCRIPTION).add("/@").addRef(RDF_ABOUT);
        String result = document.getText(pathV1, (Object)node);
        if (result != null && result.length() > 0) {
            this.fIsLinkFormatChangedPreV1 = true;
            return result;
        }
        this.fIsLinkFormatChangedPreV1 = false;
        return document.getText(pathPreV1, (Object)node);
    }

    private QName getLinkCollectionElement() {
        CALMLinkTypeInformation.BackLinkElement element = this.getBackLinkElement();
        if (element != null) {
            QName backLinkName = this.getBackLinkElement().getQualifiedName();
            return new QName(backLinkName.getNamespaceURI(), String.valueOf(backLinkName.getLocalPart()) + "Collection");
        }
        return null;
    }

    private QName getLinkElement() {
        return this.getBackLinkElement() != null ? this.getBackLinkElement().getQualifiedName() : null;
    }

    private XPathQuery getLinkCollectionPath() {
        return new XPathQuery().add('/').addRef(RDF_RDF).add('/').addRef(this.getElementName()).add('/').addRef(this.getLinkCollectionElement()).add("/@").addRef(RDF_RESOURCE);
    }

    private XPathQuery getLinkPath() {
        return new XPathQuery().add('/').addRef(RDF_RDF).add('/').addRef(OSLC_RM_LINK_COLLECTION).add('/').addRef(this.getLinkElement());
    }

    private String createLinkCollectionDocument(List<CALMBackLink> newLinks) throws XMLHelper.XMLSerializeException {
        XMLHelper xmlHelper = new XMLHelper(new ContentType(this.getContentType()), HttpUtil.CharsetEncoding.UTF8.toCharset());
        xmlHelper.startDocument();
        xmlHelper.startElement(RDFIdentifiers.RDF);
        AttributesImpl attrib = xmlHelper.createAttribute(RDFIdentifiers.ABOUT, this.fLinkCollectionUrl);
        xmlHelper.startElement("http://open-services.net/xmlns/rm/1.0/", ELEMENT_LINK_COLLECTION, attrib);
        for (CALMBackLink cur : newLinks) {
            this.addLinkElementToLinkCollection(cur, xmlHelper);
        }
        xmlHelper.endElement("http://open-services.net/xmlns/rm/1.0/", ELEMENT_LINK_COLLECTION);
        xmlHelper.endElement(RDFIdentifiers.RDF);
        xmlHelper.endDocument();
        return xmlHelper.getString();
    }

    private void addLinkElementToLinkCollection(CALMBackLink newLink, XMLHelper xmlHelper) {
        CALMLinkTypeInformation.BackLinkElement backLinkInfo = this.getBackLinkElement();
        String linkNamespace = backLinkInfo.getNamespaceURI();
        String linkTypeId = backLinkInfo.getTypeId();
        if (this.fIsLinkFormatChangedPreV1) {
            AttributesImpl attributes = xmlHelper.createAttribute(RDFIdentifiers.RESOURCE, newLink.getTargetURL());
            xmlHelper.startElement(linkNamespace, linkTypeId, attributes);
        } else {
            xmlHelper.startElement(linkNamespace, linkTypeId);
            AttributesImpl attributes = xmlHelper.createAttribute(RDFIdentifiers.ABOUT, newLink.getTargetURL());
            xmlHelper.startElement(RDFIdentifiers.DESCRIPTION, (Attributes)attributes);
            xmlHelper.startElement("http://www.w3.org/2000/01/rdf-schema#", ELEMENT_LABEL);
            xmlHelper.characters(newLink.getLinkComment());
            xmlHelper.endElement("http://www.w3.org/2000/01/rdf-schema#", ELEMENT_LABEL);
            xmlHelper.endElement(RDFIdentifiers.DESCRIPTION);
        }
        xmlHelper.endElement(linkNamespace, linkTypeId);
    }
}

