/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.CALMFoundationCommonPlugin;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class QMVersion1ResourceUpdater
extends ResourceUpdater {
    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        CALMDocument document = new CALMDocument(resource.getContent());
        for (OSLCResourceDescription.ResourcePropertyDescription propertyDesc : propertyDescriptions) {
            XPathQuery path = new XPathQuery(this.getResourceVersion().getElementName()).add('/').addRef(propertyDesc.getProperty());
            NodeList nodes = document.getNodes(path);
            List<ResourceUpdater.LinkProperty> links = this.parseLinks(propertyDesc, nodes, document);
            result.putLinkProperties(propertyDesc, links);
        }
        return result;
    }

    private List<ResourceUpdater.LinkProperty> parseLinks(OSLCResourceDescription.ResourcePropertyDescription desc, NodeList xmlNodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<ResourceUpdater.LinkProperty> result = new ArrayList<ResourceUpdater.LinkProperty>(xmlNodes.getLength());
        int idx = 0;
        while (idx < xmlNodes.getLength()) {
            Node curNode = xmlNodes.item(idx);
            XPathQuery resourcePath = new XPathQuery("./@").addRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            XPathQuery labelPath = new XPathQuery("./@").addRef("http://open-services.net/xmlns/qm/1.0/", "label");
            String curTarget = document.getText(resourcePath, (Object)curNode);
            String curLabel = document.getText(labelPath, (Object)curNode);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(new ResourceUpdater.LinkProperty(desc.getId(), curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    @Override
    protected String storeContent(ResourceUpdater.ResourceContent updatedLinks) throws TeamRepositoryException {
        QName elementName = this.getResourceVersion().getElementName();
        XMLHelper xmlHelper = new XMLHelper(new ContentType(this.getResourceVersion().getContentType()), HttpUtil.CharsetEncoding.UTF8.toCharset());
        xmlHelper.startDocument();
        xmlHelper.startElement(elementName.getNamespaceURI(), elementName.getLocalPart());
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : updatedLinks.getLinkPropertySet()) {
            List<ResourceUpdater.LinkProperty> links = entry.getValue();
            for (ResourceUpdater.LinkProperty link : links) {
                this.writeLinkToXML(entry.getKey(), xmlHelper, link);
            }
        }
        xmlHelper.endElement(elementName.getNamespaceURI(), elementName.getLocalPart());
        xmlHelper.endDocument();
        try {
            return xmlHelper.getString();
        }
        catch (XMLHelper.XMLSerializeException ex) {
            throw new TeamRepositoryException(Messages.getString("QMVersion1ResourceUpdater_PROBLEM_STORING_LINK_CHANGES"), (Throwable)ex);
        }
    }

    @Override
    protected void performWrite(OSLCResource resource, String newContent, Set<OSLCResourceDescription.ResourcePropertyDescription> changedParameters) throws TeamRepositoryException {
        try {
            super.performWrite(resource, newContent, changedParameters);
        }
        catch (IHttpClient.HttpAccessException e) {
            if (this.isUnsupportedPlanLinksInRQM201(e)) {
                CALMFoundationCommonPlugin.log(e.getMessage(), (Throwable)((Object)e));
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("QMVersion1ResourceUpdater_ERROR_CREATING_QM_LINK_NOT_SUPPORTED"), (Object)this.getResourceURL(), (Object[])new Object[0]));
            }
            if (this.isResourceLockedInRQM201(e)) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("QMVersion1ResourceUpdater_ERROR_LOCKED_RESOURCE_CANNOT_BE_MODIFIED"), (Object)this.getResourceURL(), (Object[])new Object[0]));
            }
            throw e;
        }
    }

    private boolean isUnsupportedPlanLinksInRQM201(IHttpClient.HttpAccessException e) {
        List<ResourceUpdater.LinkPropertyChange> changes = this.getChanges("testsDevelopmentPlan");
        return e.getResponse().getStatusCode() == 409 && !changes.isEmpty();
    }

    private boolean isResourceLockedInRQM201(IHttpClient.HttpAccessException e) {
        IHttpClient.IResponse response = e.getResponse();
        try {
            String content = response.getContent();
            if (content.indexOf("com.ibm.rqm.integration.common.LockException") > -1) {
                return true;
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return false;
    }

    private void writeLinkToXML(OSLCResourceDescription.ResourcePropertyDescription desc, XMLHelper xml, ResourceUpdater.LinkProperty link) {
        AttributesImpl attributes = xml.createAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", link.getLinkUri());
        xml.addAttribute(attributes, "http://open-services.net/xmlns/qm/1.0/", "label", link.getLinkComment());
        Property linkProperty = desc.getProperty();
        xml.startElement(linkProperty, (Attributes)attributes);
        xml.endElement(linkProperty);
    }
}

