/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class QMPreVersion1ResourceUpdater
extends ResourceUpdater {
    private static final Property OSLC_QM_COLLECTION = new Property("http://open-services.net/xmlns/qm/1.0/", "collref");
    private Map<OSLCResourceDescription.ResourcePropertyDescription, OSLCResource> fLinkCollectionResources;

    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        CALMDocument document = new CALMDocument(resource.getContent());
        this.fLinkCollectionResources = new HashMap<OSLCResourceDescription.ResourcePropertyDescription, OSLCResource>();
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        for (OSLCResourceDescription.ResourcePropertyDescription desc : propertyDescriptions) {
            Property linkName = desc.getProperty();
            XPathQuery collectionPath = new XPathQuery().add('/').addRef(this.getResourceVersion().getElementName()).add('/').addRef(linkName).add("/@").addRef(OSLC_QM_COLLECTION);
            String linkCollectionUrl = document.getText(collectionPath);
            try {
                new URI(linkCollectionUrl);
            }
            catch (URISyntaxException ex) {
                String message = MessageFormat.format(Messages.getString("QMPreVersion1ResourceUpdater_ERROR_NO_LINKS"), collectionPath);
                throw new TeamRepositoryException(message, (Throwable)ex);
            }
            OSLCResource linkCollectionResource = OSLCResource.loadResource(this.getHttpAccess(), linkCollectionUrl, null, this.getResourceVersion());
            this.fLinkCollectionResources.put(desc, linkCollectionResource);
            CALMDocument linkCollectionDocument = new CALMDocument(linkCollectionResource.getContent());
            XPathQuery nodesPath = new XPathQuery().add('/').addRef(linkName).add('/').addRef(linkName);
            NodeList nodes = linkCollectionDocument.getNodes(nodesPath);
            List<ResourceUpdater.LinkProperty> linkDescriptions = this.parseLinks(desc, nodes, linkCollectionDocument);
            result.putLinkProperties(desc, linkDescriptions);
        }
        return result;
    }

    private List<ResourceUpdater.LinkProperty> parseLinks(OSLCResourceDescription.ResourcePropertyDescription desc, NodeList xmlNodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<ResourceUpdater.LinkProperty> result = new ArrayList<ResourceUpdater.LinkProperty>(xmlNodes.getLength());
        int idx = 0;
        while (idx < xmlNodes.getLength()) {
            Node curNode = xmlNodes.item(idx);
            XPathQuery resourcePath = new XPathQuery("./@").addRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            XPathQuery labelPath = new XPathQuery("./@").addRef("http://open-services.net/xmlns/qm/1.0/", "label");
            String curTarget = document.getText(resourcePath, (Object)curNode);
            String curLabel = document.getText(labelPath, (Object)curNode);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(new ResourceUpdater.LinkProperty(desc.getId(), curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    @Override
    protected String storeContent(ResourceUpdater.ResourceContent updatedLinks) throws TeamRepositoryException {
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : updatedLinks.getLinkPropertySet()) {
            OSLCResourceDescription.ResourcePropertyDescription desc = entry.getKey();
            List<ResourceUpdater.LinkProperty> newLinks = entry.getValue();
            String newContent = this.replaceLinkCollection(desc, newLinks);
            OSLCResource oslcResource = this.fLinkCollectionResources.get(desc);
            oslcResource.write(this.getHttpAccess(), newContent, null);
        }
        return null;
    }

    private String replaceLinkCollection(OSLCResourceDescription.ResourcePropertyDescription desc, List<ResourceUpdater.LinkProperty> newLinks) throws TeamRepositoryException {
        Property linkName = desc.getProperty();
        XMLHelper xmlHelper = new XMLHelper(new ContentType(this.getResourceVersion().getContentType()), HttpUtil.CharsetEncoding.UTF8.toCharset());
        xmlHelper.startDocument();
        xmlHelper.startElement(linkName);
        for (ResourceUpdater.LinkProperty cur : newLinks) {
            this.writeLinkToXML(xmlHelper, cur, linkName);
        }
        xmlHelper.endElement(linkName);
        xmlHelper.endDocument();
        try {
            return xmlHelper.getString();
        }
        catch (XMLHelper.XMLSerializeException ex) {
            throw new TeamRepositoryException(Messages.getString("QMPreVersion1ResourceUpdater_ERROR_WRITE"));
        }
    }

    private void writeLinkToXML(XMLHelper xml, ResourceUpdater.LinkProperty link, Property linkName) {
        AttributesImpl attributes = xml.createAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", link.getLinkUri());
        xml.addAttribute(attributes, "http://open-services.net/xmlns/qm/1.0/", "label", link.getLinkComment());
        xml.startElement(linkName, (Attributes)attributes);
        xml.endElement(linkName);
    }
}

