/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.AttributesImpl;

public class QMBackLinkOperationPreV1
extends CALMBackLinkOperation {
    private static final QName OSLC_QM_COLLECTION = new QName("http://open-services.net/xmlns/qm/1.0/", "collref");
    private String fLinkCollectionUrl;

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        OSLCResource resource = super.loadResource(this.getBackLink().getSourceURL());
        CALMDocument document = new CALMDocument(resource.getContent());
        QName backLinkName = this.getBackLinkElement().getQualifiedName();
        XPathQuery collectionPath = new XPathQuery().add('/').addRef(this.getElementName()).add('/').addRef(backLinkName).add("/@").addRef(OSLC_QM_COLLECTION);
        this.fLinkCollectionUrl = document.getText(collectionPath);
        try {
            new URI(this.fLinkCollectionUrl);
        }
        catch (URISyntaxException ex) {
            String message = MessageFormat.format(Messages.getString("CALMBackLinkOperation.ERROR_NO_LINK_IN_RESOURCE"), collectionPath);
            throw new TeamRepositoryException(message, (Throwable)ex);
        }
        OSLCResource linkResource = super.loadResource(this.fLinkCollectionUrl);
        document = new CALMDocument(linkResource.getContent());
        XPathQuery nodesPath = new XPathQuery().add('/').addRef(backLinkName).add('/').addRef(backLinkName);
        NodeList nodes = document.getNodes(nodesPath);
        return this.parseBackLinks(nodes, document);
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        super.storeResource(this.replaceLinkCollection(newLinks));
    }

    @Override
    public CALMBackLinkOperation clone() {
        QMBackLinkOperationPreV1 result = new QMBackLinkOperationPreV1();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }

    private List<CALMBackLink> parseBackLinks(NodeList xmlNodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>(xmlNodes.getLength());
        int idx = 0;
        while (idx < xmlNodes.getLength()) {
            Node curNode = xmlNodes.item(idx);
            XPathQuery resourcePath = new XPathQuery("./@").addRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            XPathQuery labelPath = new XPathQuery("./@").addRef("http://open-services.net/xmlns/qm/1.0/", "label");
            String curTarget = document.getText(resourcePath, (Object)curNode);
            String curLabel = document.getText(labelPath, (Object)curNode);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(this.createBackLink(curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private String replaceLinkCollection(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        QName backLinkName = this.getBackLinkElement().getQualifiedName();
        XMLHelper xmlHelper = new XMLHelper(new ContentType(this.getContentType()), HttpUtil.CharsetEncoding.UTF8.toCharset());
        xmlHelper.startDocument();
        xmlHelper.startElement(backLinkName.getNamespaceURI(), backLinkName.getLocalPart());
        for (CALMBackLink cur : newLinks) {
            this.writeLinkToXML(xmlHelper, cur);
        }
        xmlHelper.endElement(backLinkName.getNamespaceURI(), backLinkName.getLocalPart());
        xmlHelper.endDocument();
        try {
            return xmlHelper.getString();
        }
        catch (XMLHelper.XMLSerializeException ex) {
            throw this.newGeneralError(ex);
        }
    }

    private void writeLinkToXML(XMLHelper xml, CALMBackLink link) {
        AttributesImpl attributes = xml.createAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", link.getTargetURL());
        xml.addAttribute(attributes, "http://open-services.net/xmlns/qm/1.0/", "label", link.getLinkComment());
        QName backLinkName = this.getBackLinkElement().getQualifiedName();
        xml.startElement(backLinkName.getNamespaceURI(), backLinkName.getLocalPart(), attributes);
        xml.endElement(backLinkName.getNamespaceURI(), backLinkName.getLocalPart());
    }
}

