/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.OSLCResourceLogger;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.ConfigurationManagementUtil;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.calm.foundation.common.oslc.DublinCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class CoreVersion2ResourceUpdater
extends ResourceUpdater {
    private static final String SUPPORT_LINK_DISCOVERY_VIA_LINK_INDEX_PROVIDER = "supportLinkDiscoveryViaLinkIndexProvider";
    private static final String SUPPORT_LINK_DISCOVERY_VIA_OSLC_QUERIES = "supportLinkDiscoveryViaOSLCQueries";
    private static final String DISCOVERY_LINK_TYPE = "discoversLinkType";
    private Model fDocument;
    private CustomNamespaceContext fNamespaceContext;
    private String fConfigurationManagementHeader = null;
    private boolean fSupportLinkDiscoveryViaLinkIndexProvider = false;
    private boolean fSupportLinkDiscoveryViaOSLCQueries = false;
    private ArrayList<String> fDiscoversLinkTypes = new ArrayList();

    public void setConfigurationManagementHeader(String configurationManagementHeader) {
        this.fConfigurationManagementHeader = configurationManagementHeader;
    }

    @Override
    public void load(String ... propertyIds) throws TeamRepositoryException, UnsupportedVersionException {
        if (this.fConfigurationManagementHeader != null) {
            HashMap<String, String> extraHeaders = new HashMap<String, String>();
            extraHeaders.put("Configuration-Context", this.fConfigurationManagementHeader);
            this.load(extraHeaders, propertyIds);
        } else {
            this.load((Map<String, String>)null, propertyIds);
        }
    }

    @Override
    public void addLink(String propertyId, String targetURL, String comment) {
        if (this.determineIfBacklinksAreSupported(propertyId)) {
            super.addLink(propertyId, targetURL, comment);
        }
    }

    @Override
    public void removeLink(String propertyId, String targetURL) {
        if (this.determineIfBacklinksAreSupported(propertyId)) {
            super.removeLink(propertyId, targetURL);
        }
    }

    @Override
    public boolean requiresBacklink(Collection<String> propertyIds) {
        for (String propertyId : propertyIds) {
            if (this.determineIfBacklinksAreSupported(propertyId)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        try {
            String resourceUrl = resource.getURL();
            resourceUrl = ConfigurationManagementUtil.removeConfigurationParameter(resourceUrl);
            this.fDocument = ModelFactory.createDefaultModel().read(resource.getContentStream(), resourceUrl);
            Resource source = this.fDocument.getResource(resourceUrl);
            this.populateSupportLinkDiscoveryProperties(propertyDescriptions, source);
            for (OSLCResourceDescription.ResourcePropertyDescription propertyDescription : propertyDescriptions) {
                RDFNode cur;
                NodeIterator targets;
                ArrayList<ResourceUpdater.LinkProperty> links = new ArrayList<ResourceUpdater.LinkProperty>();
                Property linkProp = this.fDocument.getProperty(propertyDescription.getProperty().getNamespaceURI(), propertyDescription.getProperty().getName());
                if (propertyDescription.getType() == OSLCResourceDescription.PropertyType.LINK) {
                    targets = this.fDocument.listObjectsOfProperty(source, linkProp);
                    try {
                        while (targets.hasNext()) {
                            cur = targets.next();
                            if (!cur.isResource()) continue;
                            Resource curTarget = cur.asResource();
                            String curLabelText = this.getLinkLabel(source, linkProp, curTarget);
                            links.add(new ResourceUpdater.LinkProperty(propertyDescription.getId(), curTarget.getURI(), curLabelText));
                        }
                    }
                    finally {
                        targets.close();
                    }
                    result.putLinkProperties(propertyDescription, links);
                    continue;
                }
                targets = this.fDocument.listObjectsOfProperty(source, linkProp);
                try {
                    while (targets.hasNext()) {
                        cur = targets.next();
                        if (!cur.isLiteral()) continue;
                        Literal literal = cur.asLiteral();
                        result.putSimpleProperty(propertyDescription, new ResourceUpdater.SimpleProperty(propertyDescription.getId(), literal.getString()));
                    }
                }
                finally {
                    targets.close();
                }
            }
            return result;
        }
        catch (JenaException ex) {
            String message = NLS.bind((String)Messages.getString("CoreBackLinkOperationV2_ERROR_PARSE"), (Object)resource.getURL(), (Object)ex.getMessage());
            throw new TeamRepositoryException(message, (Throwable)ex);
        }
    }

    private void populateSupportLinkDiscoveryProperties(Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions, Resource source) {
        String serviceProviderUri = this.getServiceProviderUri(source);
        if (serviceProviderUri != null) {
            Statement supportLinkDiscoveryViaOSLCQueriesStatement;
            Model serviceProviderModel = this.getServiceProviderModel(serviceProviderUri);
            Statement supportLinkDiscoveryViaLinkIndexProviderStatement = this.getSupportStatement(serviceProviderModel, serviceProviderUri, SUPPORT_LINK_DISCOVERY_VIA_LINK_INDEX_PROVIDER);
            if (supportLinkDiscoveryViaLinkIndexProviderStatement != null && supportLinkDiscoveryViaLinkIndexProviderStatement.getLiteral().getString().equalsIgnoreCase("true")) {
                this.fSupportLinkDiscoveryViaLinkIndexProvider = true;
            }
            if (!this.fSupportLinkDiscoveryViaLinkIndexProvider && (supportLinkDiscoveryViaOSLCQueriesStatement = this.getSupportStatement(serviceProviderModel, serviceProviderUri, SUPPORT_LINK_DISCOVERY_VIA_OSLC_QUERIES)) != null && supportLinkDiscoveryViaOSLCQueriesStatement.getLiteral().getString().equalsIgnoreCase("true")) {
                this.fSupportLinkDiscoveryViaOSLCQueries = true;
                this.populateDiscoversLinkTypePropertyList(serviceProviderModel, serviceProviderUri, DISCOVERY_LINK_TYPE);
            }
        }
    }

    private boolean determineIfBacklinksAreSupported(String propertyId) {
        return !this.fSupportLinkDiscoveryViaLinkIndexProvider && (!this.fSupportLinkDiscoveryViaOSLCQueries || !this.fDiscoversLinkTypes.contains(propertyId));
    }

    private void populateDiscoversLinkTypePropertyList(Model serviceProviderModel, String serviceProviderUri, String propertyName) {
        if (serviceProviderModel != null) {
            Resource serviceProviderResource = serviceProviderModel.getResource(serviceProviderUri);
            Property supportProviderProperty = serviceProviderModel.getProperty("http://jazz.net/xmlns/prod/jazz/process/1.0/", propertyName);
            if (serviceProviderResource != null && supportProviderProperty != null) {
                NodeIterator iterator = serviceProviderModel.listObjectsOfProperty(supportProviderProperty);
                while (iterator.hasNext()) {
                    String[] tokens;
                    int numOfTokens;
                    RDFNode node = iterator.nextNode();
                    if (!node.isResource() || (numOfTokens = (tokens = node.asResource().getURI().split("#")).length) <= 0) continue;
                    String linkType = tokens[numOfTokens - 1];
                    this.fDiscoversLinkTypes.add(linkType);
                }
            }
        }
    }

    private Statement getSupportStatement(Model serviceProviderModel, String serviceProviderUri, String propertyName) {
        if (serviceProviderModel != null) {
            Resource serviceProviderResource = serviceProviderModel.getResource(serviceProviderUri);
            Property supportProviderProperty = serviceProviderModel.getProperty("http://jazz.net/xmlns/prod/jazz/process/1.0/", propertyName);
            if (serviceProviderResource != null && supportProviderProperty != null) {
                return serviceProviderResource.getProperty(supportProviderProperty);
            }
        }
        return null;
    }

    private Model getServiceProviderModel(String serviceProviderUri) {
        IHttpClient.IResponse response = null;
        Model serviceProviderModel = null;
        try {
            response = this.perform20Get(serviceProviderUri);
        }
        catch (TeamRepositoryException ignoreServiceProviderNotFound) {
            return null;
        }
        if (response != null) {
            try {
                serviceProviderModel = ModelFactory.createDefaultModel().read(response.getResponseStream(), serviceProviderUri);
            }
            catch (JenaException jenaException) {
                // empty catch block
            }
        }
        return serviceProviderModel;
    }

    private IHttpClient.IResponse perform20Get(String uri) throws TeamRepositoryException {
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("OSLC-Core-Version", OSLCCoreIdentifiers.VERSION_OSLC_CORE_20.getIdentifier());
        return this.getHttpClient().performGet(uri, headers);
    }

    private String getServiceProviderUri(Resource source) {
        Property serviceProviderProperty = this.fDocument.createProperty(OSLCCoreIdentifiers.SERVICE_PROVIDER.toString());
        Statement serviceProviderStatement = source.getProperty(serviceProviderProperty);
        return serviceProviderStatement == null ? null : serviceProviderStatement.getResource().getURI();
    }

    protected Model getDocument() {
        return this.fDocument;
    }

    public CustomNamespaceContext getNamespaceContext() {
        if (this.fNamespaceContext == null) {
            this.fNamespaceContext = new CustomNamespaceContext(this.fDocument.getNsPrefixMap());
        }
        return this.fNamespaceContext;
    }

    /*
     * Exception decompiling
     */
    private String getLinkLabel(Resource source, Property linkProperty, Resource target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Property createProperty(String nsUri, String localName) {
        CustomNamespaceContext nsContext = this.getNamespaceContext();
        if (this.fDocument.getNsURIPrefix(nsUri) == null) {
            this.fDocument.setNsPrefix(nsContext.getPrefix(nsUri), nsUri);
        }
        return this.fDocument.createProperty(nsUri, localName);
    }

    @Override
    protected String storeContent(ResourceUpdater.ResourceContent updatedLinks) throws TeamRepositoryException {
        if (this.fDocument == null) {
            throw new IllegalArgumentException("write can only be called after a successfull load.");
        }
        Resource source = this.fDocument.getResource(this.getResourceURL());
        this.prepareResource(source);
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : updatedLinks.getLinkPropertySet()) {
            OSLCResourceDescription.ResourcePropertyDescription desc = entry.getKey();
            Property linkProperty = this.fDocument.createProperty(desc.getProperty().getNamespaceURI(), desc.getProperty().getName());
            this.prepareProperty(source, linkProperty);
            for (ResourceUpdater.LinkProperty cur : entry.getValue()) {
                Resource target = this.fDocument.createResource(cur.getLinkUri());
                source.addProperty(linkProperty, (RDFNode)target);
                Statement curLink = this.fDocument.createStatement(source, this.createProperty(desc.getProperty().getNamespaceURI(), desc.getProperty().getName()), (RDFNode)target);
                String labelText = cur.getLinkComment();
                if (labelText == null || labelText.length() <= 0) continue;
                ReifiedStatement curLabel = curLink.createReifiedStatement();
                curLabel.addProperty(this.createProperty(DublinCoreIdentifiers.TITLE.getNamespaceURI(), DublinCoreIdentifiers.TITLE.getName()), labelText);
            }
        }
        return this.writeToString(this.fDocument);
    }

    protected String writeToString(Model document) {
        StringWriter result = new StringWriter();
        document.write((Writer)result);
        if (OSLCResourceLogger.getLog().isDebugEnabled()) {
            OSLCResourceLogger.getLog().debug((Object)("[CoreVersion2ResourceUpdater storeContent] Storing content:\n" + OSLCResourceLogger.getXMLLogString(result.getBuffer().toString())));
        }
        return result.getBuffer().toString();
    }

    protected void prepareResource(Resource source) {
    }

    protected void prepareProperty(Resource source, Property linkProperty) {
        try (StmtIterator propIt = source.listProperties(linkProperty);){
            while (propIt.hasNext()) {
                Statement curProp = (Statement)propIt.next();
                try (RSIterator reifiedIt = curProp.listReifiedStatements();){
                    while (reifiedIt.hasNext()) {
                        ReifiedStatement curReified = (ReifiedStatement)reifiedIt.next();
                        curReified.removeProperties();
                    }
                }
                curProp.removeReification();
                propIt.remove();
            }
        }
    }

    protected ArrayList<String> getDiscoverLinkTypes() {
        return this.fDiscoversLinkTypes;
    }
}

