/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.internal.RDFUtils;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.CoreBackLinkOperationV2;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.StringWriter;
import java.io.Writer;

public class CoreBackLinkOperationV2Partial
extends CoreBackLinkOperationV2 {
    @Override
    protected void prepareResource(Resource source, Property linkProperty) {
        Property rdfTypeProperty = RDFUtils.toJena(RDFIdentifiers.TYPE, source.getModel());
        Statement rdfType = source.getProperty(rdfTypeProperty);
        source.removeProperties();
        if (rdfType != null) {
            source.addProperty(rdfType.getPredicate(), rdfType.getObject());
        }
    }

    @Override
    protected void store(Model document) throws TeamRepositoryException {
        Resource source = document.getResource(this.getBackLink().getSourceURL());
        String parameters = this.createParameters(source);
        super.storeResource(this.writeToString(document), parameters);
    }

    private String createParameters(Resource source) {
        CustomNamespaceContext context = new CustomNamespaceContext(source.getModel().getNsPrefixMap());
        CALMLinkTypeInformation.BackLinkElement property = this.getBackLinkElement();
        String properties = context.qualify(property.getNamespaceURI(), property.getTypeId());
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append(context.getPrefix(property.getNamespaceURI()));
        prefixBuilder.append("=<");
        prefixBuilder.append(property.getNamespaceURI());
        prefixBuilder.append('>');
        StringBuilder parameterBuilder = new StringBuilder();
        parameterBuilder.append(OSLCCoreIdentifiers.PARAM_PROPERTIES);
        parameterBuilder.append('=');
        parameterBuilder.append(UriUtil.encode((String)properties));
        parameterBuilder.append('&');
        parameterBuilder.append(OSLCCoreIdentifiers.PARAM_PREFIX);
        parameterBuilder.append('=');
        parameterBuilder.append(UriUtil.encode((String)prefixBuilder.toString()));
        return parameterBuilder.toString();
    }

    private String writeToString(Model document) {
        StringWriter result = new StringWriter();
        document.write((Writer)result, "RDF/XML-ABBREV");
        return result.getBuffer().toString();
    }

    @Override
    public CALMBackLinkOperation clone() {
        CoreBackLinkOperationV2Partial result = new CoreBackLinkOperationV2Partial();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }
}

