/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.repository.common.transport.UriUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ConfigurationManagementUtil {
    public static final String OSLC_CONFIG_CONTEXT_PARAM = "oslc_config.context";
    public static final Property PARAM_CONFIG_CONTEXT = new Property("oslc_config.context");

    public static String getConfigurationParameter(String uri) {
        if (uri == null) {
            return "";
        }
        int index = uri.indexOf("?");
        if (index < 0) {
            index = uri.indexOf("#");
        }
        String query = uri.substring(index + 1);
        Map parsedParameters = UriUtil.parseQueryParameters((String)query);
        for (String parameter : parsedParameters.keySet()) {
            if (!parameter.equals(OSLC_CONFIG_CONTEXT_PARAM)) continue;
            return ((String[])parsedParameters.get(parameter))[0];
        }
        return "";
    }

    public static String removeConfigurationParameter(String url) {
        if (url == null) {
            return null;
        }
        String result = url.replaceAll("oslc_config.context=.*?($|[&;])", "");
        result = result.replaceAll("[&|?]$", "");
        return result;
    }

    public static String appendConfigurationURIParameter(String baseURI, String configurationURI, boolean encodeConfigurationURI) {
        if (baseURI == null) {
            return null;
        }
        String resultURI = baseURI;
        if (configurationURI != null && configurationURI.length() > 0) {
            int urlParameterIndex = resultURI.indexOf("?");
            if (urlParameterIndex == -1) {
                urlParameterIndex = resultURI.indexOf("#");
            }
            resultURI = String.valueOf(resultURI) + (urlParameterIndex == -1 ? "?" : "&");
            resultURI = String.valueOf(resultURI) + "oslc_config.context=" + (encodeConfigurationURI ? UriUtil.encode((String)configurationURI) : configurationURI);
        }
        return resultURI;
    }

    public static void appendConfigurationURIParameter(StringBuilder baseURI, String configurationURI) {
        if (baseURI != null && configurationURI != null && configurationURI.length() > 0) {
            baseURI.append(baseURI.indexOf("?") == -1 && baseURI.indexOf("#") == -1 ? "?" : "&");
            baseURI.append("oslc_config.context=" + UriUtil.encode((String)configurationURI));
        }
    }

    public static Map<String, Collection<String>> buildGlobalConfigurationToResourceUrlMap(Collection<String> inputResourceURLs) {
        HashMap<String, Collection<String>> globalConfigurationToInputResourceURLMap = new HashMap<String, Collection<String>>();
        globalConfigurationToInputResourceURLMap.put("", new HashSet());
        if (inputResourceURLs == null) {
            return globalConfigurationToInputResourceURLMap;
        }
        for (String resourceURL : inputResourceURLs) {
            String globalConfiguration = ConfigurationManagementUtil.getConfigurationParameter(resourceURL);
            String conceptURL = ConfigurationManagementUtil.removeConfigurationParameter(resourceURL);
            HashSet<String> currentCollectionOfResourceURLs = (HashSet<String>)globalConfigurationToInputResourceURLMap.get(globalConfiguration);
            if (currentCollectionOfResourceURLs == null) {
                currentCollectionOfResourceURLs = new HashSet<String>();
                globalConfigurationToInputResourceURLMap.put(globalConfiguration, currentCollectionOfResourceURLs);
            }
            currentCollectionOfResourceURLs.add(conceptURL);
        }
        return globalConfigurationToInputResourceURLMap;
    }
}

