/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.HttpClientWrapper;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.calm.foundation.common.linking.CALMBackLinkUpdater;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;

public abstract class CALMBackLinkOperation {
    public static boolean USE_RESOURCE_UPDATER = true;
    private final CustomNamespaceContext fNamespaces = Namespaces.createDefaultContext();
    private CALMBackLink fBackLink;
    private OSLCResource fResource;
    private CALMBackLinkUpdater.OperationType fOperationType;
    private String fVersion;
    private IHttpClient fHttpAccess;
    private QName fElementName;
    private String fContentType;
    private List<CALMBackLink> fExistingLinks;
    private boolean fHasLinkRemoved = false;
    private Map<String, String> fHeaders;
    private ResourceUpdater fResourceUpdater;

    public void initialize(CALMBackLink backLink, OperationType opType, IHttpAccess httpAccess) {
        this.initialize(backLink, opType.toNew(), new HttpClientWrapper(httpAccess));
    }

    public void initialize(CALMBackLink backLink, CALMBackLinkUpdater.OperationType opType, IHttpClient httpAccess) {
        Assert.isNotNull((Object)backLink);
        Assert.isNotNull((Object)((Object)opType));
        Assert.isNotNull((Object)httpAccess);
        this.fBackLink = backLink;
        this.fHttpAccess = httpAccess;
        this.fOperationType = opType;
    }

    public CALMBackLink getBackLink() {
        return this.fBackLink;
    }

    public CALMLinkTypeInformation.BackLinkElement getBackLinkElement() {
        return this.fBackLink.getLinkType().getBackLinkElement(this.fVersion);
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String version) {
        this.fVersion = version;
    }

    public CALMBackLinkUpdater.OperationType getOperationType() {
        return this.fOperationType;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    public IHttpClient getResourceAccess() {
        return this.fHttpAccess;
    }

    public QName getElementName() {
        return this.fElementName;
    }

    public void setElementName(QName elementName) {
        this.fElementName = elementName;
    }

    public void setHttpHeaders(Map<String, String> headers) {
        this.fHeaders = headers;
    }

    public Map<String, String> getHttpHeaders() {
        return this.fHeaders != null ? this.fHeaders : Collections.emptyMap();
    }

    protected boolean hasLinkRemoved() {
        return this.fHasLinkRemoved;
    }

    public void loadExistingState() throws TeamRepositoryException, UnsupportedVersionException {
        if (this.fBackLink.getLinkType().hasBackLinkElement(this.fVersion)) {
            this.fExistingLinks = USE_RESOURCE_UPDATER ? this.loadExistingLinksWithResourceUpdater() : this.loadExistingLinks();
        } else {
            throw new UnsupportedVersionException(this.fContentType);
        }
    }

    protected List<CALMBackLink> getExistingLinks() {
        return this.fExistingLinks;
    }

    public void writeModications() throws TeamRepositoryException {
        if (this.fExistingLinks == null) {
            return;
        }
        if (USE_RESOURCE_UPDATER) {
            CALMBackLink backLink = this.getBackLink();
            CALMLinkTypeInformation linkType = backLink.getLinkType();
            String targetPropertyId = linkType.getTargetResourceBackLinkProperty();
            if (this.getOperationType() == CALMBackLinkUpdater.OperationType.ADD) {
                this.fResourceUpdater.addLink(targetPropertyId, backLink.getTargetURL(), backLink.getLinkComment());
            } else {
                this.fResourceUpdater.removeLink(targetPropertyId, backLink.getTargetURL());
            }
            this.fResourceUpdater.write();
            return;
        }
        ArrayList<CALMBackLink> newLinks = new ArrayList<CALMBackLink>(this.fExistingLinks);
        Iterator it = newLinks.iterator();
        while (it.hasNext()) {
            CALMBackLink curLink = (CALMBackLink)it.next();
            if (!this.getBackLink().getTargetURL().equals(curLink.getTargetURL())) continue;
            it.remove();
            this.fHasLinkRemoved = true;
        }
        if (this.fOperationType == CALMBackLinkUpdater.OperationType.ADD) {
            newLinks.add(this.fBackLink);
        }
        this.storeLinks(newLinks);
    }

    public void revertModications() throws TeamRepositoryException {
        if (this.fExistingLinks == null) {
            return;
        }
        if (USE_RESOURCE_UPDATER) {
            this.fResourceUpdater.revert();
        } else {
            this.fHasLinkRemoved = true;
            this.storeLinks(this.fExistingLinks);
        }
    }

    public abstract CALMBackLinkOperation clone();

    protected CustomNamespaceContext getNamespaces() {
        return this.fNamespaces;
    }

    protected CALMBackLink createBackLink(String target, String label) {
        return new CALMBackLink(this.fBackLink.getLinkType(), this.fBackLink.getSourceURL(), target, label);
    }

    protected String writeDocumentContent(Document doc) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(doc), result);
            return result.getWriter().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    private List<CALMBackLink> loadExistingLinksWithResourceUpdater() throws TeamRepositoryException, UnsupportedVersionException {
        CALMBackLink backLink = this.getBackLink();
        CALMLinkTypeInformation linkType = backLink.getLinkType();
        String targetPropertyId = linkType.getTargetResourceBackLinkProperty();
        if (targetPropertyId == null) {
            throw new UnsupportedVersionException(MessageFormat.format(Messages.getString("CALMBackLinkOperation.NO_BACKLINK_SUPPORT"), linkType.getItemLinkTypeId()));
        }
        OSLCResourceDescription.ResourceVersion resourceVersion = linkType.getTargetResourceDescription().getResourceVersion(this.getVersion());
        ResourceUpdater resourceUpdater = resourceVersion.createResourceUpdater(backLink.getSourceURL(), this.getResourceAccess());
        if (resourceUpdater == null) {
            throw new UnsupportedVersionException(MessageFormat.format("No support to update the resource of type {0}", linkType.getTargetResourceDescription().getResourceLabel()));
        }
        resourceUpdater.load(targetPropertyId);
        this.fResourceUpdater = resourceUpdater;
        List<ResourceUpdater.LinkProperty> links = resourceUpdater.getLinks(targetPropertyId);
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>();
        for (ResourceUpdater.LinkProperty link : links) {
            result.add(this.createBackLink(link.getLinkUri(), link.getLinkComment()));
        }
        return result;
    }

    public abstract List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException;

    public abstract void storeLinks(List<CALMBackLink> var1) throws TeamRepositoryException;

    protected OSLCResource loadResource(String resourceURL) throws UnsupportedVersionException, TeamRepositoryException {
        OSLCResourceDescription resourceDescription = this.fBackLink.getLinkType().getTargetResourceDescription();
        this.fResource = resourceDescription.loadResource(resourceURL, this.fVersion, this.fHttpAccess);
        if (this.fResource != null) {
            return this.fResource;
        }
        throw new UnsupportedVersionException(MessageFormat.format(Messages.getString("CALMBackLinkOperation.NO_RESOURCE_DESCRIPTION"), resourceDescription.getResourceLabel(), this.fVersion));
    }

    public void storeResource(String content) throws TeamRepositoryException {
        this.storeResource(content, null);
    }

    public void storeResource(String content, String parameters) throws TeamRepositoryException {
        if (this.fResource != null) {
            this.fResource.write(this.fHttpAccess, content, parameters);
        }
    }

    protected TeamRepositoryException newGeneralError(Exception ex) {
        String message = null;
        message = this.fOperationType == CALMBackLinkUpdater.OperationType.ADD ? Messages.getString("CALMBackLinkOperation.ERROR_CREATING_BACKLINK") : Messages.getString("CALMBackLinkOperation.ERROR_DELETING_BACKLINK");
        return new TeamRepositoryException(MessageFormat.format(message, this.getBackLink().getLinkComment(), ex.getMessage()), (Throwable)ex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fBackLink == null ? 0 : this.fBackLink.hashCode());
        result = 31 * result + (this.fContentType == null ? 0 : this.fContentType.hashCode());
        result = 31 * result + (this.fElementName == null ? 0 : this.fElementName.hashCode());
        result = 31 * result + (this.fOperationType == null ? 0 : this.fOperationType.hashCode());
        result = 31 * result + (this.fVersion == null ? 0 : this.fVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CALMBackLinkOperation other = (CALMBackLinkOperation)obj;
        if (this.fBackLink == null ? other.fBackLink != null : !this.fBackLink.equals(other.fBackLink)) {
            return false;
        }
        if (this.fContentType == null ? other.fContentType != null : !this.fContentType.equals(other.fContentType)) {
            return false;
        }
        if (this.fElementName == null ? other.fElementName != null : !this.fElementName.equals(other.fElementName)) {
            return false;
        }
        if (this.fOperationType == null ? other.fOperationType != null : !this.fOperationType.equals((Object)other.fOperationType)) {
            return false;
        }
        return !(this.fVersion == null ? other.fVersion != null : !this.fVersion.equals(other.fVersion));
    }

    public static enum OperationType {
        ADD,
        REMOVE;


        public CALMBackLinkUpdater.OperationType toNew() {
            return this == ADD ? CALMBackLinkUpdater.OperationType.ADD : CALMBackLinkUpdater.OperationType.REMOVE;
        }
    }
}

