/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal;

import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;

public class Response
implements IHttpClient.IResponse {
    private final HttpHeaders fHeaders;
    private String fContent;
    private InputStream fStream;
    private final int fStatusCode;
    private final Throwable fException;

    public Response(int statusCode, HttpHeaders headers, InputStream stream) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        this.fStatusCode = statusCode;
        this.fHeaders = headers;
        this.fStream = stream;
        this.fContent = null;
        this.fException = null;
    }

    public Response(int statusCode, HttpHeaders headers, Throwable exception) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        this.fStatusCode = statusCode;
        this.fHeaders = headers;
        this.fStream = null;
        this.fContent = null;
        this.fException = exception;
    }

    @Override
    public int getStatusCode() {
        return this.fStatusCode;
    }

    @Override
    public String getContent() throws TeamRepositoryException {
        if (this.fContent == null) {
            this.fContent = this.readResponse();
        }
        return this.fContent;
    }

    @Override
    public HttpHeaders getResponseHeaders() {
        return this.fHeaders;
    }

    @Override
    public InputStream getResponseStream() {
        return this.fStream;
    }

    @Override
    public Reader getResponseReader() throws TeamRepositoryException {
        if (this.fStream != null) {
            try {
                return new InputStreamReader(this.fStream, this.getEncoding("UTF-8"));
            }
            catch (IOException ex) {
                throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public Throwable getException() {
        return this.fException;
    }

    private String readResponse() throws TeamRepositoryException {
        try {
            if (this.fStream != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
                byte[] bytes = new byte[8192];
                try {
                    int ch = this.fStream.read(bytes);
                    while (ch != -1) {
                        buffer.write(bytes, 0, ch);
                        ch = this.fStream.read(bytes);
                    }
                }
                finally {
                    if (this.fStream != null) {
                        this.fStream.close();
                    }
                }
                return buffer.toString(this.getEncoding("UTF-8"));
            }
            return new String();
        }
        catch (IOException ex) {
            throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getEncoding(String defaultCharset) {
        NameValuePair param;
        HeaderElement[] values;
        String contentTypeHeader = this.getResponseHeaders().getValue("Content-Type");
        if (contentTypeHeader != null && (values = BasicHeaderValueParser.parseElements((String)contentTypeHeader, null)).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            return param.getValue();
        }
        return defaultCharset;
    }
}

