/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.ibm.team.calm.foundation.common.ContentType;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.XMLHelper;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;

public class RDFUtils {
    public static final String RDF_XML = "RDF/XML";
    public static final String RDF_XML_ABBREV = "RDF/XML-ABBREV";
    public static final String TURTLE = "TURTLE";
    public static final String N3 = "N3";
    private static final char COLON = ':';
    private static final String SCHEME_POSTFIX = "://";
    private static final char FWD_SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final String SCHEME_HTTPS = "https";
    private static final Log log = LogFactory.getLog(RDFUtils.class);

    public static String toXML(InputStream input, String resourceURL) throws XMLHelper.XMLSerializeException, RDFParseException {
        try {
            Model model = ModelFactory.createDefaultModel();
            model.read(input, resourceURL);
            return RDFUtils.toXML(model, resourceURL);
        }
        catch (JenaException e) {
            String message = NLS.bind((String)Messages.getString("RDFUtils.ERROR_PARSING"), (Object)resourceURL, (Object)e.getMessage());
            throw new RDFParseException(message, (Exception)((Object)e));
        }
    }

    public static String toXML(Model model, String resourceURL) throws XMLHelper.XMLSerializeException, RDFParseException {
        HashMap<String, String> namespaces = new HashMap<String, String>(model.getNsPrefixMap());
        namespaces.remove(null);
        namespaces.remove("");
        CustomNamespaceContext context = new CustomNamespaceContext(namespaces);
        XMLHelper xmlHelper = new XMLHelper(ContentType.XML, HttpUtil.CharsetEncoding.UTF8.toCharset(), context);
        String namespace = RDFIdentifiers.DESCRIPTION.getNamespaceURI();
        String name = RDFIdentifiers.DESCRIPTION.getName();
        Resource resource = RDFUtils.findResource(model, resourceURL);
        HashSet<String> visitedResources = new HashSet<String>();
        visitedResources.add(RDFUtils.getKey(resource));
        RDFUtils.toXML(xmlHelper, namespace, name, resource, visitedResources);
        String result = xmlHelper.getString();
        return result;
    }

    public static Resource findResource(Model model, String resourceURL) throws RDFParseException {
        Resource resource = model.getResource(resourceURL);
        if (!resource.listProperties().hasNext()) {
            String normalizedResourceURL = RDFUtils.normalize(resourceURL);
            ResIterator subjects = model.listSubjects();
            while (subjects.hasNext()) {
                Resource curr = subjects.nextResource();
                if (!curr.isURIResource() || !normalizedResourceURL.startsWith(RDFUtils.normalize(curr.getURI()))) continue;
                return curr;
            }
            String message = NLS.bind((String)Messages.getString("RDFUtils.ERROR_PARSING_RDF_FOR_RESOURCE"), (Object)resourceURL, (Object)resourceURL);
            throw new RDFParseException(message);
        }
        return resource;
    }

    public static boolean isValidRDFXMLProperty(Property property) {
        String uriref = property.toString();
        return Util.splitNamespace((String)uriref) != uriref.length();
    }

    private static void toXML(XMLHelper helper, String nsUri, String localName, Resource resource, HashSet<String> visitedResources) throws XMLHelper.XMLSerializeException {
        Attributes attributes = resource.isURIResource() ? helper.createAttribute(RDFIdentifiers.ABOUT, resource.getURI()) : XMLHelper.NO_ATTRIBUTES;
        helper.startElement(nsUri, localName, attributes);
        StmtIterator iterator = resource.listProperties();
        while (iterator.hasNext()) {
            RDFNode rdfNode;
            Statement statement = iterator.nextStatement();
            com.hp.hpl.jena.rdf.model.Property property = statement.getPredicate();
            String keyNs = property.getNameSpace();
            String keyName = property.getLocalName();
            if (keyNs.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && keyName.startsWith("_")) {
                keyName = "li";
            }
            if ((rdfNode = statement.getObject()) instanceof Literal) {
                String val = ((Literal)rdfNode).getString();
                helper.startElement(keyNs, keyName).characters(val).endElement(keyNs, keyName);
                continue;
            }
            if (rdfNode instanceof Resource) {
                Resource resourceNode = (Resource)rdfNode;
                if (resourceNode.isURIResource() && !resourceNode.listProperties().hasNext()) {
                    String val = resourceNode.getURI();
                    helper.startElement(keyNs, keyName).characters(val).endElement(keyNs, keyName);
                    continue;
                }
                String resourceKey = RDFUtils.getKey(resourceNode);
                if (visitedResources.contains(resourceKey)) continue;
                visitedResources.add(resourceKey);
                RDFUtils.toXML(helper, keyNs, keyName, resourceNode, visitedResources);
                continue;
            }
            throw new XMLHelper.XMLSerializeException(Messages.getString("RDFUtils.ERROR_UNKNOWN_NODE"));
        }
        helper.endElement(nsUri, localName);
    }

    private static String getKey(Resource resource) {
        String key = resource.getURI();
        if (key == null || key.length() == 0) {
            key = resource.getId().getLabelString();
        }
        return key;
    }

    public static com.hp.hpl.jena.rdf.model.Property toJena(Property property, Model model) {
        return model.createProperty(property.getNamespaceURI(), property.getName());
    }

    private static String normalize(String uri) {
        URI workingUri;
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        try {
            workingUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            return uri;
        }
        if (!workingUri.isAbsolute() || workingUri.isOpaque()) {
            return uri;
        }
        StringBuilder strBuilder = new StringBuilder();
        String lowerCaseScheme = workingUri.getScheme().toLowerCase(Locale.ROOT);
        strBuilder.append(lowerCaseScheme);
        strBuilder.append(SCHEME_POSTFIX);
        strBuilder.append(workingUri.getHost().toLowerCase(Locale.ROOT));
        strBuilder.append(':');
        int port = workingUri.getPort();
        strBuilder.append(port == -1 ? (lowerCaseScheme.equals(SCHEME_HTTPS) ? 443 : 80) : port);
        String path = workingUri.getRawPath();
        strBuilder.append(path == null || path.length() == 0 ? Character.valueOf('/') : path);
        String query = workingUri.getRawQuery();
        if (query != null && query.length() > 0) {
            strBuilder.append('?');
            strBuilder.append(query);
        }
        return strBuilder.toString();
    }

    public static String getValueAsPlainText(Literal literal) throws TeamRepositoryException {
        RDFDatatype dataType = literal.getDatatype();
        if (dataType == null || XSDDatatype.XSDstring.getURI().equals(dataType.getURI())) {
            return literal.getString();
        }
        if (XMLLiteralType.theXMLLiteralType.getURI().equals(dataType.getURI())) {
            String strValue = literal.getLexicalForm();
            String plainText = XMLString.createFromXMLText((String)strValue).getPlainText();
            return plainText;
        }
        String msg = "Get plain string from unexpected data type: " + dataType.getURI();
        log.warn((Object)msg);
        try {
            return literal.getString();
        }
        catch (RuntimeException e) {
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
    }

    public static class RDFParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RDFParseException(String message) {
            super(message);
        }

        public RDFParseException(String message, Exception e) {
            super(message, e);
        }
    }
}

