/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal;

import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import java.util.Properties;

public class OSLCResourceAccess {
    public static final String OSLC_CM_VERSION1_PROPERTY = "com.ibm.team.workitem.use.oslc-cm1";
    public static final String OSLC_RM_VERSION1_PROPERTY = "com.ibm.team.workitem.use.oslc-rm1";
    public static final String OSLC_QM_VERSION1_PROPERTY = "com.ibm.team.workitem.use.oslc-qm1";
    private static boolean fgUseOslcCMVersion1 = false;
    private static boolean fgUseOslcQMVersion1 = false;
    private static boolean fgUseOslcRMVersion1 = false;

    private OSLCResourceAccess() {
    }

    public static boolean useOslcVersion1(OSLCResourceDescription resourceDescription) {
        Properties properties = System.getProperties();
        String oslcDomain = resourceDescription.getOSLCDomain();
        if ("oslc_cm".equals(oslcDomain)) {
            return properties.containsKey(OSLC_CM_VERSION1_PROPERTY) ? Boolean.parseBoolean(properties.getProperty(OSLC_CM_VERSION1_PROPERTY)) : fgUseOslcCMVersion1;
        }
        if ("oslc_qm".equals(oslcDomain)) {
            return properties.containsKey(OSLC_QM_VERSION1_PROPERTY) ? Boolean.parseBoolean(properties.getProperty(OSLC_QM_VERSION1_PROPERTY)) : fgUseOslcQMVersion1;
        }
        if ("oslc_rm".equals(oslcDomain)) {
            return properties.containsKey(OSLC_RM_VERSION1_PROPERTY) ? Boolean.parseBoolean(properties.getProperty(OSLC_RM_VERSION1_PROPERTY)) : fgUseOslcRMVersion1;
        }
        return false;
    }
}

