/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal;

import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.OSLCResourceLogger;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.oslc.Version;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;

public class OSLCResource {
    private String fLastETag;
    private String fContent;
    private final String fResourceUrl;
    private final String fContentType;
    private final Map<String, String> fExtraHeaders;
    private final OSLCResourceDescription fResourceType;
    private final String fResourceVersion;

    public static OSLCResource loadResource(IHttpClient client, String resourceUrl, String parameters, OSLCResourceDescription.AbstractResourceVersion resourceVersion) throws TeamRepositoryException, UnsupportedVersionException {
        return OSLCResource.loadResource(client, resourceUrl, parameters, resourceVersion.getContentType(), resourceVersion.getHttpHeaders(), resourceVersion.getOslcResource(), resourceVersion.getVersion());
    }

    public static OSLCResource loadResource(IHttpClient client, String resourceUrl, String parameters, String contentType, Map<String, String> extraHeaders, OSLCResourceDescription resourceType, String resourceVersion) throws TeamRepositoryException, UnsupportedVersionException {
        try {
            String requestURL = OSLCResource.getRequestUrl(resourceUrl, parameters);
            HttpHeaders headers = OSLCResource.createGetHttpHeaders(contentType, extraHeaders);
            IHttpClient.IResponse response = client.performGet(requestURL, headers);
            if (OSLCResource.getLog().isDebugEnabled()) {
                if (OSLCResource.isDebugEnabledForUri(resourceUrl)) {
                    OSLCResource.getLog().debug((Object)("[OSLCResource.loadResource]\nLoad Resource: " + resourceUrl + "\n" + headers.getEntries() + "\n" + OSLCResourceLogger.getXMLLogString(response.getContent()) + "\n========================="));
                } else {
                    OSLCResource.getLog().debug((Object)("[OSLCResource.loadResource] Load Resource (content not shown): " + resourceUrl));
                }
            }
            HttpHeaders responseHeaders = response.getResponseHeaders();
            if (response.getStatusCode() == 200) {
                String actualContentType;
                if (OSLCResource.isValidString(contentType) && ((actualContentType = responseHeaders.getValue("Content-Type")) == null || !actualContentType.startsWith(contentType))) {
                    throw new UnsupportedVersionException(contentType);
                }
                String expectedVersion = headers.getValue("OSLC-Core-Version");
                String actualVersion = responseHeaders.getValue("OSLC-Core-Version");
                if (OSLCResource.isValidString(expectedVersion) && !expectedVersion.equals(actualVersion)) {
                    throw new UnsupportedVersionException(contentType);
                }
                String content = response.getContent();
                String etag = responseHeaders.getValue("ETag");
                return new OSLCResource(content, etag, resourceUrl, contentType, extraHeaders, resourceType, resourceVersion);
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.getString("OSLCResourceAccess.ERROR_FAILED_TO_LOAD_RESOURCE_FROM_SERVER"), (Object)response.getStatusCode(), (Object[])new Object[0]), response.getException());
        }
        catch (NotLoggedInException ex) {
            throw ex;
        }
        catch (IHttpClient.HttpAccessException ex) {
            int statusCode = ex.getResponse().getStatusCode();
            if (statusCode == 406 || statusCode == 415 || statusCode == 302) {
                throw new UnsupportedVersionException(contentType);
            }
            throw ex;
        }
    }

    private OSLCResource(String content, String etag, String resourceUrl, String contentType, Map<String, String> extraHeaders, OSLCResourceDescription resourceType, String resourceVersion) {
        this.fContent = content;
        this.fLastETag = etag;
        this.fResourceUrl = resourceUrl;
        this.fContentType = contentType;
        this.fExtraHeaders = extraHeaders;
        this.fResourceType = resourceType;
        this.fResourceVersion = resourceVersion;
    }

    public String getURL() {
        return this.fResourceUrl;
    }

    public String getContent() {
        return this.fContent;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public InputStream getContentStream() {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(this.fContent.getBytes(HttpUtil.CharsetEncoding.UTF8.toString()));
            return new BufferedInputStream(input);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public String getState() {
        return this.fLastETag;
    }

    public OSLCResourceDescription getResourceType() {
        return this.fResourceType;
    }

    public String getVersion() {
        return this.fResourceVersion;
    }

    public boolean hasOSLCCoreVersionHeader(Version version) {
        return this.fExtraHeaders != null && version.getIdentifier().equals(this.fExtraHeaders.get("OSLC-Core-Version"));
    }

    public void write(IHttpClient client, String content, String parameters) throws TeamRepositoryException {
        this.write(client, content, parameters, this.fResourceUrl);
    }

    public static final Log getLog() {
        return OSLCResourceLogger.getLog();
    }

    public void write(IHttpClient client, String content, String parameters, String rdfAboutResourceUrl) throws TeamRepositoryException {
        try {
            HttpHeaders httpHeaders = this.getPutHeaders();
            IHttpClient.IResponse response = client.performPut(OSLCResource.getRequestUrl(rdfAboutResourceUrl, parameters), content, this.fContentType, httpHeaders);
            if (OSLCResource.getLog().isDebugEnabled()) {
                OSLCResource.getLog().debug((Object)("[OSLCResource.write]\nWrite Resource: " + rdfAboutResourceUrl + "\n" + httpHeaders.getEntries() + "\n" + OSLCResourceLogger.getXMLLogString(content) + "\n========================="));
            }
            this.fContent = content;
            this.fLastETag = response.getResponseHeaders().getValue("ETag");
        }
        catch (NotLoggedInException ex) {
            throw ex;
        }
        catch (TeamRepositoryException ex) {
            throw ex;
        }
    }

    private HttpHeaders getPutHeaders() {
        HttpHeaders headers = new HttpHeaders(2);
        headers.addHeader("Accept", this.fContentType);
        if (this.fLastETag != null) {
            headers.addHeader("If-Match", this.fLastETag);
        }
        if (this.fExtraHeaders != null) {
            for (Map.Entry<String, String> entry : this.fExtraHeaders.entrySet()) {
                headers.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return headers;
    }

    private static String getRequestUrl(String resourceURL, String parameters) {
        if (parameters == null || parameters.length() == 0) {
            return resourceURL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(resourceURL);
        builder.append(resourceURL.indexOf(63) == -1 ? (char)'?' : '&');
        builder.append(parameters);
        return builder.toString();
    }

    private static HttpHeaders createGetHttpHeaders(String contentType, Map<String, String> extraHeaders) {
        HttpHeaders headers = new HttpHeaders(2);
        headers.addHeader("Accept", contentType);
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                headers.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return headers;
    }

    private static boolean isValidString(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isDebugEnabledForUri(String requestURI) {
        return OSLCResource.getLog().isDebugEnabled() && !OSLCResourceLogger.filterRequestURI(requestURI);
    }
}

