/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class XPathQuery {
    private static final String EMPTY_XPATH = "";
    private StringBuilder fPath;
    private NamespaceContext fContext;

    public XPathQuery() {
        this(EMPTY_XPATH);
    }

    public XPathQuery(CharSequence path) {
        this.fPath = new StringBuilder(path);
        this.fContext = Namespaces.createDefaultContext();
    }

    public XPathQuery(CharSequence path, NamespaceContext namespaceContext) {
        this.fPath = new StringBuilder(path);
        this.fContext = namespaceContext;
    }

    public XPathQuery(QName ref) {
        this(EMPTY_XPATH);
        this.addRef(ref);
    }

    public XPathQuery addRef(String nsURI, String name) {
        String prefix = this.fContext.getPrefix(nsURI);
        this.fPath.append(prefix).append(':').append(name);
        return this;
    }

    public XPathQuery addRef(QName ref) {
        String prefix = this.fContext.getPrefix(ref.getNamespaceURI());
        this.fPath.append(prefix).append(':').append(ref.getLocalPart());
        return this;
    }

    public XPathQuery addRef(Property ref) {
        String prefix = this.fContext.getPrefix(ref.getNamespaceURI());
        this.fPath.append(prefix).append(':').append(ref.getName());
        return this;
    }

    public XPathQuery add(String string) {
        this.fPath.append(string);
        return this;
    }

    public XPathQuery add(char string) {
        this.fPath.append(string);
        return this;
    }

    public String getXPath() {
        return this.fPath.toString();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fContext;
    }
}

