/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.ILocalProjectLink;
import com.ibm.team.process.common.IProjectLink;

public class ServiceProvider {
    private final CALMLinkTypeInformation fLinkType;
    private final String fProviderName;
    private final String fProviderServiceUrl;
    private final IProjectLink fProjectLink;
    private final ILocalProjectLink fLocalLink;

    public ServiceProvider(CALMLinkTypeInformation linkType, IProjectLink projectLink) throws IllegalArgumentException {
        this(linkType, projectLink, null, projectLink.getLabel(), projectLink.getTargetServicesUrl());
    }

    public ServiceProvider(CALMLinkTypeInformation linkType, ILocalProjectLink link) throws IllegalArgumentException {
        this(linkType, null, link, link.getLabel(), link.getTargetServicesUrl());
    }

    public ServiceProvider(CALMLinkTypeInformation linkType, String providerName, String providerServiceUrl) throws IllegalArgumentException {
        this(linkType, null, null, providerName, providerServiceUrl);
    }

    private ServiceProvider(CALMLinkTypeInformation linkType, IProjectLink link, ILocalProjectLink localLink, String providerName, String providerServiceUrl) throws IllegalArgumentException {
        if (linkType == null || providerName == null || providerServiceUrl == null) {
            throw new IllegalArgumentException();
        }
        this.fLinkType = linkType;
        this.fProviderName = providerName;
        this.fProviderServiceUrl = providerServiceUrl;
        this.fProjectLink = link;
        this.fLocalLink = localLink;
    }

    public CALMLinkTypeInformation getLinkTypeInfo() {
        return this.fLinkType;
    }

    public IProjectLink getProjectLink() {
        return this.fProjectLink;
    }

    public ILocalProjectLink getLocalLink() {
        return this.fLocalLink;
    }

    public String getProviderName() {
        return this.fProviderName;
    }

    public String getLinkName() {
        return this.fProviderServiceUrl;
    }

    public String getProviderServiceUrl() {
        return this.fProviderServiceUrl;
    }

    public String getLabel() {
        return this.getLinkName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fLinkType == null ? 0 : this.fLinkType.hashCode());
        result = 31 * result + (this.fProviderServiceUrl == null ? 0 : this.fProviderServiceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProvider other = (ServiceProvider)obj;
        if (!this.fLinkType.equals(other.fLinkType)) {
            return false;
        }
        return this.fProviderServiceUrl.equals(other.fProviderServiceUrl);
    }
}

