/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.repository.common.LogFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SecureDocumentBuilderFactory {
    public static DocumentBuilderFactory newInstance() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        SecureDocumentBuilderFactory.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/validation", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", false);
        factory.setXIncludeAware(false);
        return factory;
    }

    private static void setFeature(DocumentBuilderFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (ParserConfigurationException e) {
            LogFactory.getLog((String)SecureDocumentBuilderFactory.class.getName()).warn((Object)NLS.bind((String)"Could not set feature {0} to {1} for DocumentBuilderFactory", (Object)feature, (Object)enabled), (Throwable)e);
        }
    }

    public static SAXParserFactory getSecureSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SecureDocumentBuilderFactory.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/validation", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        SecureDocumentBuilderFactory.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }

    private static void setFeature(SAXParserFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            LogFactory.getLog((String)SecureDocumentBuilderFactory.class.getName()).warn((Object)NLS.bind((String)"Could not set feature {0} to {1} for SAXParserFactory", (Object)feature, (Object)enabled), (Throwable)e);
        }
    }
}

