/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.common.internal.ItemTypeComparator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;

public class RTCCommonUtils {
    public static Collection<ILinkType> getLinkTypesForSourceType(ILinkTypeFetcher linkTypeFetcher, IItemType sourceItemType, IProjectAreaHandle projectArea) throws TeamRepositoryException {
        Collection<ILinkType> linkTypes = linkTypeFetcher.getAvailableLinkTypes(projectArea);
        return RTCCommonUtils.filterToSourceType(linkTypes, sourceItemType);
    }

    private static Collection<ILinkType> filterToSourceType(Collection<ILinkType> linkTypes, IItemType sourceItemType) {
        ArrayList<ILinkType> result = new ArrayList<ILinkType>(linkTypes.size());
        for (ILinkType type : linkTypes) {
            if (!RTCCommonUtils.supportsSourceItemType(type, sourceItemType)) continue;
            result.add(type);
        }
        return result;
    }

    private static boolean supportsSourceItemType(ILinkType linkType, IItemType sourceItemType) {
        IItemType foundItemType;
        IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
        return source != null && ItemTypeComparator.equals(sourceItemType, foundItemType = source.getReferencedItemType());
    }

    public static interface ILinkTypeFetcher {
        public Collection<ILinkType> getAvailableLinkTypes(IProjectAreaHandle var1) throws TeamRepositoryException;
    }
}

