/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.repository.common.transport.UriUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;

public class Property {
    private final String fNamespaceURI;
    private final String fName;
    private final URI fUri;

    public Property(String name) {
        this("", name);
    }

    public Property(String namespaceUri, String name) {
        Assert.isNotNull((Object)namespaceUri);
        Assert.isNotNull((Object)name);
        this.fNamespaceURI = namespaceUri;
        this.fName = name;
        this.fUri = this.toUri(namespaceUri, name);
    }

    private URI toUri(String nameSpace, String name) {
        if (nameSpace.length() > 0 && name.length() > 0) {
            try {
                return new URI(String.valueOf(this.fNamespaceURI) + UriUtil.encode((String)this.fName));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getNamespaceURI() {
        return this.fNamespaceURI;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isQualified() {
        return this.fNamespaceURI.length() > 0;
    }

    public boolean matches(String nsUri, String localName) {
        return this.fNamespaceURI.equals(nsUri) && this.fName.equals(localName);
    }

    public URI toUri() {
        return this.fUri;
    }

    public String toString() {
        return String.valueOf(this.fNamespaceURI) + this.fName;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

