/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.repository.common.LogFactory;
import org.apache.commons.logging.Log;

public class OSLCResourceLogger {
    public static Log TRACING_LOG = null;
    private static Log TRS_LOG = null;
    private static final String TRS_LOG_ID = "com.ibm.team.calm.foundation.common.OSLCResourceLogger.ChangeEvents.Trs";
    private static Log DEBUG_CHANGE_EVENTS_LOG = null;
    private static final String DEBUG_CHANGE_EVENTS_LOG_FLAG_ID = "com.ibm.team.calm.foundation.common.OSLCResourceLogger.ChangeEvents";
    private static final String DCTERMS_TITLE_REGEX = "<dcterms:title rdf:parseType=\"Literal\">(.*)?</dcterms:title>";
    private static final String REPLACE_TITLE_STRING = "<dcterms:title rdf:parseType=\"Literal\">[Redacted]</dcterms:title>";
    private static final String DCTERMS_DESCRIPTION_REGEX = "<dcterms:description rdf:parseType=\"Literal\">(.*)?</dcterms:description>";
    private static final String REPLACE_DESCRIPTION_STRING = "<dcterms:description rdf:parseType=\"Literal\">[Redacted]</dcterms:description>";

    public static final Log getLog() {
        if (TRACING_LOG != null) {
            return TRACING_LOG;
        }
        String id = OSLCResourceLogger.class.getName();
        TRACING_LOG = LogFactory.getLog((String)id);
        return TRACING_LOG;
    }

    public static final Log getOslcLog() {
        return OSLCResourceLogger.getLog();
    }

    public static final boolean filterRequestURI(String requestURI) {
        return requestURI.endsWith("/workitems/catalog") || requestURI.endsWith("services.xml") || requestURI.endsWith("/jazz/") || requestURI.endsWith("/ccm/") || requestURI.contains("/oslc/contexts/");
    }

    public static final Log getTrsLog() {
        if (TRS_LOG != null) {
            return TRS_LOG;
        }
        TRS_LOG = LogFactory.getLog((String)TRS_LOG_ID);
        return TRS_LOG;
    }

    public static final Log getChangeEventsLog() {
        if (DEBUG_CHANGE_EVENTS_LOG != null) {
            return DEBUG_CHANGE_EVENTS_LOG;
        }
        DEBUG_CHANGE_EVENTS_LOG = LogFactory.getLog((String)DEBUG_CHANGE_EVENTS_LOG_FLAG_ID);
        return DEBUG_CHANGE_EVENTS_LOG;
    }

    public static final String getXMLLogString(String xmlString) {
        if (OSLCResourceLogger.getLog().isTraceEnabled()) {
            return xmlString;
        }
        xmlString = xmlString.replaceAll(DCTERMS_TITLE_REGEX, REPLACE_TITLE_STRING);
        xmlString = xmlString.replaceAll(DCTERMS_DESCRIPTION_REGEX, REPLACE_DESCRIPTION_STRING);
        return xmlString;
    }
}

