/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.linktypes.client;

import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.client.ILinkTypeClientLibrary;
import com.ibm.team.linktypes.common.internal.ILinkTypeRestService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IDtoReverseConverter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public final class LinkTypeClientLibrary
implements ILinkTypeClientLibrary {
    private final IClientLibraryContext libraryContext;

    LinkTypeClientLibrary(IClientLibraryContext libraryContext) {
        Assert.isNotNull((Object)libraryContext, (String)"The client library context must not be null.");
        this.libraryContext = libraryContext;
    }

    private ILinkTypeRestService getService() throws TeamRepositoryException {
        Object service = this.libraryContext.getServiceInterface(ILinkTypeRestService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get ILinkTypeRestService.");
        }
        return (ILinkTypeRestService)service;
    }

    @Override
    public Collection<ILinkType> getLinkTypes() throws TeamRepositoryException {
        IDtoReverseConverter[] dtoResult = this.getService().getLinkTypes();
        return this.toLinkTypeCollection(dtoResult);
    }

    @Override
    public Collection<ILinkType> getAvailableLinkTypes(IProjectAreaHandle projectArea) throws TeamRepositoryException {
        ILinkTypeRestService.GetLinkTypesForProjectAreaParams params = new ILinkTypeRestService.GetLinkTypesForProjectAreaParams();
        params.projectAreaItemId = projectArea == null ? null : projectArea.getItemId().getUuidValue();
        IDtoReverseConverter[] dtoResult = this.getService().getLinkTypesForProjectArea(params);
        return this.toLinkTypeCollection(dtoResult);
    }

    @Override
    public ILinkType getLatestLinkTypeForLinkTypeId(String linkTypeId) throws TeamRepositoryException {
        if (linkTypeId == null) {
            throw new IllegalArgumentException("linkTypeId is required");
        }
        ILinkTypeRestService.GetLinkTypeParams params = new ILinkTypeRestService.GetLinkTypeParams();
        params.linkTypeId = linkTypeId;
        IDtoReverseConverter dto = this.getService().getLinkType(params);
        if (dto == null) {
            return null;
        }
        return (ILinkType)dto.toJavaObject();
    }

    @Override
    public ILinkType getLinkTypeForSpecificVersion(String linkTypeId, String linkTypeInstanceId) throws TeamRepositoryException {
        if (linkTypeId == null) {
            throw new IllegalArgumentException("linkTypeId is required");
        }
        ILinkTypeRestService.GetLinkTypeParams params = new ILinkTypeRestService.GetLinkTypeParams();
        params.linkTypeId = linkTypeId;
        params.linkTypeInstanceId = linkTypeInstanceId;
        IDtoReverseConverter dto = this.getService().getLinkType(params);
        return dto == null ? null : (ILinkType)dto.toJavaObject();
    }

    private Collection<ILinkType> toLinkTypeCollection(IDtoReverseConverter<ILinkType>[] dtoArray) {
        ArrayList<ILinkType> result = new ArrayList<ILinkType>(dtoArray.length);
        IDtoReverseConverter<ILinkType>[] iDtoReverseConverterArray = dtoArray;
        int n = dtoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDtoReverseConverter<ILinkType> dto = iDtoReverseConverterArray[n2];
            result.add((ILinkType)dto.toJavaObject());
            ++n2;
        }
        return result;
    }
}

