/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.preview;

import com.ibm.team.calm.foundation.client.internal.CALMFoundationClientPlugin;
import com.ibm.team.calm.foundation.client.internal.ResourceReference;
import com.ibm.team.calm.foundation.client.internal.preview.Messages;
import com.ibm.team.calm.foundation.client.preview.IResourceReference;
import com.ibm.team.calm.foundation.client.preview.ResourceOwner;
import com.ibm.team.calm.foundation.client.preview.ResourcePreviewManager;
import com.ibm.team.calm.foundation.common.preview.IResourcePreviewManager;
import com.ibm.team.calm.foundation.common.preview.IResourceReferenceResolver;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ResourceReferenceResolver
implements IResourceReferenceResolver {
    private List<IResourceReferenceResolver.IResourceReferenceListener> fListener = new ArrayList<IResourceReferenceResolver.IResourceReferenceListener>();

    public IReference makeResolvable(IReference reference, Object context) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        return reference != null ? this.makeResolvable(Collections.singletonList(reference), context).get(0) : null;
    }

    public List<IReference> makeResolvable(List<IReference> references, Object context) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IReference> result = new ArrayList<IReference>();
        if (references != null) {
            for (IReference cur : references) {
                if (cur == null) continue;
                if (cur.isURIReference()) {
                    ResourceReference resRef = !(cur instanceof ResourceReference) ? new ResourceReference((IURIReference)cur) : (ResourceReference)cur;
                    resRef.setContext(context);
                    result.add((IReference)resRef);
                    continue;
                }
                result.add(cur);
            }
        }
        return result;
    }

    public IReference resolveFromCache(IReference reference) throws TeamRepositoryException {
        if (reference != null && reference instanceof IResourceReference) {
            ResourceReference target = (ResourceReference)reference;
            ITeamRepository repository = this.findTeamRepository(target);
            ResourcePreview resource = null;
            if (repository != null) {
                Location loc = Location.location((URI)target.getURI());
                resource = repository.itemManager().getSharedItemIfKnown(loc.getItemHandle());
            } else {
                resource = this.getPreviewManager(target).getSharedPreviewIfKnown(target);
            }
            target.resolveWith(resource);
        }
        return reference;
    }

    public IReference resolve(IReference reference, int flags, boolean logMeIn, IProgressMonitor monitor) throws TeamRepositoryException {
        IReference target = reference;
        if (target != null && target instanceof IResourceReference) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                ResourceReference resRef = (ResourceReference)target;
                ITeamRepository curRepository = this.findTeamRepository(resRef);
                if (curRepository != null) {
                    try {
                        this.resolveWithRepositoryItem(resRef, flags, curRepository, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (TeamRepositoryException ex) {
                        this.resolveWithResourcePreview(resRef, flags, logMeIn, (IProgressMonitor)progress.newChild(1));
                    }
                } else {
                    this.resolveWithResourcePreview(resRef, flags, logMeIn, (IProgressMonitor)progress.newChild(1));
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return target;
    }

    public List<IReference> resolve(List<IReference> references, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IReference> result = null;
        if (references != null && !references.isEmpty()) {
            result = new ArrayList<IReference>(references);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(result.size() + 1));
            try {
                HashMap<ITeamRepository, List<ResourceReference>> refsByRepo = this.findTeamRepositories(result);
                this.resolveWithRepositoryItems(refsByRepo, flags, (IProgressMonitor)progress.newChild(1));
                this.resolveWithResourcePreviews(refsByRepo.get(null), flags, (IProgressMonitor)progress.newChild(1));
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return result;
    }

    public void resolveInBackground(List<IReference> references) {
        new ResolverJob(references).schedule();
    }

    public void addReferencesListener(IResourceReferenceResolver.IResourceReferenceListener lis) {
        this.fListener.add(lis);
    }

    public void removeReferencesListener(IResourceReferenceResolver.IResourceReferenceListener lis) {
        this.fListener.remove(lis);
    }

    private ResourcePreviewManager getPreviewManager(IResourceReference reference) throws TeamRepositoryException {
        Object context = reference.getContext();
        if (context instanceof ITeamRepository) {
            ITeamRepository repository = (ITeamRepository)context;
            return (ResourcePreviewManager)repository.getClientLibrary(IResourcePreviewManager.class);
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("ResourceReferenceResolver.ERROR_RESOLUTION_CONTEXT_NOT_SET"), (Object)reference.getComment(), (Object[])new Object[0]));
    }

    private HashMap<ITeamRepository, List<ResourceReference>> findTeamRepositories(List<IReference> refs) {
        HashMap<ITeamRepository, List<ResourceReference>> result = new HashMap<ITeamRepository, List<ResourceReference>>();
        if (refs != null) {
            for (IReference cur : refs) {
                if (!(cur instanceof ResourceReference)) continue;
                ResourceReference curRef = (ResourceReference)cur;
                ITeamRepository curRepo = this.findTeamRepository(curRef);
                if (!result.containsKey(curRepo)) {
                    result.put(curRepo, new ArrayList());
                }
                result.get(curRepo).add(curRef);
            }
        }
        return result;
    }

    private ITeamRepository findTeamRepository(IResourceReference ref) {
        try {
            return ClientURIUtils.findTeamRepository((URI)ref.getURI());
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    private void resolveWithRepositoryItem(ResourceReference reference, int flags, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reference != null) {
            reference.setResourceOwner(new ResourceOwner(repository));
            Location loc = Location.location((URI)reference.getURI());
            try {
                IItem item = repository.itemManager().fetchCompleteItem(loc, flags, monitor);
                reference.resolveWith(item);
            }
            catch (IllegalArgumentException ex) {
                throw new TeamRepositoryException((Object)ex, ex.getMessage());
            }
        }
    }

    private void resolveWithRepositoryItems(HashMap<ITeamRepository, List<ResourceReference>> referencesByRepository, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (referencesByRepository != null) {
            for (ITeamRepository curRepo : referencesByRepository.keySet()) {
                List<ResourceReference> references;
                if (curRepo == null || (references = referencesByRepository.get(curRepo)) == null) continue;
                for (ResourceReference cur : references) {
                    cur.setResourceOwner(new ResourceOwner(curRepo));
                    URI curUri = cur.getURI();
                    if (curUri == null) continue;
                    Location curLoc = Location.location((URI)curUri);
                    try {
                        IItem curItem = curRepo.itemManager().fetchCompleteItem(curLoc, flags, monitor);
                        cur.resolveWith(curItem);
                    }
                    catch (TeamRepositoryException ex) {
                        this.resolveWithResourcePreview(cur, flags, false, monitor);
                    }
                }
            }
        }
    }

    private void resolveWithResourcePreview(ResourceReference reference, int flags, boolean logMeIn, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reference != null) {
            Object resource;
            block3: {
                resource = null;
                try {
                    ResourcePreviewManager previewManager = this.getPreviewManager(reference);
                    reference.setResourceOwner(new ResourceOwner(previewManager));
                    resource = previewManager.fetchPreviewFromReference(reference, flags, logMeIn, monitor);
                }
                catch (TeamRepositoryException ex) {
                    resource = this.resolveWithHyperlinkHandler(reference, monitor);
                    if (resource != null) break block3;
                    throw ex;
                }
            }
            reference.resolveWith(resource);
        }
    }

    private void resolveWithResourcePreviews(List<ResourceReference> references, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (references != null && !references.isEmpty()) {
            Assert.isTrue((boolean)this.sameContext(references));
            if (references.get(0).getContext() != null) {
                ResourcePreviewManager previewManager = this.getPreviewManager(references.get(0));
                for (ResourceReference curRef : references) {
                    curRef.setResourceOwner(new ResourceOwner(previewManager));
                }
                List<ResourcePreview> resources = previewManager.fetchPreviewFromReferences(references, flags, monitor);
                int idx = 0;
                int len = resources.size();
                while (idx < len) {
                    ResourceReference curRef = references.get(idx);
                    Object curRes = resources.get(idx);
                    Assert.isNotNull((Object)curRef);
                    if (curRef != null) {
                        if (curRes == null) {
                            curRes = this.resolveWithHyperlinkHandler(curRef, monitor);
                        }
                        curRef.resolveWith(curRes);
                    }
                    ++idx;
                }
            }
        }
    }

    private Object resolveWithHyperlinkHandler(ResourceReference reference, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return Hyperlinks.resolve((URI)reference.getURI(), null, (IProgressMonitor)monitor);
        }
        catch (CoreException ignored) {
            return null;
        }
    }

    private boolean sameContext(List<ResourceReference> references) {
        Object context = references.get(0).getContext();
        if (context != null) {
            for (ResourceReference cur : references) {
                if (context.equals(cur.getContext())) continue;
                return false;
            }
        }
        return true;
    }

    private class ResolverJob
    extends FoundationJob {
        private final List<IReference> fReferences;

        public ResolverJob(List<IReference> references) {
            super("");
            this.fReferences = references;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            try {
                List<IReference> resolved = ResourceReferenceResolver.this.resolve(this.fReferences, 0, monitor);
                for (IResourceReferenceResolver.IResourceReferenceListener cur : ResourceReferenceResolver.this.fListener) {
                    cur.referencesUpdated(resolved);
                }
            }
            catch (TeamRepositoryException ex) {
                Status status = new Status(4, "com.ibm.team.calm.foundation.client", ex.getLocalizedMessage(), (Throwable)ex);
                CALMFoundationClientPlugin.getDefault().log(status);
            }
            return Status.OK_STATUS;
        }
    }
}

