/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.preview;

import com.ibm.team.calm.foundation.client.internal.preview.Messages;
import com.ibm.team.calm.foundation.client.preview.CompactRenderingClient;
import com.ibm.team.calm.foundation.common.preview.IResourcePreviewManager;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ResourcePreviewManager
implements IResourcePreviewManager {
    private final Map<URI, ResourcePreview> fResourceCache;
    private final CompactRenderingClient fRenderingClient;

    public ResourcePreviewManager(IClientLibraryContext libraryContext) {
        Assert.isNotNull((Object)libraryContext);
        this.fResourceCache = new HashMap<URI, ResourcePreview>();
        this.fRenderingClient = new CompactRenderingClient(libraryContext);
    }

    public ResourcePreview getSharedPreviewIfKnown(URI uri) {
        return this.fResourceCache.get(uri);
    }

    public ResourcePreview fetchPreviewFromURI(URI uri, int flags, boolean logMeIn, IProgressMonitor monitor) throws TeamRepositoryException {
        ResourcePreview result = null;
        if (uri != null) {
            if (flags == 0) {
                result = this.fResourceCache.get(uri);
            }
            if (result == null) {
                result = this.fetchResourcePreview(uri, logMeIn, monitor);
            }
        }
        return result;
    }

    public List<ResourcePreview> fetchPreviewFromURIs(List<URI> uris, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<URI, ResourcePreview> resourceMap = this.intializeWithCache(uris, flags);
        return this.fetchResourcePreviews(uris, resourceMap, monitor);
    }

    public ResourcePreview getSharedPreviewIfKnown(IURIReference reference) {
        return this.fResourceCache.get(this.getURI(reference));
    }

    public ResourcePreview fetchPreviewFromReference(IURIReference reference, int flags, boolean logMeIn, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchPreviewFromURI(this.getURI(reference), flags, logMeIn, monitor);
    }

    public List<ResourcePreview> fetchPreviewFromReferences(List<? extends IURIReference> references, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<URI, ResourcePreview> cachedPreviews = this.intializeWithCache(references, flags);
        return this.fetchResourcePreviews(references, cachedPreviews, monitor);
    }

    public URI getCompactRendererURI() throws TeamRepositoryException {
        return this.fRenderingClient.getCompactRendererURI();
    }

    private ResourcePreview fetchResourcePreview(URI resourceUri, boolean logMeIn, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("ResourcePreviewManager_TASK_RETRIEVE_COMPACT_RENDERING_DOCUMENT"), (int)2);
        try {
            String errorMessage = Messages.getString("ResourcePreviewManager_ERROR_RETRIEVE_COMPACT_RENDERING_DOCUMENT");
            ResourcePreview result = this.fRenderingClient.fetchPreview(resourceUri, logMeIn, errorMessage, (IProgressMonitor)progress.newChild(1));
            if (result != null && !result.hasErrors()) {
                this.fResourceCache.put(resourceUri, result);
                ResourcePreview resourcePreview = result;
                return resourcePreview;
            }
            if (result != null && result.hasAuthenticationError()) {
                throw new AuthenticationException(NLS.bind((String)Messages.getString("ResourcePreviewManager_ERROR_ACCESSING_RESOURCE_INFORMATION"), (Object)resourceUri.toString(), (Object[])new Object[0]));
            }
            throw new TeamRepositoryException(Messages.getString("ResourcePreviewManager_ERROR_COMPACT_RENDERING_NOT_SUPPORTED"));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<ResourcePreview> fetchResourcePreviews(List<?> handles, Map<URI, ResourcePreview> cachedPreviews, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<ResourcePreview> result = new ArrayList<ResourcePreview>(handles.size());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("ResourcePreviewManager_TASK_RETRIEVE_COMPACT_RENDERING_DOCUMENT"), (int)2);
        try {
            List<URI> resourcesToFetch = this.getURIs(cachedPreviews);
            String errorMessage = Messages.getString("ResourcePreviewManager_ERROR_RETRIEVE_COMPACT_RENDERING_DOCUMENT");
            List<ResourcePreview> previews = this.fRenderingClient.fetchPreviews(resourcesToFetch, errorMessage, (IProgressMonitor)progress.newChild(1));
            HashMap<URI, ResourcePreview> newPreviews = new HashMap<URI, ResourcePreview>();
            for (ResourcePreview curPrev : previews) {
                newPreviews.put(curPrev.getResourceURI(), curPrev);
            }
            for (Object curHandle : handles) {
                URI curUri = this.getURI(curHandle);
                if (progress.isCanceled()) {
                    break;
                }
                ResourcePreview curPrev = cachedPreviews.get(curUri);
                if (curPrev == null && (curPrev = (ResourcePreview)newPreviews.get(curUri)) != null && !curPrev.hasErrors()) {
                    this.fResourceCache.put(curUri, curPrev);
                }
                if (curPrev == null) continue;
                result.add(curPrev);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    private Map<URI, ResourcePreview> intializeWithCache(List<?> handles, int flags) {
        Map<URI, ResourcePreview> result = null;
        if (handles != null) {
            result = new HashMap<URI, ResourcePreview>(handles.size());
            for (Object cur : handles) {
                URI curUri = this.getURI(cur);
                if (curUri == null || flags != 0) continue;
                result.put(curUri, this.fResourceCache.get(curUri));
            }
        }
        return result != null ? result : Collections.emptyMap();
    }

    private List<URI> getURIs(Map<URI, ResourcePreview> resources) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (resources != null && !resources.isEmpty()) {
            for (URI curRes : resources.keySet()) {
                if (resources.get(curRes) != null) continue;
                result.add(curRes);
            }
        }
        return result;
    }

    private URI getURI(Object handle) {
        URI result = null;
        if (handle instanceof URI) {
            result = (URI)handle;
        } else if (handle instanceof IURIReference) {
            result = ((IURIReference)handle).getURI();
        }
        return result;
    }
}

