/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.preview;

import com.ibm.team.calm.foundation.common.preview.IResourcePreviewManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.net.URI;
import java.net.URISyntaxException;

public class ResourceOwner {
    private final boolean fIsTeamRepository;
    private final UUID fIdentifier;
    private URI fPublicURI;

    public ResourceOwner(ITeamRepository repository) throws IllegalArgumentException {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.fIsTeamRepository = true;
        this.fIdentifier = repository.getId();
        try {
            this.fPublicURI = new URI(repository.getRepositoryURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public ResourceOwner(IResourcePreviewManager previewManager) throws IllegalArgumentException {
        if (previewManager == null) {
            throw new IllegalArgumentException();
        }
        this.fIsTeamRepository = false;
        this.fIdentifier = null;
        try {
            this.fPublicURI = previewManager.getCompactRendererURI();
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    public boolean isTeamRepository() {
        return this.fIsTeamRepository;
    }

    public UUID getIdentifier() {
        return this.fIdentifier;
    }

    public URI getPublicURI() {
        return this.fPublicURI;
    }
}

