/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.preview;

import com.ibm.team.calm.foundation.client.internal.RESTClient;
import com.ibm.team.calm.foundation.client.internal.preview.CompactRenderingImages;
import com.ibm.team.calm.foundation.client.internal.preview.Messages;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.internal.preview.CompactRenderingDocument;
import com.ibm.team.calm.foundation.common.internal.preview.ICompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.internal.preview.ICompactRenderingService;
import com.ibm.team.calm.foundation.common.preview.IResolutionError;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CompactRenderingClient {
    public static final String COMPACT_RENDERING_HEADER = "application/x-jazz-compact-rendering";
    private final IHttpClient fHttpClient;
    private final IClientLibraryContext fContext;
    private ICompactRenderingService fCompactRenderingService;

    public CompactRenderingClient(IClientLibraryContext context) {
        this.fContext = context;
        this.fHttpClient = new RESTClient(context).getHttpClient();
    }

    public ResourcePreview fetchPreview(URI resourceUri, boolean logMeIn, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        IResolutionError error;
        if (resourceUri == null) {
            throw new TeamRepositoryException(Messages.getString("CompactRenderingClient_ERROR_NULL_RESOURCE_URI"));
        }
        ResourcePreview[] previews = this.loadPreviews(new URI[]{resourceUri}, errorMessage, monitor);
        if (previews == null || previews.length != 1) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getString("CompactRenderingClient_ERROR_ACCESSING_COMPACT_RENDERING_REPRESENTATION"), (Object)resourceUri.toString(), (Object[])new Object[]{Messages.getString("CompactRenderingClient_NO_ERROR_CODE_FROM_SERVER"), Messages.getString("CompactRenderingClient_NO_MESSAGE_FROM_SERVER")}));
        }
        ResourcePreview result = previews[0];
        if (result.hasAuthenticationError() && logMeIn) {
            ICompactRenderingRepresentation representation = CompactRenderingDocument.getCompactRenderingRepresentation((String)resourceUri.toString(), (IHttpClient)this.fHttpClient);
            result = this.preparePreview(new String[]{resourceUri.toString()}, representation, errorMessage, monitor);
        }
        if ((error = result.getError()) == null) {
            return result;
        }
        if (error.isAuthenticationError()) {
            throw new AuthenticationException(NLS.bind((String)Messages.getString("CompactRenderingClient_AUTH_FAILURE_COMPACT_RENDERING_REPRESENTATION"), (Object)resourceUri.toString(), (Object[])new Object[0]), error.getErrorCode());
        }
        String message = error.getErrorMessage();
        if (message == null || message.length() == 0) {
            message = Messages.getString("CompactRenderingClient_NO_MESSAGE_FROM_SERVER");
        }
        throw new TeamRepositoryException(NLS.bind((String)Messages.getString("CompactRenderingClient_ERROR_ACCESSING_COMPACT_RENDERING_REPRESENTATION"), (Object)resourceUri.toString(), (Object[])new Object[]{error.getErrorCode(), message}));
    }

    public List<ResourcePreview> fetchPreviews(List<URI> resourceURIs, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        if (resourceURIs != null && !resourceURIs.isEmpty()) {
            ResourcePreview[] previews = this.loadPreviews(resourceURIs.toArray(new URI[resourceURIs.size()]), errorMessage, monitor);
            return Arrays.asList(previews);
        }
        return Collections.emptyList();
    }

    public URI getCompactRendererURI() throws TeamRepositoryException {
        try {
            return new URI(String.valueOf(this.fContext.teamRepository().getRepositoryURI()) + "service/" + ICompactRenderingService.class.getName());
        }
        catch (URISyntaxException ex) {
            throw new TeamRepositoryException((Object)ex, ex.getMessage());
        }
    }

    private URL fetchIcon(URI iconUri, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        if (iconUri != null) {
            try {
                URL cachedIconUrl = CompactRenderingImages.getCachedImageContentServiceURL(iconUri);
                if (cachedIconUrl != null) {
                    return cachedIconUrl;
                }
                IHttpClient.IResponse resp = null;
                try {
                    resp = this.fHttpClient.performGet(iconUri.toString(), new HttpHeaders());
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                if (resp != null) {
                    return CompactRenderingImages.resolveImageContent(resp.getResponseStream(), iconUri);
                }
            }
            catch (MalformedURLException ex) {
                throw new TeamRepositoryException(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private ResourcePreview[] loadPreviews(URI[] uris, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] uriValues = new String[uris.length];
        int i = 0;
        while (i < uris.length) {
            if (uris[i] == null) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
            }
            uriValues[i] = uris[i].toString();
            ++i;
        }
        ICompactRenderingRepresentation[] representations = this.getCompactRenderingService().loadCompactRenderingRepresentations(uriValues);
        ResourcePreview[] preparedPreviews = null;
        if (representations != null) {
            preparedPreviews = new ResourcePreview[representations.length];
            int i2 = 0;
            while (i2 < representations.length) {
                preparedPreviews[i2] = this.preparePreview(uriValues, representations[i2], errorMessage, monitor);
                ++i2;
            }
        }
        return preparedPreviews;
    }

    private ResourcePreview preparePreview(String[] uriValues, ICompactRenderingRepresentation representation, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        if (representation.getError() != null) {
            return new ResourcePreview(URI.create(representation.getAbout()), representation.getError());
        }
        String iconUri = representation.getIconLocation();
        if (iconUri != null) {
            try {
                URL localURL = this.fetchIcon(URI.create(iconUri), errorMessage, monitor);
                iconUri = localURL != null ? localURL.toURI().toString() : null;
            }
            catch (URISyntaxException ex) {
                iconUri = null;
            }
        }
        String representationAbout = representation.getAbout();
        String[] stringArray = uriValues;
        int n = uriValues.length;
        int n2 = 0;
        while (n2 < n) {
            String uriValue = stringArray[n2];
            if (uriValue.startsWith(representationAbout)) {
                representationAbout = uriValue;
                break;
            }
            ++n2;
        }
        ResourcePreview preparedPreview = new ResourcePreview(representation.getTitle(), representationAbout, representation.getShortTitle(), iconUri, representation.getSmallPreviewLocation(), representation.getSmallPreviewWidth(), representation.getSmallPreviewHeight(), representation.getSmallPreviewInitialHeight(), representation.getLargePreviewLocation(), representation.getLargePreviewWidth(), representation.getLargePreviewHeight(), representation.getLargePreviewInitialHeight());
        return preparedPreview;
    }

    private ICompactRenderingService getCompactRenderingService() {
        if (this.fCompactRenderingService == null) {
            this.fCompactRenderingService = (ICompactRenderingService)this.fContext.getServiceInterface(ICompactRenderingService.class);
        }
        return this.fCompactRenderingService;
    }
}

