/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.linking;

import com.ibm.team.calm.foundation.client.IServiceProviderClient;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class CALMLinkingCache {
    private final IItemType fSourceItemType;
    private final String[] fLinkTypeIds;
    private final IProjectAreaHandle fProjectArea;
    private final IServiceProviderClient fProviderClient;
    private Collection<ServiceProvider> fServiceProviders;
    private final Map<CALMLinkTypeInformation, Collection<ServiceProvider>> fLinkTypeToServiceProvidersMap = new HashMap<CALMLinkTypeInformation, Collection<ServiceProvider>>();

    private CALMLinkingCache(String[] linkTypeIds, IItemType sourceItemType, IProjectAreaHandle projectArea) throws IllegalArgumentException {
        if (linkTypeIds == null && sourceItemType == null || projectArea == null) {
            throw new IllegalArgumentException();
        }
        this.fSourceItemType = sourceItemType;
        this.fLinkTypeIds = linkTypeIds;
        this.fProjectArea = projectArea;
        ITeamRepository origin = (ITeamRepository)projectArea.getOrigin();
        this.fProviderClient = (IServiceProviderClient)origin.getClientLibrary(IServiceProviderClient.class);
    }

    public CALMLinkingCache(IItemType sourceItemType, IProjectAreaHandle projectArea) throws IllegalArgumentException {
        this(null, sourceItemType, projectArea);
    }

    public static CALMLinkingCache cache(String[] linkTypeIds, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        CALMLinkingCache cache = new CALMLinkingCache(linkTypeIds, null, projectArea);
        cache.initialize(monitor);
        return cache;
    }

    public void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fSourceItemType != null) {
            this.fServiceProviders = this.fProviderClient.findServiceProviders(this.fSourceItemType, this.fProjectArea, monitor);
        }
        if (this.fLinkTypeIds != null) {
            Collection<ServiceProvider> serviceProviders = this.fProviderClient.findServiceProviderByLinkIds(this.fLinkTypeIds, this.fProjectArea, monitor);
            if (this.fServiceProviders != null) {
                this.fServiceProviders.addAll(serviceProviders);
            } else {
                this.fServiceProviders = serviceProviders;
            }
        }
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public Collection<CALMLinkTypeInformation> getAvailableLinkTypes() {
        if (this.fServiceProviders == null) {
            throw new IllegalArgumentException("CALMLinkingCache not initialzied");
        }
        HashSet<CALMLinkTypeInformation> result = new HashSet<CALMLinkTypeInformation>();
        for (ServiceProvider serviceProvider : this.fServiceProviders) {
            result.add(serviceProvider.getLinkTypeInfo());
        }
        return result;
    }

    public Collection<ServiceProvider> getServiceProviders(CALMLinkTypeInformation linkTypeInfo) {
        if (this.fServiceProviders == null) {
            throw new IllegalArgumentException("CALMLinkingCache not initialzied");
        }
        if (linkTypeInfo == null) {
            throw new IllegalArgumentException();
        }
        Collection<ServiceProvider> result = this.fLinkTypeToServiceProvidersMap.get(linkTypeInfo);
        if (result == null) {
            result = new ArrayList<ServiceProvider>();
            for (ServiceProvider serviceProvider : this.fServiceProviders) {
                if (!serviceProvider.getLinkTypeInfo().equals(linkTypeInfo)) continue;
                result.add(serviceProvider);
            }
            this.fLinkTypeToServiceProvidersMap.put(linkTypeInfo, result);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void addServiceProvider(ServiceProvider serviceProvider) {
        if (this.fServiceProviders == null) {
            throw new IllegalArgumentException("CALMLinkingCache not initialzied");
        }
        if (!this.fServiceProviders.contains(serviceProvider)) {
            this.fServiceProviders.add(serviceProvider);
            Collection<ServiceProvider> collection = this.fLinkTypeToServiceProvidersMap.get(serviceProvider.getLinkTypeInfo());
            if (collection != null) {
                collection.add(serviceProvider);
            }
        }
    }
}

