/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.internal.preview;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;

public class CompactRenderingImages {
    public static URL getCachedImageContentServiceURL(URI uri) throws MalformedURLException {
        File file = CompactRenderingImages.getLocalFile(uri);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL resolveImageContent(InputStream inS, URI uri) throws TeamRepositoryException, MalformedURLException {
        File localFile = CompactRenderingImages.getLocalFile(uri);
        if (localFile.exists()) return localFile.toURI().toURL();
        File tempFile = CompactRenderingImages.createTempFile("compactRemoteImage");
        try {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                CompactRenderingImages.copyStream(inS, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (inS != null) {
                    inS.close();
                }
            }
        }
        catch (IOException e) {
            tempFile.delete();
            throw new TeamRepositoryException("Could not stream image", (Throwable)e);
        }
        Class<CompactRenderingImages> clazz = CompactRenderingImages.class;
        synchronized (CompactRenderingImages.class) {
            if (!localFile.exists()) {
                if (tempFile.renameTo(localFile)) return localFile.toURI().toURL();
                throw new TeamRepositoryException(NLS.bind((String)"Could not create {0}", (Object)localFile.getPath(), (Object[])new Object[0]));
            } else {
                tempFile.delete();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return localFile.toURI().toURL();
        }
    }

    private static File createTempFile(String prefix) {
        IPath tempPath = CompactRenderingImages.getRootURL().append(String.valueOf(prefix) + UUID.generate().getUuidValue() + ".tmp");
        return new File(tempPath.toOSString());
    }

    private static File getLocalFile(URI uri) {
        Path path = new Path(uri.getPath());
        String scope = String.valueOf(uri.getHost()) + Integer.toString(uri.getPath().hashCode());
        String identifier = path.lastSegment().replaceAll("[^\\w\\.]", "_");
        return new File(CompactRenderingImages.getFilePathFromConfigArea(scope, identifier).toOSString());
    }

    private static IPath getFilePathFromConfigArea(String scope, String identifier) {
        return CompactRenderingImages.getRootURL().append(String.valueOf(scope) + "_" + identifier);
    }

    private static IPath getRootURL() {
        IPath path = CompactRenderingImages.getRootPath();
        File root = new File((path = path.append("com.ibm.team.rtc.client.compactRemoteImages")).toOSString());
        if (!root.exists()) {
            root.mkdir();
        }
        return path;
    }

    private static IPath getRootPath() {
        if (Platform.isRunning()) {
            ConfigurationScope configurationScope = new ConfigurationScope();
            return configurationScope.getLocation();
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        return Path.fromOSString((String)tempDir);
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int readBytes = 0;
        while ((readBytes = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, readBytes);
        }
    }
}

