/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.internal;

import com.ibm.team.calm.foundation.client.IServiceProviderClient;
import com.ibm.team.calm.foundation.client.internal.ClientProjectLinkingContext;
import com.ibm.team.calm.foundation.client.internal.Messages;
import com.ibm.team.calm.foundation.client.internal.RESTClient;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationUtil;
import com.ibm.team.calm.foundation.common.linking.IProjectLinkingContext;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.client.ILinkTypeClientLibrary;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ServiceProviderClient
implements IServiceProviderClient {
    private final IClientLibraryContext fContext;
    private final ITeamRepository fRepository;

    protected ServiceProviderClient(IClientLibraryContext context) {
        this.fContext = context;
        this.fRepository = context.teamRepository();
    }

    private Collection<ServiceProvider> fetchServiceProviders(final List<CALMLinkTypeInformation> linkTypeInfos, final IProjectAreaHandle projectAreaHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<Collection<ServiceProvider>> runnable = new IClientLibraryContext.IServiceRunnable<Collection<ServiceProvider>>(){

            public Collection<ServiceProvider> run(IProgressMonitor monitor) throws TeamRepositoryException {
                IProjectArea projectArea = (IProjectArea)ServiceProviderClient.this.fRepository.itemManager().fetchPartialItem((IItemHandle)projectAreaHandle, 0, Collections.singleton(ProcessCommon.getPropertyName(IProjectArea.class, (String)"projectLinks")), monitor);
                List projectLinks = ServiceProviderClient.this.fRepository.itemManager().fetchCompleteItems(Arrays.asList(projectArea.getProjectLinks()), 0, monitor);
                ClientProjectLinkingContext linkingContext = new ClientProjectLinkingContext((IProjectAreaHandle)projectArea, projectLinks, ServiceProviderClient.this.fContext);
                ArrayList<ServiceProvider> result = new ArrayList<ServiceProvider>();
                if (projectLinks != null && linkTypeInfos != null) {
                    for (CALMLinkTypeInformation curTargetType : linkTypeInfos) {
                        Collection serviceProviders = curTargetType.getServiceProviders((IProjectLinkingContext)linkingContext);
                        result.addAll(serviceProviders);
                    }
                }
                return result;
            }
        };
        return (Collection)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, progressMonitor);
    }

    @Override
    public Collection<ServiceProvider> findServiceProviders(IItemType sourceItemType, IProjectAreaHandle projectAreaHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (sourceItemType == null) {
            return Collections.emptyList();
        }
        List linkTypeInfos = CALMLinkTypeInformationRegistry.getAllLinkTypeInformations((IItemType)sourceItemType);
        return this.fetchServiceProviders(linkTypeInfos, projectAreaHandle, progressMonitor);
    }

    @Override
    public Collection<ServiceProvider> findServiceProviderByLinkIds(String[] linkTypeIds, IProjectAreaHandle projectAreaHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (linkTypeIds == null) {
            return Collections.emptyList();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)linkTypeIds.length);
        ArrayList<CALMLinkTypeInformation> linkTypeInfos = new ArrayList<CALMLinkTypeInformation>(linkTypeIds.length);
        String[] stringArray = linkTypeIds;
        int n = linkTypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String linkTypeId = stringArray[n2];
            CALMLinkTypeInformation linkTypeInfo = CALMLinkTypeInformationRegistry.getLinkTypeInformation((String)linkTypeId);
            if (linkTypeInfo != null) {
                linkTypeInfos.add(linkTypeInfo);
                progress.worked(1);
            } else {
                linkTypeInfo = this.getLinkTypeInfoForCustomType(linkTypeId, (IProgressMonitor)progress.newChild(1));
                if (linkTypeInfo != null) {
                    linkTypeInfos.add(linkTypeInfo);
                }
            }
            ++n2;
        }
        return this.fetchServiceProviders(linkTypeInfos, projectAreaHandle, progressMonitor);
    }

    private CALMLinkTypeInformation getLinkTypeInfoForCustomType(String linkTypeId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ILinkTypeClientLibrary library = (ILinkTypeClientLibrary)this.fRepository.getClientLibrary(ILinkTypeClientLibrary.class);
        ILinkType linkType = library.getLatestLinkTypeForLinkTypeId(linkTypeId);
        return CALMLinkTypeInformationUtil.getLinkTypeInfoForCustomType((ILinkType)linkType);
    }

    @Override
    public IProjectAreaHandle findRepositoryConnection(IProjectLink link, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (link != null) {
            try {
                final ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(this.getTargetRepoUri(link), 4);
                if (repository != null && repository.loggedIn()) {
                    final UUID targetProjectAreaId = this.getTargetObjectUUID(link);
                    IClientLibraryContext.IServiceRunnable<IProjectAreaHandle> runnable = new IClientLibraryContext.IServiceRunnable<IProjectAreaHandle>(){

                        public IProjectAreaHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(targetProjectAreaId, null);
                            try {
                                return (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
                            }
                            catch (TeamRepositoryException ex) {
                                if (ex instanceof ItemNotFoundException) {
                                    return null;
                                }
                                throw ex;
                            }
                        }
                    };
                    return (IProjectAreaHandle)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, progressMonitor);
                }
            }
            catch (URISyntaxException ex) {
                throw new TeamRepositoryException((Object)ex, ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public IProjectAreaHandle findRepositoryConnection(ServiceProvider serviceProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            if (serviceProvider != null) {
                if (serviceProvider.getProjectLink() != null) {
                    IProjectAreaHandle iProjectAreaHandle = this.findRepositoryConnection(serviceProvider.getProjectLink(), monitor);
                    return iProjectAreaHandle;
                }
                if (serviceProvider.getLocalLink() != null) {
                    IProjectAreaHandle iProjectAreaHandle = serviceProvider.getLocalLink().getLocalProjectArea();
                    return iProjectAreaHandle;
                }
            }
            return null;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public OSLCResourceDescription.ServiceDocument fetchServiceDocument(ServiceProvider serviceProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        if (serviceProvider != null) {
            SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("ServiceProviderClient_TASK_RETRIEVE_SERVICE_DOCUMENT"), (int)2);
            try {
                String servicesUrl = serviceProvider.getProviderServiceUrl();
                if (servicesUrl == null) {
                    throw new TeamRepositoryException(MessageFormat.format(Messages.getString("ServiceProviderClient_ERROR_NO_LINK_SERVICE"), serviceProvider.getProviderName()));
                }
                RESTClient client = new RESTClient(this.fContext);
                OSLCResourceDescription targetResourceDescription = serviceProvider.getLinkTypeInfo().getTargetResourceDescription();
                if (targetResourceDescription != null) {
                    OSLCResourceDescription.ServiceDocument serviceDocument = targetResourceDescription.loadServiceDocument(servicesUrl, client.getHttpClient());
                    return serviceDocument;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return null;
    }

    private String getTargetRepoUri(IProjectLink projectLink) throws URISyntaxException {
        String targetUrl = projectLink.getTargetUrl();
        String relativePath = new URI(targetUrl).getPath();
        int idxSecondSegment = relativePath.indexOf(47, 1);
        String result = targetUrl.substring(0, targetUrl.indexOf(relativePath));
        if (idxSecondSegment > -1) {
            result = String.valueOf(result) + relativePath.substring(0, idxSecondSegment);
        }
        return result;
    }

    private UUID getTargetObjectUUID(IProjectLink projectLink) {
        String targetUrl;
        if (projectLink != null && (targetUrl = projectLink.getTargetUrl()) != null) {
            try {
                return UUID.valueOf((String)targetUrl.substring(targetUrl.lastIndexOf(47) + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

