/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.internal;

import com.ibm.team.calm.foundation.client.preview.IResourceReference;
import com.ibm.team.calm.foundation.client.preview.ResourceOwner;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import java.net.URI;
import org.eclipse.core.runtime.Assert;

public class ResourceReference
implements IResourceReference {
    private final IURIReference fReference;
    private Object fContext;
    private Object fResource;
    private ResourceOwner fOwner;

    public ResourceReference(IURIReference reference) {
        Assert.isNotNull((Object)reference);
        this.fReference = reference;
    }

    public ResourceReference(URI uri) {
        this(uri, "");
    }

    public ResourceReference(URI uri, String comment) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)comment);
        this.fReference = IReferenceFactory.INSTANCE.createReferenceFromURI(uri, comment);
    }

    @Override
    public ResourceOwner getResourceOwner() {
        return this.fOwner;
    }

    public void setResourceOwner(ResourceOwner owner) {
        this.fOwner = owner;
    }

    public URI createURI() {
        return this.fReference.createURI();
    }

    public String getComment() {
        return this.fReference.getComment();
    }

    public String getContentType() {
        return this.fReference.getContentType();
    }

    @Override
    public Object getContext() {
        return this.fContext;
    }

    public void setContext(Object context) {
        this.fContext = context;
    }

    public String getExtraInfo() {
        return this.fReference.getExtraInfo();
    }

    public ILink getLink() {
        return this.fReference.getLink();
    }

    public boolean isURIReference() {
        return true;
    }

    public boolean isItemReference() {
        return this.fResource != null && this.fResource instanceof IItem;
    }

    public IItemHandle getReferencedItem() {
        return this.fResource instanceof IItemHandle ? (IItemHandle)this.fResource : null;
    }

    @Override
    public ResourcePreview getReferencedResource() {
        return this.fResource instanceof ResourcePreview ? (ResourcePreview)this.fResource : null;
    }

    public URI getURI() {
        return this.fReference.getURI();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ResourceReference) {
            ResourceReference other = (ResourceReference)obj;
            return !(this.fReference == null || other.fReference == null ? this.fReference != other.fReference : !this.fReference.sameDetailsAs((IReference)other.fReference));
        }
        if (obj instanceof IReference) {
            if (this.fReference == null) {
                return false;
            }
            return this.fReference.sameDetailsAs((IReference)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.fReference == null ? 0 : this.fReference.hashCode();
    }

    public IReference makeClone() {
        ResourceReference clone = new ResourceReference((IURIReference)this.fReference.makeClone());
        if (this.fResource != null) {
            clone.resolveWith(this.fResource);
        }
        return clone;
    }

    public Object resolve() {
        if (this.fResource != null) {
            return this.fResource;
        }
        return this.fReference.resolve();
    }

    public void resolveWith(Object resource) {
        this.fResource = resource;
    }

    public boolean sameDetailsAs(IReference other) {
        return this.fReference.sameDetailsAs(other);
    }

    public boolean sameDetailsExcludingCommentAs(IReference other) {
        return this.fReference.sameDetailsExcludingCommentAs(other);
    }
}

