/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.internal;

import com.ibm.team.calm.foundation.client.internal.Messages;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.internal.Response;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.http.HttpEntity;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class RESTClient {
    private final IClientLibraryContext fClientContext;

    public RESTClient(IClientLibraryContext context) {
        Assert.isNotNull((Object)context);
        this.fClientContext = context;
    }

    public IClientLibraryContext getClientContext() {
        return this.fClientContext;
    }

    public IHttpAccess getHttpAccess() {
        return new IHttpAccess(){
            private boolean fIsModifyingResponse;

            public boolean isModifyingResponse() {
                return this.fIsModifyingResponse;
            }

            public void setModifyingResponse(boolean isModifyingResponse) {
                this.fIsModifyingResponse = isModifyingResponse;
            }

            public String encodeURL(String url) {
                return this.encodeURL(url, "UTF-8");
            }

            public String encodeURL(String url, String encoding) {
                try {
                    String newStr = URLEncoder.encode(url, encoding);
                    return newStr.replace("+", "%20");
                }
                catch (UnsupportedEncodingException ignored) {
                    return url;
                }
            }

            public IHttpAccess.Response performGet(String url, String acceptContent) throws TeamRepositoryException {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", acceptContent.toString());
                return this.performGet(url, headers);
            }

            public IHttpAccess.Response performGet(String url, Map<String, String> headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performGET(new URI(url), headers, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }

            public IHttpAccess.Response performGetWithExtraParameters(String url, String content, String contentType, String acceptContent) throws TeamRepositoryException {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", acceptContent.toString());
                if (content != null && content.length() > 0) {
                    headers.put("X-Method-Override", "GET");
                    return this.performPost(url, content, contentType, headers);
                }
                return this.performGet(url, headers);
            }

            public IHttpAccess.Response performPut(String url, String content, String contentType, Map<String, String> headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performPUTorPOST(true, new URI(url), headers, content, contentType, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }

            public IHttpAccess.Response performPost(String url, String content, String contentType, Map<String, String> headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performPUTorPOST(false, new URI(url), headers, content, contentType, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        };
    }

    public IHttpClient getHttpClient() {
        return new IHttpClient(){

            public boolean isModifyingResponse() {
                return false;
            }

            public IHttpClient.IResponse performGet(String url, HttpHeaders headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performGET(new URI(url), headers, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }

            public IHttpClient.IResponse performGetWithExtraParameters(String url, String content, String contentType, HttpHeaders headers) throws TeamRepositoryException {
                if (content != null && content.length() > 0) {
                    headers.addHeader("X-Method-Override", "GET");
                    return this.performPost(url, content, contentType, headers);
                }
                return this.performGet(url, headers);
            }

            public IHttpClient.IResponse performPut(String url, String content, String contentType, HttpHeaders headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performPUTorPOST(true, new URI(url), headers, content, contentType, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }

            public IHttpClient.IResponse performPost(String url, String content, String contentType, HttpHeaders headers) throws TeamRepositoryException {
                try {
                    return RESTClient.this.performPUTorPOST(false, new URI(url), headers, content, contentType, NLS.bind((String)Messages.getString("RESTClient_ERROR_ACCESSING"), (Object)url, (Object[])new Object[0]), null);
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }

            public IHttpClient.IResponse performPost(String url, HttpEntity entity, HttpHeaders headers) throws TeamRepositoryException {
                throw new UnsupportedOperationException();
            }

            public IHttpClient.IResponse performDelete(String url, HttpHeaders headers) throws TeamRepositoryException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private IHttpClient.IResponse createResponse(ITeamRawRestServiceClient.IRawRestClientConnection.Response rawResponse) throws TeamRepositoryException {
        return new Response(rawResponse.getStatusCode(), new HttpHeaders(rawResponse.getAllResponseHeaders()), rawResponse.getResponseStream());
    }

    private IHttpClient.IResponse createResponse(TeamServiceException ex) throws TeamRepositoryException {
        Header[] headers = ex.getHeaders();
        HttpHeaders newHeaders = new HttpHeaders();
        if (headers != null) {
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                newHeaders.addHeader(header.getName(), header.getValue());
                ++n2;
            }
        }
        return new Response(ex.getStatusCode(), newHeaders, (Throwable)ex);
    }

    private void completeHeaders(ITeamRawRestServiceClient.IRawRestClientConnection connection, HttpHeaders headers) {
        if (!headers.contains("Accept-Charset")) {
            connection.addRequestHeader("Accept-Charset", "UTF-8");
        }
        if (!headers.contains("Accept-Language")) {
            connection.addRequestHeader("Accept-Language", HttpHeaders.getAcceptLanguageHeader((Locale)Locale.getDefault()));
        }
    }

    public IHttpAccess.Response performGET(URI resourceUri, Map<String, String> headers, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IHttpAccess.Response(this.performGET(resourceUri, new HttpHeaders(headers), errorMessage, monitor));
    }

    private IHttpClient.IResponse performGET(final URI resourceUri, final HttpHeaders headers, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRawRestServiceClient rawRestServiceClient = this.fClientContext.teamRepository().getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<IHttpClient.IResponse> block = new IClientLibraryContext.IServiceRunnable<IHttpClient.IResponse>(){

            public IHttpClient.IResponse run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(resourceUri);
                    for (Map.Entry header : headers.getEntries()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    RESTClient.this.completeHeaders(connection, headers);
                    return RESTClient.this.createResponse(connection.doGet());
                }
                catch (TeamServiceException ex) {
                    if (ex.getStatusCode() != -1) {
                        return RESTClient.this.createResponse(ex);
                    }
                    throw ex;
                }
                catch (URISyntaxException ex) {
                    throw new TeamRepositoryException(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        };
        try {
            IHttpClient.IResponse response = (IHttpClient.IResponse)this.fClientContext.callCancelableService((IClientLibraryContext.IServiceRunnable)block, monitor);
            if (response.getStatusCode() != 200) {
                if (errorMessage == null) {
                    throw new IHttpClient.HttpAccessException(response, response.getResponseHeaders().getValue("Warning"));
                }
                throw new IHttpClient.HttpAccessException(response, errorMessage);
            }
            return response;
        }
        catch (AuthenticationException ex) {
            ITeamRepository repository = this.fClientContext.teamRepository();
            if (!repository.loggedIn() && repository.getSavePassword()) {
                repository.login(monitor);
            }
            throw new TeamRepositoryException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public IHttpAccess.Response performPUTorPOST(boolean isPut, URI uri, Map<String, String> headers, String content, String contentType, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IHttpAccess.Response(this.performPUTorPOST(isPut, uri, new HttpHeaders(headers), content, contentType, errorMessage, monitor));
    }

    private IHttpClient.IResponse performPUTorPOST(final boolean isPut, final URI uri, final HttpHeaders headers, final String content, final String contentType, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRawRestServiceClient rawRestServiceClient = this.fClientContext.teamRepository().getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<IHttpClient.IResponse> block = new IClientLibraryContext.IServiceRunnable<IHttpClient.IResponse>(){

            public IHttpClient.IResponse run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(uri);
                    for (Map.Entry header : headers.getEntries()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    RESTClient.this.completeHeaders(connection, headers);
                    String encoding = HttpUtil.CharsetEncoding.UTF8.name();
                    byte[] bytes = content.getBytes(encoding);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    return RESTClient.this.createResponse(isPut ? connection.doPut((InputStream)stream, (long)bytes.length, contentType) : connection.doPost((InputStream)stream, (long)bytes.length, contentType));
                }
                catch (TeamServiceException ex) {
                    if (ex.getStatusCode() != -1) {
                        return RESTClient.this.createResponse(ex);
                    }
                    throw ex;
                }
                catch (URISyntaxException ex) {
                    throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
                }
            }
        };
        IHttpClient.IResponse response = (IHttpClient.IResponse)this.fClientContext.callCancelableService((IClientLibraryContext.IServiceRunnable)block, monitor);
        if (response.getStatusCode() != 200) {
            if (errorMessage == null) {
                throw new TeamRepositoryException(response.getResponseHeaders().getValue("Warning"));
            }
            throw new TeamRepositoryException(errorMessage);
        }
        return response;
    }

    public IHttpAccess.Response performPOST(URI uri, Map<String, String> headers, String content, String contentType, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        return new IHttpAccess.Response(this.performPUTorPOST(false, uri, new HttpHeaders(headers), content, contentType, errorMessage, monitor));
    }
}

