/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.client.internal;

import com.ibm.team.calm.foundation.common.internal.ICALMFoundationRPCService;
import com.ibm.team.calm.foundation.common.linking.ILocalProjectLink;
import com.ibm.team.calm.foundation.common.linking.IProjectLinkingContext;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClientProjectLinkingContext
implements IProjectLinkingContext {
    private final IProjectAreaHandle fProjectAreaHandle;
    private final Collection<IProjectLink> fActiveProjectLinks;
    private Map<String, ILocalProjectLink> fLocalProjectLinks;
    private final IClientLibraryContext fContext;

    public ClientProjectLinkingContext(IProjectAreaHandle projectAreaHandle, Collection<IProjectLink> projectLinks, IClientLibraryContext context) {
        this.fProjectAreaHandle = projectAreaHandle;
        this.fActiveProjectLinks = projectLinks;
        this.fContext = context;
        this.fLocalProjectLinks = new HashMap<String, ILocalProjectLink>(2);
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectAreaHandle;
    }

    public Collection<IProjectLink> getActiveProjectLinks() throws TeamRepositoryException {
        return this.fActiveProjectLinks;
    }

    public ILocalProjectLink getLocalProjectLink(String oslcDomain) throws TeamRepositoryException {
        ILocalProjectLink localProjectLinkDTO = this.fLocalProjectLinks.get(oslcDomain);
        if (localProjectLinkDTO == null) {
            ICALMFoundationRPCService calmService = (ICALMFoundationRPCService)this.fContext.getServiceInterface(ICALMFoundationRPCService.class);
            localProjectLinkDTO = calmService.getLocalProjectLink(this.fProjectAreaHandle, oslcDomain);
            this.fLocalProjectLinks.put(oslcDomain, localProjectLinkDTO);
        }
        return localProjectLinkDTO;
    }
}

