/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class UDRestClient {
    private static final Log log = LogFactory.getLog(UDRestClient.class);
    protected final URI url;
    protected final String clientUser;
    protected final String clientPassword;
    protected final DefaultHttpClient client;

    public UDRestClient(URI url, String clientUser, String clientPassword) {
        this.url = url;
        this.clientUser = clientUser;
        this.clientPassword = clientPassword;
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(clientUser);
        builder.setPassword(clientPassword);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)System.getenv("PROXY_HOST")) && StringUtils.isNumeric((CharSequence)System.getenv("PROXY_PORT"))) {
            log.debug((Object)"Configuring proxy settings.");
            builder.setProxyHost(System.getenv("PROXY_HOST"));
            builder.setProxyPort(Integer.valueOf(System.getenv("PROXY_PORT")).intValue());
        }
        if (!StringUtils.isEmpty((CharSequence)System.getenv("PROXY_USERNAME")) && StringUtils.isNumeric((CharSequence)System.getenv("PROXY_PASSWORD"))) {
            log.debug((Object)"Configuring proxy settings.");
            builder.setProxyUsername(System.getenv("PROXY_USERNAME"));
            builder.setProxyPassword(System.getenv("PROXY_PASSWORD"));
        }
        this.client = builder.buildClient();
    }

    protected JSONObject createNewPropertyJSON(String name, String value, boolean isSecure) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("name", (Object)name).put("value", (Object)value).put("secure", isSecure);
        return result;
    }

    protected JSONObject convertPropArrayToKeyValuePairs(JSONArray propArray) throws JSONException {
        JSONObject result = new JSONObject();
        int i = 0;
        while (i < propArray.length()) {
            JSONObject prop = propArray.getJSONObject(i);
            JSONObject propDefJSON = null;
            try {
                propDefJSON = (JSONObject)prop.get("propValue");
            }
            catch (JSONException e) {
                propDefJSON = (JSONObject)prop.get("propDef");
            }
            String propKey = (String)propDefJSON.get("name");
            String propValue = (String)propDefJSON.get("value");
            result.put(propKey, (Object)propValue);
            ++i;
        }
        return result;
    }

    protected String getBody(HttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            try (InputStreamReader reader = IO.reader((InputStream)body, (Charset)IO.utf8());){
                IO.copy((Reader)reader, (Appendable)builder);
            }
        }
        return builder.toString();
    }

    protected void discardBody(HttpResponse response) {
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
    }

    protected HttpResponse invokeMethod(HttpRequestBase request) throws IOException, ClientProtocolException {
        return this.client.execute((HttpUriRequest)request);
    }

    protected void releaseConnection(HttpRequestBase request) {
        request.releaseConnection();
    }

    protected String encodePath(String path) {
        String result;
        try {
            result = this.sanitizePath(path);
        }
        catch (Exception e) {
            log.debug((Object)("the user input " + path + " could not be sanitized. defaulting to user input"), (Throwable)e);
            result = path;
        }
        return result;
    }

    private String sanitizePath(String path) throws URISyntaxException {
        String result = "";
        String remainingPath = path;
        int dirtyChars = this.count(path, ':') + this.count(path, '&') + this.count(path, '+') + this.count(path, '/');
        int i = 0;
        while (i < dirtyChars) {
            int nextForwardSlash;
            int nextPlus;
            int nextAmpersand;
            int nextColon = remainingPath.indexOf(58);
            if (this.isIndexLeastAndValid(nextColon, nextAmpersand = remainingPath.indexOf(38), nextPlus = remainingPath.indexOf(43), nextForwardSlash = remainingPath.indexOf(47))) {
                result = String.valueOf(result) + this.encodeSubstring(remainingPath.substring(0, nextColon));
                result = String.valueOf(result) + "%3A";
                remainingPath = nextColon < remainingPath.length() ? remainingPath.substring(nextColon + 1) : "";
            } else if (this.isIndexLeastAndValid(nextAmpersand, nextColon, nextPlus, nextForwardSlash)) {
                result = String.valueOf(result) + this.encodeSubstring(remainingPath.substring(0, nextAmpersand));
                result = String.valueOf(result) + "%26";
                remainingPath = nextAmpersand < remainingPath.length() ? remainingPath.substring(nextAmpersand + 1) : "";
            } else if (this.isIndexLeastAndValid(nextPlus, nextColon, nextAmpersand, nextForwardSlash)) {
                result = String.valueOf(result) + this.encodeSubstring(remainingPath.substring(0, nextPlus));
                result = String.valueOf(result) + "%2B";
                remainingPath = nextPlus < remainingPath.length() ? remainingPath.substring(nextPlus + 1) : "";
            } else if (this.isIndexLeastAndValid(nextForwardSlash, nextPlus, nextColon, nextAmpersand)) {
                result = String.valueOf(result) + this.encodeSubstring(remainingPath.substring(0, nextForwardSlash));
                result = String.valueOf(result) + "%2F";
                remainingPath = nextPlus < remainingPath.length() ? remainingPath.substring(nextForwardSlash + 1) : "";
            }
            ++i;
        }
        result = String.valueOf(result) + this.encodeSubstring(remainingPath);
        return result;
    }

    private boolean isIndexLeastAndValid(int indexToTest, int ... others) {
        boolean result = true;
        if (indexToTest >= 0) {
            int i = 0;
            while (i < others.length) {
                if (others[i] > 0 && indexToTest > others[i]) {
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            result = false;
        }
        return result;
    }

    private int count(String fullString, char charToCount) {
        int result = 0;
        char[] cArray = fullString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char charToTest = cArray[n2];
            if (charToCount == charToTest) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    private String encodeSubstring(String toEncode) throws URISyntaxException {
        URI subUri = new URI(null, null, toEncode, null);
        return subUri.toASCIIString();
    }
}

