/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ui.editors.result;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.editors.result.BuildResultContributionProviderBase;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.ui.forms.editor.FormEditor;

public abstract class AbstractBuildResultContributionProvider
extends BuildResultContributionProviderBase {
    private IBuildResultContext fContext;
    private FormEditor fBuildEditor;
    private String fExtensionId;

    public AbstractBuildResultContributionProvider(FormEditor buildEditor, String extensionId, IBuildResultContext context) {
        this.fBuildEditor = buildEditor;
        this.fExtensionId = extensionId;
        this.fContext = context;
    }

    public IBuildResultContext getBuildResultContext() {
        return this.fContext;
    }

    public abstract String[] getExtendedContributionIds();

    public abstract AbstractBuildResultPage getBuildResultPage();

    @Override
    public abstract void initializeContributionProvider(IProgressMonitor var1) throws Exception;

    public boolean shouldHideSummary() {
        return false;
    }

    public abstract String getSummaryText();

    public abstract String getSummaryTitle();

    public abstract BuildStatus getStatus();

    public boolean isSummaryLink() {
        return false;
    }

    public void summaryLinkActivated() {
    }

    public DragSourceAdapter getSummaryLinkDragAdapter() {
        return null;
    }

    public boolean isContributionPresent() {
        return this.getExtendedContributionIds().length == 0 || this.getContributions().length != 0;
    }

    protected FormEditor getBuildResultEditor() {
        return this.fBuildEditor;
    }

    public String getExtensionId() {
        return this.fExtensionId;
    }

    protected IBuildResultContribution[] getContributions() {
        return this.getBuildResultContext().getBuildResultContributions(this.getExtendedContributionIds());
    }
}

