/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ui.editors.builddefinition;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.ui.editor.TeamFormPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractConfigurationElementEditor
extends TeamFormPage {
    private Composite fContentContainer;
    private IManagedForm fManagedForm;
    private ITeamRepository fTeamRepository;
    private boolean fDirty;
    private BuildDefinitionEditor fBuildDefinitionEditor;
    private boolean isBuildDefinitionCreatedUsingTemplate;
    private boolean isAddedThroughEditConfiguration;

    public AbstractConfigurationElementEditor(String elementId, String title) {
        super(elementId, title);
    }

    public abstract void setWorkingCopy(IBuildDefinition var1);

    public abstract void createContent(Composite var1, FormToolkit var2);

    public abstract boolean validate();

    public Control getFocusControl() {
        return null;
    }

    public void initialize(BuildDefinitionEditor editor) {
        super.initialize((FormEditor)editor);
        this.fBuildDefinitionEditor = editor;
        this.fTeamRepository = editor.getTeamRepository();
        this.isBuildDefinitionCreatedUsingTemplate = editor.isBuildDefinitionCreatedUsingTemplate();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        managedForm.getToolkit().setBorderStyle(2048);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        this.fContentContainer = this.createContentContainer(this.fManagedForm);
        this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
    }

    public IManagedForm getManagedForm() {
        return this.fManagedForm;
    }

    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.fBuildDefinitionEditor.fireDirtyPropertyChangeEvent();
    }

    public void refresh() {
        if (this.fContentContainer != null && !this.fContentContainer.isDisposed()) {
            this.fContentContainer.dispose();
            this.fContentContainer = this.createContentContainer(this.fManagedForm);
            this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private Composite createContentContainer(IManagedForm managedForm) {
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        return container;
    }

    protected void setPageErrorIndicator(boolean isError) {
        this.setPageStatusIndicator(isError, false);
    }

    protected void setPageStatusIndicator(boolean isError, boolean isWarning) {
        Image image = null;
        if (isError && this.fBuildDefinitionEditor.isSaveAttempted()) {
            image = BuildUIPlugin.getImage("icons/ovr16/failed_ovr.gif");
        } else if (isWarning) {
            image = BuildUIPlugin.getImage("icons/ovr16/warn_ovr.gif");
        }
        this.fBuildDefinitionEditor.setPageImage(this.getIndex(), image);
    }

    public void addWarningMessage(Object id, String message, Control control) {
        this.fBuildDefinitionEditor.addWarningMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fBuildDefinitionEditor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.fBuildDefinitionEditor.isSaveAttempted()) {
            this.fBuildDefinitionEditor.addErrorMessage(id, message, control, this.getIndex());
        }
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.fBuildDefinitionEditor.addErrorMessage(id, message, status);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.removeMessage(id, control);
    }

    public void removeErrorMessage(Object id) {
        this.removeMessage(id);
    }

    public void removeMessage(Object id, Control control) {
        this.fBuildDefinitionEditor.removeMessage(id, control);
    }

    public void removeMessage(Object id) {
        this.fBuildDefinitionEditor.removeMessage(id);
    }

    public void setFocus() {
        if (this.getFocusControl() != null) {
            this.getFocusControl().setFocus();
        } else {
            ((BuildDefinitionEditor)this.getEditor()).setFocusInHeader();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), this.getContextHelpId());
        }
    }

    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinition";
    }

    public void performExtraSave(IProgressMonitor monitor) {
    }

    public void performExtraSave(IItem[] savedItems, IProgressMonitor monitor) {
    }

    public void postSave(boolean saveSucceeded) {
    }

    public boolean isBuildDefinitionCreatedUsingTemplate() {
        return this.isBuildDefinitionCreatedUsingTemplate;
    }

    public boolean proceedWithSave() {
        return true;
    }

    public void setIsAddedThroughEditConfiguration(boolean isAddedThroughEditConfiguration) {
        this.isAddedThroughEditConfiguration = isAddedThroughEditConfiguration;
    }

    public boolean isAddedThroughEditConfiguration() {
        return this.isAddedThroughEditConfiguration;
    }
}

