/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ui.dialogs.requestbuild;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public abstract class RequestBuildSection {
    private final RequestBuildSectionSite fSite;
    private Section fSection;

    protected RequestBuildSection(RequestBuildSectionSite site) {
        this.fSite = site;
    }

    protected RequestBuildSectionSite getSite() {
        return this.fSite;
    }

    protected abstract String getSectionName();

    public void createContent(Composite parent) {
        this.fSection = new Section(parent, 34);
        GridDataFactory.fillDefaults().grab(true, this.grabVertical()).applyTo((Control)this.fSection);
        this.fSection.setEnabled(false);
        this.fSection.setLayout((Layout)new GridLayout(1, false));
        this.fSection.setText(this.getSectionName());
        this.fSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                RequestBuildSection.this.handleExpansionStateChanged();
            }
        });
    }

    public Section getSection() {
        return this.fSection;
    }

    protected boolean grabVertical() {
        return false;
    }

    private void handleExpansionStateChanged() {
        this.getSite().layoutChanged();
    }

    public void initializationComplete() {
        this.fSection.setEnabled(true);
        this.fSection.setExpanded(false);
        this.createSectionContent(this.fSection);
        this.fSection.setText(this.getSectionName());
        this.fSection.pack();
    }

    protected abstract void createSectionContent(Section var1);

    public String validate() {
        return null;
    }

    public boolean validate2() {
        String errorMsg = this.validate();
        if (errorMsg != null) {
            this.getSite().addErrorMessage(this, errorMsg);
            return false;
        }
        this.getSite().removeErrorMessage(this);
        return true;
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
    }

    public void handlePropertyChanged(String propertyName) {
    }
}

