/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.buildengine;

import com.ibm.team.build.common.buildengine.BuildEngineConfigurationRegistry;
import com.ibm.team.build.common.buildengine.IBuildEngineTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.wizards.buildengine.Messages;
import com.ibm.team.build.internal.ui.wizards.buildengine.NewBuildEngineWizard;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class WizardContext {
    private NewBuildEngineWizard fWizard;
    private IProjectAreaHandle fProjectAreaHandle;
    private ITeamRepository fTeamRepository;
    private IBuildEngine[] fExistingBuildEngines = new IBuildEngine[0];
    private IBuildEngine fBuildEngine;
    private IProcessArea fProcessArea;
    private IBuildEngine fExistingBuildEngine;
    private IBuildEngineTemplate fBuildEngineTemplate;
    private List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();
    private List<String> fBuildEngineElementIds = new ArrayList<String>();
    private List<String> fSelectedBuildEngineElementIds = new ArrayList<String>();

    public WizardContext(NewBuildEngineWizard wizard) {
        this.fWizard = wizard;
    }

    public NewBuildEngineWizard getWizard() {
        return this.fWizard;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public IBuildEngine getBuildEngine() {
        return this.fBuildEngine;
    }

    public void setBuildEngine(IBuildEngine buildEngine) {
        this.fBuildEngine = buildEngine;
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    public void setProcessArea(IProcessArea processArea) {
        this.fProcessArea = processArea;
    }

    public IBuildEngine getExistingBuildEngine() {
        return this.fExistingBuildEngine;
    }

    public void setExistingBuildEngine(IBuildEngine buildEngine) {
        this.fExistingBuildEngine = buildEngine;
    }

    public boolean isExistingBuildEngine() {
        return this.fExistingBuildEngine != null;
    }

    public IBuildEngine[] getExistingBuildEngines() {
        return this.fExistingBuildEngines;
    }

    public void setExistingBuildEngines(IBuildEngine[] buildEngines) {
        this.fExistingBuildEngines = buildEngines;
    }

    public String getSuggestedBuildName() {
        String buildName = null;
        buildName = this.isExistingBuildEngine() ? NLS.bind((String)Messages.WizardContext_BUILD_ENGINE_NAME_COPY, (Object)this.fExistingBuildEngine.getId()) : NLS.bind((String)Messages.WizardContext_BUILD_ENGINE_NAME_TEAM_AREA, (Object)this.getProcessArea().getName());
        int i = 2;
        String suggestedBuildName = buildName;
        while (this.buildEngineNameAlreadyExists(suggestedBuildName)) {
            suggestedBuildName = NLS.bind((String)Messages.WizardContext_BUILD_ENGINE_NAME_COUNTER, (Object)buildName, (Object)i);
            ++i;
        }
        return suggestedBuildName;
    }

    public boolean buildEngineNameAlreadyExists(String buildEngineName) {
        int i = 0;
        while (i < this.fExistingBuildEngines.length) {
            if (this.fExistingBuildEngines[i].getId().equals(buildEngineName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public void setProjectAreaHandle(IProjectAreaHandle projectAreaHandle) {
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public void setBuildEngineTemplate(IBuildEngineTemplate buildEngineTemplate) {
        this.fBuildEngineTemplate = buildEngineTemplate;
        this.fGenericProperties.clear();
        this.fGenericProperties.addAll(Arrays.asList(buildEngineTemplate.getGenericProperties()));
        this.fBuildEngineElementIds.clear();
        this.fSelectedBuildEngineElementIds.clear();
        String[] stringArray = buildEngineTemplate.getConfigurationElementIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elementId = stringArray[n2];
            IBuildConfigurationElement element = BuildEngineConfigurationRegistry.getInstance().getBuildEngineConfigurationElement(elementId);
            if (element != null) {
                this.fBuildEngineElementIds.add(element.getElementId());
                this.fSelectedBuildEngineElementIds.add(element.getElementId());
            }
            ++n2;
        }
    }

    public IBuildEngineTemplate getBuildEngineTemplate() {
        return this.fBuildEngineTemplate;
    }

    public List<IBuildProperty> getGenericProperties() {
        return this.fGenericProperties;
    }

    public List<String> getSelectedBuildEngineElementIds() {
        return this.fSelectedBuildEngineElementIds;
    }

    public List<String> getBuildEngineElementIds() {
        return this.fBuildEngineElementIds;
    }

    public boolean isExistingEngineId(String engineId) {
        IBuildEngine[] existingBuildEngines = this.getExistingBuildEngines();
        if (existingBuildEngines != null) {
            IBuildEngine[] iBuildEngineArray = existingBuildEngines;
            int n = existingBuildEngines.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildEngine engine = iBuildEngineArray[n2];
                if (engineId.equals(engine.getId())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

