/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.buildengine;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.buildengine.BuildEngineConfigurationRegistry;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.impl.BuildEngineImpl;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.editors.buildengine.BuildEngineEditorInput;
import com.ibm.team.build.internal.ui.wizards.buildengine.BuildEngineTemplateSelectionPage;
import com.ibm.team.build.internal.ui.wizards.buildengine.Messages;
import com.ibm.team.build.internal.ui.wizards.buildengine.ProcessAreaSelectionPage;
import com.ibm.team.build.internal.ui.wizards.buildengine.WizardContext;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NewBuildEngineWizard
extends Wizard
implements INewWizard {
    protected WizardContext fWizardContext;
    private RepositoryCreationPage fRepositoryCreationPage;
    private RepositorySelectionPage fRepositorySelectionPage;
    private ProcessAreaSelectionPage fProcessAreaSelectionPage;
    private BuildEngineTemplateSelectionPage fEngineTemplateSelectionPage;

    public NewBuildEngineWizard() {
        this((IProjectAreaHandle)null, (ITeamRepository)null);
    }

    private NewBuildEngineWizard(IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        this.setWindowTitle(Messages.NewBuildEngineWizard_WIZARD_TITLE);
        this.fWizardContext = new WizardContext(this);
        this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
        if (projectAreaHandle == null) {
            this.fWizardContext.setTeamRepository(teamRepository);
        } else {
            this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
        }
        IBuildEngine buildEngine = BuildItemFactory.createBuildEngine();
        this.fWizardContext.setBuildEngine(buildEngine);
        this.setHelpAvailable(false);
    }

    public NewBuildEngineWizard(IProjectAreaHandle projectAreaHandle) {
        this(projectAreaHandle, null);
    }

    public NewBuildEngineWizard(ITeamRepository teamRepository) {
        this(null, teamRepository);
    }

    public NewBuildEngineWizard(IProcessArea processArea, IBuildEngine[] existingEngines) {
        this(processArea.getProjectArea(), null);
        ValidationHelper.validateNotNull((String)"existingEngines", (Object[])existingEngines);
        this.fWizardContext.setProcessArea(processArea);
        this.fWizardContext.setExistingBuildEngines(existingEngines);
    }

    public boolean performFinish() {
        if (this.fWizardContext.getProcessArea() instanceof ITeamArea) {
            ConnectedProjectAreaRegistry.getDefault().addSelectedTeamArea(this.fWizardContext.getProjectAreaHandle(), (ITeamArea)this.fWizardContext.getProcessArea());
        }
        this.initializeBuildEngine();
        if (this.openEditorOnFinish()) {
            this.openBuildEngineEditor(this.fWizardContext.getBuildEngine());
        }
        return true;
    }

    protected boolean openEditorOnFinish() {
        return true;
    }

    public IBuildEngine getBuildEngine() {
        return this.fWizardContext.getBuildEngine();
    }

    protected void displayErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected void logException(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    private void openBuildEngineEditor(IBuildEngine buildEngine) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                this.openBuildEngine(buildEngine, page);
            }
            catch (PartInitException exception) {
                this.logException((Exception)((Object)exception));
            }
        }
    }

    protected void openBuildEngine(IBuildEngine buildEngine, IWorkbenchPage page) throws PartInitException {
        BuildEngineEditorInput input = new BuildEngineEditorInput(buildEngine, this.fWizardContext.getProcessArea(), this.fWizardContext.getTeamRepository());
        if (this.fWizardContext.isExistingBuildEngine()) {
            ArrayList<IBuildDefinitionHandle> supportedDefinitions = new ArrayList<IBuildDefinitionHandle>();
            supportedDefinitions.addAll(this.fWizardContext.getExistingBuildEngine().getSupportedBuildDefinitions());
            input.setDefaultSupportedBuildDefinitions(supportedDefinitions);
        }
        page.openEditor((IEditorInput)input, "com.ibm.team.build.ui.editors.buildEngineEditor");
    }

    private void initializeBuildEngine() throws IllegalArgumentException {
        IBuildEngine buildEngine = null;
        if (this.fWizardContext.isExistingBuildEngine()) {
            buildEngine = this.fWizardContext.getExistingBuildEngine().copyEngine();
            buildEngine.setId(this.fWizardContext.getSuggestedBuildName());
            buildEngine.setProcessArea((IProcessAreaHandle)this.fWizardContext.getProcessArea());
            this.fWizardContext.setBuildEngine(buildEngine);
        } else {
            buildEngine = this.fWizardContext.getBuildEngine();
            buildEngine.setProcessArea((IProcessAreaHandle)this.fWizardContext.getProcessArea());
            buildEngine.setActive(true);
            buildEngine.setMonitoringThreshold(3);
            List<IBuildProperty> genericProperties = this.fWizardContext.getGenericProperties();
            for (IBuildProperty property : genericProperties) {
                buildEngine.getProperties().add(property);
            }
            for (String elementId : this.fWizardContext.getSelectedBuildEngineElementIds()) {
                IBuildConfigurationElement element = BuildEngineConfigurationRegistry.getInstance().getBuildEngineConfigurationElement(elementId);
                if (element == null) continue;
                buildEngine.initializeConfiguration(element);
            }
            ((BuildEngineImpl)buildEngine).setTemplateId(this.fWizardContext.getBuildEngineTemplate().getId());
        }
    }

    protected String getBundleLocation(String pluginId) throws IOException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL entry = bundle.getEntry("/");
        URL resolvedUrl = FileLocator.resolve((URL)entry);
        Path path = new Path(resolvedUrl.getPath());
        path = path.removeTrailingSeparator();
        return path.toOSString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof DomainSubtreeRoot) {
            DomainSubtreeRoot root = (DomainSubtreeRoot)object;
            Object category = root.getCategoryElement();
            if (category instanceof IProjectAreaHandle || category instanceof ITeamArea) {
                if (category instanceof ITeamArea) {
                    category = ((ITeamArea)category).getProjectArea();
                }
                IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
                this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
                this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
            }
        } else if (object instanceof IProjectAreaHandle) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)object;
            this.fWizardContext.setProjectAreaHandle(projectAreaHandle);
            this.fWizardContext.setTeamRepository((ITeamRepository)projectAreaHandle.getOrigin());
        } else if (object instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)object;
            this.fWizardContext.setProjectAreaHandle(teamArea.getProjectArea());
            this.fWizardContext.setProcessArea((IProcessArea)teamArea);
            this.fWizardContext.setTeamRepository((ITeamRepository)teamArea.getOrigin());
        } else if (object instanceof ITeamRepository) {
            this.fWizardContext.setTeamRepository((ITeamRepository)object);
        } else if (object instanceof IItemHandle) {
            IItemHandle itemHandle = (IItemHandle)object;
            this.fWizardContext.setTeamRepository((ITeamRepository)itemHandle.getOrigin());
        }
    }

    public void addPages() {
        if (this.fWizardContext.getTeamRepository() == null) {
            ITeamRepository[] teamRepositories = this.getTeamRepositories();
            if (teamRepositories.length > 0) {
                this.addPage(this.getRepositorySelectionPage());
            }
            this.addPage(this.getRepositoryCreationPage());
        }
        if (this.fWizardContext.getProcessArea() == null) {
            this.addPage((IWizardPage)this.getProcessAreaSelectionPage());
        }
        this.addPage((IWizardPage)this.getBuildEngineTemplateSelectionPage());
    }

    protected ITeamRepository[] getTeamRepositories() {
        return TeamPlatform.getTeamRepositoryService().getTeamRepositories();
    }

    protected IWizardPage getRepositorySelectionPage() {
        if (this.fRepositorySelectionPage == null) {
            this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.NewBuildEngineWizard_REPOSITORY_SELECTION_PAGE_TITLE, Messages.NewBuildEngineWizard_REPOSITORY_SELECTION_PAGE_DESCRIPTION);
        }
        return this.fRepositorySelectionPage;
    }

    protected IWizardPage getRepositoryCreationPage() {
        if (this.fRepositoryCreationPage == null) {
            this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.NewBuildEngineWizard_REPOSITORY_SELECTION_PAGE_TITLE, Messages.NewBuildEngineWizard_REPOSITORY_CREATION_PAGE_DESCRIPTION);
        }
        return this.fRepositoryCreationPage;
    }

    protected ProcessAreaSelectionPage getProcessAreaSelectionPage() {
        if (this.fProcessAreaSelectionPage == null) {
            this.fProcessAreaSelectionPage = new ProcessAreaSelectionPage(this.fWizardContext);
        }
        return this.fProcessAreaSelectionPage;
    }

    protected BuildEngineTemplateSelectionPage getBuildEngineTemplateSelectionPage() {
        if (this.fEngineTemplateSelectionPage == null) {
            this.fEngineTemplateSelectionPage = new BuildEngineTemplateSelectionPage(this.fWizardContext);
        }
        return this.fEngineTemplateSelectionPage;
    }

    public boolean canFinish() {
        if (this.fWizardContext.getTeamRepository() != null && this.fWizardContext.getTeamRepository().loggedIn()) {
            if (this.fWizardContext.getExistingBuildEngine() != null && this.fWizardContext.getProcessArea() != null) {
                return true;
            }
            int selectedConfigElementCount = this.fWizardContext.getSelectedBuildEngineElementIds().size();
            if (selectedConfigElementCount == 0) {
                return false;
            }
            return super.canFinish();
        }
        return false;
    }

    protected ITeamRepository getSelectedRepository(RepositorySelectionPage page) {
        return page.getTeamRepository();
    }

    protected ITeamRepository createRepository(RepositoryCreationPage page) {
        return page.createRepository();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fRepositorySelectionPage) {
            ITeamRepository teamRepository = this.getSelectedRepository(this.fRepositorySelectionPage);
            if (teamRepository == null) {
                return this.getRepositoryCreationPage();
            }
            this.fWizardContext.setTeamRepository(teamRepository);
            if (this.fRepositoryCreationPage != null) {
                this.fRepositoryCreationPage.setStatus(Status.OK_STATUS);
            }
            return this.getProcessAreaSelectionPage();
        }
        if (page == this.fRepositoryCreationPage) {
            ITeamRepository teamRepository = this.createRepository(this.fRepositoryCreationPage);
            if (teamRepository != null) {
                this.fWizardContext.setTeamRepository(teamRepository);
                return this.getProcessAreaSelectionPage();
            }
            return page;
        }
        return super.getNextPage(page);
    }
}

