/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.buildengine;

import com.ibm.team.build.common.buildengine.BuildEngineConfigurationRegistry;
import com.ibm.team.build.common.buildengine.IBuildEngineTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.internal.ui.wizards.buildengine.Messages;
import com.ibm.team.build.internal.ui.wizards.buildengine.WizardContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BuildEngineTemplateSelectionPage
extends WizardPage {
    protected final WizardContext fWizardContext;
    protected Text fBuildEngineIdText;
    protected Text fBuildDescriptionText;
    protected TableViewer fTableViewer;
    protected Composite fTemplateDescriptionComposite;
    protected Label fTemplateDescriptionLabel;
    private boolean fFirstShowing = true;

    public BuildEngineTemplateSelectionPage(WizardContext context) {
        super(BuildEngineTemplateSelectionPage.class.getName());
        this.fWizardContext = context;
        this.setTitle(Messages.BuildEngineTemplateSelectionPage_GENERAL_INFO_TITLE);
        this.setDescription(Messages.BuildEngineTemplateSelectionPage_GENERAL_INFO_DESC);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = this.createPageContent(parent);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private Composite createPageContent(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(1808));
        Label idLabel = new Label(page, 0);
        idLabel.setText(Messages.BuildEngineTemplateSelectionPage_LABEL_BUILD_ID);
        this.fBuildEngineIdText = new Text(page, 2048);
        this.fBuildEngineIdText.setLayoutData((Object)new GridData(768));
        this.fBuildEngineIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildEngineTemplateSelectionPage.this.handleNameTextModified();
            }
        });
        Label descriptionLabel = new Label(page, 0);
        descriptionLabel.setText(Messages.BuildEngineTemplateSelectionPage_LABEL_BUILD_DESCRIPTION);
        this.fBuildDescriptionText = new Text(page, 2048);
        GridData gridData = new GridData(768);
        this.fBuildDescriptionText.setLayoutData((Object)gridData);
        this.fBuildDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildEngineTemplateSelectionPage.this.handleDescriptionTextModified();
            }
        });
        this.createBuildEngineTypeSelectionTable(page);
        return page;
    }

    private void createBuildEngineTypeSelectionTable(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 64);
        label.setText(Messages.BuildEngineTemplateSelectionPage_LABEL_AVAILABLE_TEMPLATES);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fTableViewer = new TableViewer(parent, 2820);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IBuildEngineTemplate)element).getName();
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBuildEngineTemplate t1 = (IBuildEngineTemplate)e1;
                IBuildEngineTemplate t2 = (IBuildEngineTemplate)e2;
                if ("com.ibm.team.build.engine.jbe".equals(t1.getId())) {
                    return -1;
                }
                if ("com.ibm.team.build.engine.jbe".equals(t2.getId())) {
                    return 1;
                }
                return super.getComparator().compare(t1.getName(), t2.getName());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildEngineTemplateSelectionPage.this.handleSelectionChanged();
            }
        });
        this.fTableViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.fTemplateDescriptionComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fTemplateDescriptionComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.fTemplateDescriptionComposite);
        Label descriptionTitle = new Label(this.fTemplateDescriptionComposite, 0);
        descriptionTitle.setText(Messages.BuildEngineTemplateSelectionPage_TEMPLATE_DESCRIPTION_LABEL);
        descriptionTitle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fTemplateDescriptionLabel = new Label(this.fTemplateDescriptionComposite, 64);
        GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).hint(300, -1).applyTo((Control)this.fTemplateDescriptionLabel);
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuildEngineTemplateSelectionPage.this.handleDoubleClick();
            }
        };
    }

    private void handleDoubleClick() {
        if (this.validate()) {
            IWizardPage nextPage = this.getNextPage();
            if (nextPage != null) {
                this.getContainer().showPage(nextPage);
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish() && this.getWizard().getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getWizard().getContainer()).close();
            }
        }
    }

    private void handleSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() > 0) {
            IBuildEngineTemplate template = (IBuildEngineTemplate)selection.getFirstElement();
            this.fWizardContext.setBuildEngineTemplate(template);
            String description = template.getDescription();
            if (description == null || description.length() == 0) {
                description = Messages.BuildEngineTemplateSelectionPage_NO_DESCRIPTION;
            }
            this.fTemplateDescriptionLabel.setText(description);
            this.fTemplateDescriptionComposite.getParent().layout(true);
        }
        this.validate();
    }

    private void handleNameTextModified() {
        this.validate();
        this.fWizardContext.getBuildEngine().setId(this.fBuildEngineIdText.getText());
    }

    private void handleDescriptionTextModified() {
        this.fWizardContext.getBuildEngine().setDescription(this.fBuildDescriptionText.getText().trim());
    }

    protected boolean validate() {
        String error = this.validateId();
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            this.getContainer().updateButtons();
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.getContainer().updateButtons();
        return true;
    }

    private String validateId() {
        String engineId = this.fBuildEngineIdText.getText();
        if (engineId.length() < 1) {
            return Messages.BuildEngineTemplateSelectionPage_ERROR_NAME_MISSING;
        }
        if (this.fWizardContext.isExistingEngineId(engineId)) {
            return Messages.BuildEngineTemplateSelectionPage_DUPLICATE;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fFirstShowing) {
                List<IBuildEngineTemplate> templates = this.getValidTemplates();
                if (!templates.isEmpty()) {
                    this.fTableViewer.setInput(templates);
                    IBuildEngineTemplate template = (IBuildEngineTemplate)this.fTableViewer.getElementAt(0);
                    this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
                    this.fWizardContext.setBuildEngineTemplate(template);
                    this.fFirstShowing = false;
                    String buildName = this.fWizardContext.getSuggestedBuildName();
                    this.fBuildEngineIdText.setText(buildName);
                    this.fBuildEngineIdText.setFocus();
                    this.fBuildEngineIdText.selectAll();
                    this.fWizardContext.getBuildEngine().setId(buildName);
                }
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
            }
            this.validate();
        }
    }

    protected List<IBuildEngineTemplate> getValidTemplates() {
        IBuildEngineTemplate[] templates;
        ArrayList<IBuildEngineTemplate> validTemplates = new ArrayList<IBuildEngineTemplate>();
        IBuildEngineTemplate[] iBuildEngineTemplateArray = templates = BuildEngineConfigurationRegistry.getInstance().getBuildEngineTemplates();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEngineTemplate template = iBuildEngineTemplateArray[n2];
            if (this.isValidTemplate(template)) {
                validTemplates.add(template);
            }
            ++n2;
        }
        return validTemplates;
    }

    private boolean isValidTemplate(IBuildEngineTemplate template) {
        String[] stringArray = template.getConfigurationElementIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elementId = stringArray[n2];
            IBuildConfigurationElement element = BuildEngineConfigurationRegistry.getInstance().getBuildEngineConfigurationElement(elementId);
            if (element == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getHelpId() {
        return "com.ibm.team.build.ui.wizard_enginetemplateselection";
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
    }

    public IWizardPage getNextPage() {
        return null;
    }
}

