/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.builddefinition;

import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.wizards.builddefinition.Messages;
import com.ibm.team.build.internal.ui.wizards.builddefinition.NewBuildDefinitionWizard;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class WizardContext {
    private final NewBuildDefinitionWizard fWizard;
    private IProjectAreaHandle fProjectAreaHandle;
    private ITeamRepository fTeamRepository;
    private IBuildFolderHandle fBuildFolderHandle;
    private IBuildDefinition[] fExistingBuildDefinitions = new IBuildDefinition[0];
    private IBuildDefinition[] fFilteredDefinitions = new IBuildDefinition[0];
    private IBuildDefinition fBuildDefinition;
    private IProcessArea fProcessArea;
    private IBuildDefinition fExistingBuildDefinition;
    private IBuildDefinitionTemplate fBuildTemplate;
    private List<IBuildProperty> fGenericProperties = new ArrayList<IBuildProperty>();
    private List<String> fPreBuildElementIds = new ArrayList<String>();
    private List<String> fBuildElementIds = new ArrayList<String>();
    private List<String> fPostBuildElementIds = new ArrayList<String>();
    private List<String> fUnspecifiedElementIds = new ArrayList<String>();
    private List<String> fSelectedPreBuildElementIds = new ArrayList<String>();
    private List<String> fSelectedBuildElementIds = new ArrayList<String>();
    private List<String> fSelectedPostBuildElementIds = new ArrayList<String>();
    private List<String> fSelectedUnspecifiedElementIds = new ArrayList<String>();

    public WizardContext(NewBuildDefinitionWizard wizard) {
        this.fWizard = wizard;
    }

    public NewBuildDefinitionWizard getWizard() {
        return this.fWizard;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.fBuildDefinition = buildDefinition;
    }

    public IProcessArea getProcessArea() {
        return this.fProcessArea;
    }

    public void setProcessArea(IProcessArea processArea) {
        this.fProcessArea = processArea;
    }

    public IBuildDefinition getExistingBuildDefinition() {
        return this.fExistingBuildDefinition;
    }

    public void setExistingBuildDefinition(IBuildDefinition buildDefinition) {
        this.fExistingBuildDefinition = buildDefinition;
    }

    public boolean isExistingBuildDefinition() {
        return this.fExistingBuildDefinition != null;
    }

    public synchronized IBuildDefinition[] getExistingBuildDefinitions() {
        return this.fExistingBuildDefinitions;
    }

    public synchronized void setExistingBuildDefinitions(IBuildDefinition[] buildDefinitions) {
        this.fExistingBuildDefinitions = buildDefinitions;
        this.fFilteredDefinitions = null;
    }

    protected synchronized IBuildDefinition[] getFilteredDefinitions() {
        if (this.fFilteredDefinitions == null) {
            List<IBuildDefinition> buildDefinitions = this.filterExistingDefinitions(Arrays.asList(this.getExistingBuildDefinitions()));
            this.fFilteredDefinitions = buildDefinitions.toArray(new IBuildDefinition[buildDefinitions.size()]);
        }
        return this.fFilteredDefinitions;
    }

    private List<IBuildDefinition> filterExistingDefinitions(List<IBuildDefinition> existingDefinitions) {
        LinkedList<IBuildDefinition> filteredDefinitions = new LinkedList<IBuildDefinition>();
        for (IBuildDefinition definition : existingDefinitions) {
            if (!this.includeExistingDefinition(definition)) continue;
            filteredDefinitions.add(definition);
        }
        return filteredDefinitions;
    }

    protected boolean includeExistingDefinition(IBuildDefinition definition) {
        return !EnterpriseHelper.isEnterpriseDefinition(definition);
    }

    public String getSuggestedBuildName() {
        String buildName = null;
        buildName = this.isExistingBuildDefinition() ? NLS.bind((String)Messages.WizardContext_BUILD_NAME_COPY, (Object)this.fExistingBuildDefinition.getId()) : NLS.bind((String)Messages.WizardContext_BUILD_NAME_TEAM_AREA, (Object)this.getProcessArea().getName());
        int i = 2;
        String suggestedBuildName = buildName;
        while (this.buildNameAlreadyExists(suggestedBuildName)) {
            suggestedBuildName = NLS.bind((String)Messages.WizardContext_BUILD_NAME_COUNTER, (Object)buildName, (Object)i);
            ++i;
        }
        return suggestedBuildName;
    }

    public boolean buildNameAlreadyExists(String buildName) {
        IBuildDefinition[] iBuildDefinitionArray = this.getExistingBuildDefinitions();
        int n = iBuildDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinition definition = iBuildDefinitionArray[n2];
            if (definition.getId().equals(buildName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public void setProjectAreaHandle(IProjectAreaHandle projectAreaHandle) {
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public IBuildFolderHandle getParentBuildFolder() {
        return this.fBuildFolderHandle;
    }

    public void setParentBuildFolder(IBuildFolderHandle parentBuildFolderHandle) {
        this.fBuildFolderHandle = parentBuildFolderHandle;
    }

    public void setBuildTemplate(IBuildDefinitionTemplate buildTemplate) {
        IBuildConfigurationElement element;
        String elementId;
        this.fBuildTemplate = buildTemplate;
        this.fGenericProperties.clear();
        this.fGenericProperties.addAll(Arrays.asList(buildTemplate.getGenericProperties()));
        this.fPreBuildElementIds.clear();
        this.fBuildElementIds.clear();
        this.fPostBuildElementIds.clear();
        this.fUnspecifiedElementIds.clear();
        this.fSelectedPreBuildElementIds.clear();
        this.fSelectedBuildElementIds.clear();
        this.fSelectedPostBuildElementIds.clear();
        this.fSelectedUnspecifiedElementIds.clear();
        String[] stringArray = buildTemplate.getConfigurationElementIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            elementId = stringArray[n2];
            element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
            if (element.getBuildPhase() == BuildPhase.PRE_BUILD) {
                this.fPreBuildElementIds.add(element.getElementId());
                this.fSelectedPreBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.BUILD) {
                this.fBuildElementIds.add(element.getElementId());
                this.fSelectedBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.POST_BUILD) {
                this.fPostBuildElementIds.add(element.getElementId());
                this.fSelectedPostBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.UNSPECIFIED) {
                this.fUnspecifiedElementIds.add(element.getElementId());
                this.fSelectedUnspecifiedElementIds.add(element.getElementId());
            }
            ++n2;
        }
        stringArray = buildTemplate.getAvailableConfigurationElementIds();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            elementId = stringArray[n2];
            element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
            if (element.getBuildPhase() == BuildPhase.PRE_BUILD) {
                this.fPreBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.BUILD) {
                this.fBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.POST_BUILD) {
                this.fPostBuildElementIds.add(element.getElementId());
            } else if (element.getBuildPhase() == BuildPhase.UNSPECIFIED) {
                this.fUnspecifiedElementIds.add(element.getElementId());
            }
            ++n2;
        }
    }

    public IBuildDefinitionTemplate getBuildTemplate() {
        return this.fBuildTemplate;
    }

    public List<IBuildProperty> getGenericProperties() {
        return this.fGenericProperties;
    }

    public List<String> getSelectedPreBuildElementIds() {
        return this.fSelectedPreBuildElementIds;
    }

    public List<String> getSelectedPostBuildElementIds() {
        return this.fSelectedPostBuildElementIds;
    }

    public List<String> getSelectedUnspecifiedElementIds() {
        return this.fSelectedUnspecifiedElementIds;
    }

    public List<String> getPreBuildElementIds() {
        return this.fPreBuildElementIds;
    }

    public List<String> getSelectedBuildElementIds() {
        return this.fSelectedBuildElementIds;
    }

    public List<String> getBuildElementIds() {
        return this.fBuildElementIds;
    }

    public List<String> getPostBuildElementIds() {
        return this.fPostBuildElementIds;
    }

    public List<String> getUnspecifiedBuildElementIds() {
        return this.fUnspecifiedElementIds;
    }
}

