/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.builddefinition;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildFolder;
import com.ibm.team.build.common.model.IBuildFolderHandle;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.wizards.builddefinition.Messages;
import com.ibm.team.build.internal.ui.wizards.builddefinition.WizardContext;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProcessAreaSelectionPage
extends WizardPage {
    private static final String PROJECT_AREA_ID_PREFERENCE = "savedProjectAreaId";
    private static final String PROCESS_AREA_ID_PREFERENCE = "savedProcessAreaId";
    protected WizardContext fWizardContext;
    protected Button fCreateFromScratchButton;
    protected Button fCreateFromExistingButton;
    protected TableViewer fBuildDefinitionsViewer;
    protected Text fProcessAreaText;
    private Job fFetchJob;

    public ProcessAreaSelectionPage(WizardContext context) {
        super(ProcessAreaSelectionPage.class.getName());
        this.fWizardContext = context;
        this.setTitle(this.getTitleText());
        this.setDescription(this.getDescriptionText());
    }

    protected String getDescriptionText() {
        return Messages.InitialPage_WIZARD_DESCRIPTION;
    }

    protected String getTitleText() {
        return Messages.InitialPage_WIZARD_TITLE;
    }

    protected String getProcessAreaLabel() {
        return Messages.InitialPage_PROCESS_AREA_LABEL;
    }

    protected String getCreateScratchText() {
        return Messages.InitialPage_CREATE_SCRATCH;
    }

    protected String getCreateCopyText() {
        return Messages.InitialPage_CREATE_COPY;
    }

    public void createControl(Composite parent) {
        Composite container = this.createPageContent(parent);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private Composite createPageContent(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(1808));
        this.createProcessAreaControl(page);
        this.fCreateFromScratchButton = new Button(page, 16);
        this.fCreateFromScratchButton.setText(this.getCreateScratchText());
        GridData data = new GridData();
        this.fCreateFromScratchButton.setLayoutData((Object)data);
        this.fCreateFromScratchButton.addSelectionListener(this.getCreateScratchButtonSelectionListener());
        this.fCreateFromExistingButton = new Button(page, 16);
        this.fCreateFromExistingButton.setText(this.getCreateCopyText());
        data = new GridData();
        this.fCreateFromExistingButton.setLayoutData((Object)data);
        this.fCreateFromExistingButton.addSelectionListener(this.getCreateExistingButtonSelectionListener());
        this.fCreateFromExistingButton.setEnabled(false);
        this.fBuildDefinitionsViewer = new TableViewer(page, 2820);
        data = new GridData(1808);
        data.heightHint = 100;
        this.fBuildDefinitionsViewer.getTable().setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.fBuildDefinitionsViewer.getTable().setLayout((Layout)layout);
        TableColumn column = new TableColumn(this.fBuildDefinitionsViewer.getTable(), 0);
        column.setResizable(true);
        this.fBuildDefinitionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessAreaSelectionPage.this.handleBuildDefinitionSelected();
            }
        });
        this.fBuildDefinitionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBuildDefinitionsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IBuildDefinition) {
                    return BuildUIPlugin.getImage("icons/obj16/build_type_obj.gif");
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IBuildDefinition) {
                    return ((IBuildDefinition)element).getId();
                }
                return super.getText(element);
            }
        });
        this.fBuildDefinitionsViewer.setInput((Object)new String[]{Messages.InitialPage_PENDING_LABEL});
        this.fBuildDefinitionsViewer.setSorter(new ViewerSorter());
        this.fCreateFromScratchButton.setSelection(true);
        return page;
    }

    private void createProcessAreaControl(Composite page) {
        Composite processAreaControl = new Composite(page, 0);
        GridData data = new GridData(768);
        processAreaControl.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        processAreaControl.setLayout((Layout)layout);
        Label label = new Label(processAreaControl, 0);
        label.setText(this.getProcessAreaLabel());
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fProcessAreaText = new Text(processAreaControl, 2048);
        data = new GridData(768);
        this.fProcessAreaText.setLayoutData((Object)data);
        this.fProcessAreaText.setEditable(false);
        if (this.fWizardContext.getProcessArea() != null) {
            this.fProcessAreaText.setText(this.fWizardContext.getProcessArea().getName());
        } else {
            this.fProcessAreaText.setText(Messages.InitialPage_PENDING_LABEL);
        }
        Button browseButton = new Button(processAreaControl, 8);
        browseButton.setText(Messages.InitialPage_BROWSE_LABEL);
        this.initializeDialogUnits((Control)browseButton);
        this.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
    }

    private void handleBrowseButtonSelected() {
        ProcessAreaSelectionDialog dialog = this.getDialog();
        dialog.setInput((Object)this.fWizardContext.getTeamRepository());
        if (this.fWizardContext.getParentBuildFolder() != null && this.fWizardContext.getProjectAreaHandle() != null) {
            dialog.addFilter(this.getProjectAreaFilter());
        }
        if (this.openDialog(dialog) == 0) {
            IProcessArea selectedProcessArea = dialog.getSelectedProcessArea();
            this.fWizardContext.setProcessArea(selectedProcessArea);
            this.fProcessAreaText.setText(selectedProcessArea.getName());
            this.fWizardContext.setProjectAreaHandle(selectedProcessArea.getProjectArea());
            this.saveProjectAreaUUID(selectedProcessArea.getProjectArea().getItemId().getUuidValue());
            this.saveProcessAreaUUID(selectedProcessArea.getItemId().getUuidValue());
            this.validate();
        }
    }

    protected ViewerFilter getProjectAreaFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProcessArea) {
                    IProcessArea processArea = (IProcessArea)element;
                    return processArea.getProjectArea().sameItemId((IItemHandle)ProcessAreaSelectionPage.this.fWizardContext.getProjectAreaHandle());
                }
                return true;
            }
        };
    }

    protected ProcessAreaSelectionDialog getDialog() {
        return new ProcessAreaSelectionDialog(this.getShell(), false);
    }

    private void handleBuildDefinitionSelected() {
        IBuildDefinition buildDefinition = null;
        IStructuredSelection selection = (IStructuredSelection)this.fBuildDefinitionsViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IBuildDefinition) {
            buildDefinition = (IBuildDefinition)element;
        }
        this.fWizardContext.setExistingBuildDefinition(buildDefinition);
    }

    private void enableCreateFromExistingButton() {
        if (this.fCreateFromExistingButton != null && !this.fCreateFromExistingButton.isDisposed()) {
            this.fCreateFromExistingButton.setEnabled(true);
        }
    }

    private void handleCreateFromExistingButtonSelected() {
        this.fBuildDefinitionsViewer.getTable().setEnabled(true);
        IStructuredSelection selection = (IStructuredSelection)this.fBuildDefinitionsViewer.getSelection();
        if (selection.isEmpty()) {
            this.fBuildDefinitionsViewer.setSelection((ISelection)new StructuredSelection(this.fBuildDefinitionsViewer.getElementAt(0)));
        } else if (selection.getFirstElement() instanceof IBuildDefinition) {
            this.fWizardContext.setExistingBuildDefinition((IBuildDefinition)selection.getFirstElement());
        }
        this.validate();
    }

    private void handleCreateFromScratchButtonSelected(boolean isValidateNeeded) {
        this.fBuildDefinitionsViewer.getTable().setEnabled(false);
        this.fWizardContext.setExistingBuildDefinition(null);
        if (isValidateNeeded) {
            this.validate();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFetchJob == null) {
                this.setPageComplete(false);
                this.fFetchJob = this.getFetchJob();
                this.fFetchJob.schedule();
            } else {
                this.validate();
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.build.ui.wizard_teamareaselection");
        }
        super.setVisible(visible);
    }

    protected Job getFetchJob() {
        return new Job(Messages.InitialPage_JOB_LABEL_RETRIEVING_BUILD_DATA){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProcessAreaSelectionPage.this.fetchProcessArea(monitor);
                    ProcessAreaSelectionPage.this.fetchBuildDefinitions(monitor);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).ProcessAreaSelectionPage.this.fProcessAreaText.isDisposed()) {
                                ProcessAreaSelectionPage.this.refreshTeamAreaText();
                                ProcessAreaSelectionPage.this.refreshBuildDefinitionsViewer();
                                ProcessAreaSelectionPage.this.enableCreateFromExistingButton();
                                ProcessAreaSelectionPage.this.handleCreateFromScratchButtonSelected(false);
                                ProcessAreaSelectionPage.this.getContainer().updateButtons();
                            }
                        }
                    });
                }
                catch (TeamRepositoryException exception) {
                    ProcessAreaSelectionPage.this.logException((Exception)((Object)exception));
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected void fetchProcessArea(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fWizardContext.getProcessArea() != null) {
            return;
        }
        ITeamRepository teamRepository = this.fWizardContext.getTeamRepository();
        if (this.fWizardContext.getParentBuildFolder() != null) {
            IProcessArea processArea = null;
            try {
                processArea = this.getFolderProcessArea(this.fWizardContext.getParentBuildFolder(), monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (processArea != null) {
                this.fWizardContext.setProcessArea(processArea);
                return;
            }
            BuildUIHelper.showInfoDialog(null, Messages.ProcessAreaSelectionPage_BUILD_FOLDER_NOT_FOUND_TITLE, Messages.ProcessAreaSelectionPage_BUILD_FOLDER_NOT_FOUND_MESSAGE);
            this.fWizardContext.setParentBuildFolder(null);
        }
        IProjectArea projectArea = null;
        if (this.fWizardContext.getProjectAreaHandle() != null) {
            try {
                projectArea = this.fetchProjectArea(this.fWizardContext.getProjectAreaHandle(), teamRepository, monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            IProcessArea processArea = this.getPreferredProcessArea(projectArea, teamRepository, monitor);
            if (processArea != null) {
                this.fWizardContext.setProcessArea(processArea);
                return;
            }
        }
        String projectAreaUUID = this.getSavedProjectAreaUUID();
        String teamAreaUUID = this.getSavedProcessAreaUUID();
        try {
            IProcessArea processArea = this.getPersistedProcessArea(projectAreaUUID, teamAreaUUID, monitor);
            if (processArea != null && this.fWizardContext.getProjectAreaHandle() != null && this.fWizardContext.getProjectAreaHandle().getItemId().getUuidValue().equals(projectAreaUUID)) {
                this.fWizardContext.setProjectAreaHandle(processArea.getProjectArea());
                this.fWizardContext.setProcessArea(processArea);
                return;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (this.fWizardContext.getProjectAreaHandle() != null) {
            this.fWizardContext.setProcessArea((IProcessArea)projectArea);
        }
    }

    protected IProcessArea getPreferredProcessArea(IProjectArea projectArea, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            return null;
        }
        List teamAreas = projectArea.getTeamAreas();
        Iterator teamAreaIterator = teamAreas.iterator();
        int countActiveTeamAreas = 0;
        ITeamArea teamAreaToUse = null;
        while (teamAreaIterator.hasNext() && countActiveTeamAreas < 2) {
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreaIterator.next();
            try {
                ITeamArea teamArea = this.fetchTeamArea(monitor, teamAreaHandle);
                if (teamArea.isArchived()) continue;
                ++countActiveTeamAreas;
                teamAreaToUse = teamArea;
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        if (countActiveTeamAreas == 1) {
            return teamAreaToUse;
        }
        if (countActiveTeamAreas == 0) {
            return projectArea;
        }
        return null;
    }

    protected ITeamArea fetchTeamArea(IProgressMonitor monitor, ITeamAreaHandle teamAreaHandle) throws TeamRepositoryException {
        ITeamArea teamArea = (ITeamArea)this.fWizardContext.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, monitor);
        return teamArea;
    }

    protected IProjectArea fetchProjectArea(IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
        return projectArea;
    }

    private ITeamArea getTeamArea(ITeamAreaHandle teamAreaHandle, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        List teamAreas = projectArea.getTeamAreas();
        for (ITeamAreaHandle potentialMatch : teamAreas) {
            if (!potentialMatch.getItemId().equals((Object)teamAreaHandle.getItemId())) continue;
            return (ITeamArea)this.fWizardContext.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)teamAreaHandle, 0, monitor);
        }
        return null;
    }

    protected void refreshTeamAreaText() {
        if (this.fWizardContext.getProcessArea() != null) {
            this.fProcessAreaText.setText(this.fWizardContext.getProcessArea().getName());
            this.setPageComplete(true);
        } else {
            this.fProcessAreaText.setText("");
        }
    }

    protected void fetchBuildDefinitions(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.fWizardContext.getTeamRepository());
        IItemManager itemManager = this.fWizardContext.getTeamRepository().itemManager();
        IItemQuery itemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT);
        ItemQueryIterator iter = new ItemQueryIterator(buildClient, itemQuery, IQueryService.EMPTY_PARAMETERS);
        LinkedList<IBuildDefinition> buildDefinitions = new LinkedList<IBuildDefinition>();
        while (iter.hasNext(monitor)) {
            List definitionHandles = iter.next(512, monitor);
            List items = itemManager.fetchCompleteItems(definitionHandles, 0, monitor);
            for (IBuildDefinition item : items) {
                if (item == null) continue;
                buildDefinitions.add(item);
            }
        }
        this.fWizardContext.setExistingBuildDefinitions(buildDefinitions.toArray(new IBuildDefinition[buildDefinitions.size()]));
    }

    protected void refreshBuildDefinitionsViewer() {
        if (this.fWizardContext.getFilteredDefinitions().length == 0) {
            this.fBuildDefinitionsViewer.setInput((Object)new String[]{this.getNoBuildFoundText()});
            this.fBuildDefinitionsViewer.refresh();
        } else {
            this.fBuildDefinitionsViewer.setInput((Object)this.fWizardContext.getFilteredDefinitions());
            this.fBuildDefinitionsViewer.refresh();
        }
    }

    protected boolean validate() {
        if (this.fProcessAreaText.getText().length() < 1) {
            this.setErrorMessage(Messages.InitialPage_PROCESS_AREA_REQUIRED);
            this.setPageComplete(false);
            this.getContainer().updateButtons();
            return false;
        }
        if (this.fCreateFromExistingButton.getSelection() && this.fWizardContext.getFilteredDefinitions().length < 1) {
            this.setErrorMessage(this.getNoBuildFoundText());
            this.setPageComplete(false);
            this.getContainer().updateButtons();
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.getContainer().updateButtons();
        return true;
    }

    protected SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaSelectionPage.this.handleBrowseButtonSelected();
            }
        };
    }

    protected SelectionListener getCreateScratchButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProcessAreaSelectionPage.this.fCreateFromScratchButton.getSelection()) {
                    ProcessAreaSelectionPage.this.handleCreateFromScratchButtonSelected(true);
                }
            }
        };
    }

    protected SelectionListener getCreateExistingButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProcessAreaSelectionPage.this.fCreateFromExistingButton.getSelection()) {
                    ProcessAreaSelectionPage.this.handleCreateFromExistingButtonSelected();
                }
            }
        };
    }

    public boolean canFlipToNextPage() {
        if (this.fCreateFromExistingButton.getSelection() && this.fWizardContext.getExistingBuildDefinition() != null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    protected void logException(Exception exception) {
        BuildUIPlugin.log(exception);
    }

    protected int openDialog(ProcessAreaSelectionDialog dialog) {
        return dialog.open();
    }

    protected String getSavedProjectAreaUUID() {
        IPreferenceStore preferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getString(PROJECT_AREA_ID_PREFERENCE);
    }

    protected void saveProjectAreaUUID(String projectAreaUUID) {
        IPreferenceStore preferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(PROJECT_AREA_ID_PREFERENCE, projectAreaUUID);
    }

    protected String getSavedProcessAreaUUID() {
        IPreferenceStore preferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getString(PROCESS_AREA_ID_PREFERENCE);
    }

    protected void saveProcessAreaUUID(String processAreaUUID) {
        IPreferenceStore preferenceStore = BuildUIPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(PROCESS_AREA_ID_PREFERENCE, processAreaUUID);
    }

    private IProcessArea getPersistedProcessArea(String projectAreaUUID, String processAreaUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectAreaUUID.length() > 0 && processAreaUUID.length() > 0) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectAreaUUID), null);
            IItemManager itemManager = this.fWizardContext.getTeamRepository().itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
            if (projectAreaUUID.equals(processAreaUUID)) {
                return projectArea;
            }
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)processAreaUUID), null);
            return this.getTeamArea(teamAreaHandle, projectArea, monitor);
        }
        return null;
    }

    private IProcessArea getFolderProcessArea(IBuildFolderHandle buildFolderHandle, IProgressMonitor monitor) throws Exception {
        IBuildFolder buildFolder = (IBuildFolder)this.fWizardContext.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildFolderHandle, 1, monitor);
        IProcessArea processArea = (IProcessArea)this.fWizardContext.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildFolder.getProcessArea(), 0, monitor);
        return processArea;
    }

    protected WizardContext getWizardContext() {
        return this.fWizardContext;
    }

    protected String getNoBuildFoundText() {
        return Messages.InitialPage_NO_BUILDS_FOUND;
    }
}

