/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryResult;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewInput;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class RunBuildQueryAction
extends Action {
    protected final BuildQueryView fBuildQueryView;
    protected BuildQueryJob fBuildQueryJob;

    public RunBuildQueryAction(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    protected BuildQueryView getBuildQueryView() {
        return this.fBuildQueryView;
    }

    public abstract BuildQuery getBuildQuery();

    public void run() {
        this.run(this.fBuildQueryView.specificShowPersonalBuilds(), this.fBuildQueryView.specificShowMyPersonalBuilds());
    }

    public void run(boolean showPersonalBuilds) {
        this.run(showPersonalBuilds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean showAllPersonalBuilds, boolean showMyPersonalBuilds) {
        this.fBuildQueryView.startRunBuildQueryAction(this);
        BuildQuery query = this.getBuildQuery();
        if (query == null) {
            this.fBuildQueryView.finishRunBuildQueryAction(this);
            return;
        }
        this.fBuildQueryView.addBuildQueryViewHistoryEntry(query);
        RunBuildQueryAction runBuildQueryAction = this;
        synchronized (runBuildQueryAction) {
            this.fBuildQueryJob = this.createBuildQueryJob(query, showAllPersonalBuilds, showMyPersonalBuilds);
        }
        IWorkbenchSiteProgressService progressService = this.fBuildQueryView.getProgressService();
        if (progressService != null) {
            progressService.schedule((Job)this.fBuildQueryJob);
        } else {
            this.fBuildQueryJob.schedule();
        }
    }

    protected BuildQueryJob createBuildQueryJob(BuildQuery buildQuery, boolean showAllPersonalBuilds, boolean showMyPersonalBuilds) {
        return new BuildQueryJob(buildQuery, showAllPersonalBuilds, showMyPersonalBuilds);
    }

    public synchronized void cancel() {
        if (this.fBuildQueryJob != null) {
            this.fBuildQueryJob.cancel();
        }
    }

    protected void setBuildQueryViewInput(BuildQueryViewInput input) {
        this.fBuildQueryView.setInput(this, input);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runQuery(BuildQuery buildQuery, boolean showAllPersonalBuilds, boolean showMyPersonalBuilds, IProgressMonitor monitor) throws Exception {
        long startTime = System.currentTimeMillis();
        IBuildResultRecordIterator iter = buildQuery.doIterativeQuery(showAllPersonalBuilds, showMyPersonalBuilds, monitor);
        BuildQueryResult queryResult = new BuildQueryResult(buildQuery.getTeamRepository(), buildQuery);
        BuildQueryViewInput queryViewInput = new BuildQueryViewInput(queryResult);
        this.setBuildQueryViewInput(queryViewInput);
        IPreferenceStore store = BuildUIPlugin.getDefault().getPreferenceStore();
        int recordsToGet = 5;
        int recordsToGetIncrement = 5;
        int querySize = iter.size();
        String resultLimit = store.getString("build_result_limit");
        int i = 0;
        int pageSize = querySize;
        try {
            if (!resultLimit.equals(BuildUIMessages.BuildPreferencePage_RESULT_LIMIT_ALL)) {
                pageSize = Integer.parseInt(resultLimit.isEmpty() ? "100" : resultLimit);
            }
        }
        catch (NumberFormatException e) {
            pageSize = querySize;
        }
        int totalRecordsToShow = querySize < pageSize ? querySize : pageSize;
        try {
            block11: {
                block10: {
                    if (querySize <= 0) return;
                    if (!true) break block10;
                    if (!iter.hasNext()) return;
                    if (monitor.isCanceled()) return;
                    if (pageSize <= 0) break block11;
                }
                do {
                    IBuildResultRecord[] records;
                    int numOfRows = (records = iter.next(recordsToGet, monitor)).length < pageSize ? records.length : pageSize;
                    int j = 0;
                    while (j < numOfRows) {
                        buildQuery.getRowFactory().createBuildQueryRow(queryResult, records[j]);
                        ++j;
                    }
                    i += numOfRows;
                    pageSize -= numOfRows;
                    if (recordsToGetIncrement < 15) {
                        recordsToGet += recordsToGetIncrement;
                        recordsToGetIncrement += 5;
                    }
                    String label = NLS.bind((String)BuildUIQueryMessages.RunBuildQueryAction_RETRIEVING_BUILDS_X_OF_X, (Object)BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds, (Object[])new Object[]{i, totalRecordsToShow});
                    this.fBuildQueryView.updateBuildQueryViewLabelAndRowCount(this, label, i);
                    if (!iter.hasNext()) return;
                    if (monitor.isCanceled()) return;
                } while (pageSize > 0);
            }
            return;
        }
        finally {
            queryResult.setQuerySize(querySize);
            queryResult.initQueryDurationMillis(System.currentTimeMillis() - startTime);
            this.fBuildQueryView.updateBuildQueryViewLabelAndRowCount(this, queryViewInput.getFinishedDescription(), i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryFinished(BuildQuery buildQuery, IStatus status) {
        RunBuildQueryAction runBuildQueryAction = this;
        synchronized (runBuildQueryAction) {
            this.fBuildQueryJob = null;
        }
        this.fBuildQueryView.finishRunBuildQueryAction(this);
        if (status.getSeverity() == 4) {
            String errorMessage = status.getMessage();
            String errorInputDescription = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_query_error, (Object)buildQuery.getDescription(), (Object[])new Object[]{errorMessage});
            this.setBuildQueryViewInput(new BuildQueryViewInput(errorInputDescription));
        }
    }

    public class BuildQueryJob
    extends TeamBuildJob {
        private final BuildQuery fBuildQuery;
        private final boolean fShowAllPersonalBuilds;
        private final boolean fShowMyPersonalBuilds;

        protected BuildQueryJob(BuildQuery buildQuery, boolean showAllPersonalBuilds, boolean showMyPersonalBuilds) {
            super(BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds, true, buildQuery.getTeamRepository());
            this.fBuildQuery = buildQuery;
            this.fShowAllPersonalBuilds = showAllPersonalBuilds;
            this.fShowMyPersonalBuilds = showMyPersonalBuilds;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            String description = BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds;
            RunBuildQueryAction.this.setBuildQueryViewInput(new BuildQueryViewInput(description));
            RunBuildQueryAction.this.runQuery(this.fBuildQuery, this.fShowAllPersonalBuilds, this.fShowMyPersonalBuilds, monitor);
            return Status.OK_STATUS;
        }

        @Override
        protected void jobFinished(IStatus status) {
            RunBuildQueryAction.this.queryFinished(this.fBuildQuery, status);
        }
    }
}

