/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.views.query.IBuildQueryColumnProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class BuildResultViewColumnExtension {
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String CONFIG_ID_ATTRIBUTE = "configurationElementId";
    public static final String TEMPLATE_ID_ATTRIBUTE = "templateId";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String DEFAULT_VISIBILITY_ATTRIBUTE = "defaultVisibility";
    private String fClassAttribute;
    private String fConfigIdAttribute;
    private String fTemplateIdAttribute;
    private String fNameAttribute;
    private boolean fDefaultVisibility;
    private IConfigurationElement fConfigurationElement;

    public BuildResultViewColumnExtension(IConfigurationElement configurationElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)configurationElement);
        this.fConfigurationElement = configurationElement;
        this.fClassAttribute = configurationElement.getAttribute(CLASS_ATTRIBUTE);
        this.fConfigIdAttribute = configurationElement.getAttribute(CONFIG_ID_ATTRIBUTE);
        this.fTemplateIdAttribute = configurationElement.getAttribute(TEMPLATE_ID_ATTRIBUTE);
        this.fNameAttribute = configurationElement.getAttribute(NAME_ATTRIBUTE);
        this.fDefaultVisibility = this.getVisibility(configurationElement.getAttribute(DEFAULT_VISIBILITY_ATTRIBUTE));
        this.validateAttributes();
    }

    private boolean getVisibility(String dVisibility) {
        if (dVisibility == null) {
            return true;
        }
        return Boolean.parseBoolean(dVisibility);
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getConfigIdAttribute() {
        return this.fConfigIdAttribute;
    }

    public String getTemplateIdAttribute() {
        return this.fTemplateIdAttribute;
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public boolean getDefaultVisibility() {
        return this.fDefaultVisibility;
    }

    public IBuildQueryColumnProvider createColumnView() throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension();
    }

    private IBuildQueryColumnProvider createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, IBuildQueryColumnProvider.class, (Object)executableExtension);
        return (IBuildQueryColumnProvider)executableExtension;
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)TEMPLATE_ID_ATTRIBUTE, (Object)this.fTemplateIdAttribute);
        ValidationHelper.validateNotEmpty((String)TEMPLATE_ID_ATTRIBUTE, (String)this.fTemplateIdAttribute.trim());
    }
}

