/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.client.BuildRecordEventManager;
import com.ibm.team.build.internal.client.IBuildResultRecordListener;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.query.BuildQueryResult;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryRowComparator;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class BuildQueryViewInput
implements IBuildResultRecordListener {
    private static final String DESCRIPTION_BRACKETS = "()";
    private String fDescription;
    private final BuildQueryResult fBuildQueryResult;
    private Viewer fViewer;
    protected ItemManagerListener fItemManagerListener;

    public BuildQueryViewInput(String description) {
        ValidationHelper.validateNotNull((String)"description", (Object)description);
        this.fDescription = description;
        this.fBuildQueryResult = null;
    }

    public BuildQueryViewInput(BuildQueryResult buildQueryResult) {
        ValidationHelper.validateNotNull((String)"buildQueryResult", (Object)buildQueryResult);
        this.fBuildQueryResult = buildQueryResult;
        this.fDescription = NLS.bind((String)BuildUIQueryMessages.BuildQueryViewInput_RETRIEVING_BUILDS, (Object)buildQueryResult.getBuildQuery().getDescription(), (Object[])new Object[0]);
    }

    public BuildQueryResult getBuildQueryResult() {
        return this.fBuildQueryResult;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getFinishedDescription() {
        if (this.fBuildQueryResult != null) {
            String description;
            String queryDescription = this.fBuildQueryResult.getBuildQuery().getDescription();
            Integer rowCount = new Integer(this.fBuildQueryResult.getRowCount());
            Integer querySize = new Integer(this.fBuildQueryResult.getQuerySize());
            Long queryTime = new Long(this.fBuildQueryResult.getQueryDurationMillis());
            if (querySize == 1 && rowCount == 1) {
                Object[] bindings = new Object[]{queryDescription, queryTime.toString()};
                description = NLS.bind((String)BuildUIQueryMessages.BuildQueryViewInput_ViewDescription_QuerySummary_singular, (Object[])bindings, (Object[])new Object[0]);
            } else {
                Object[] bindings = new Object[]{queryDescription, rowCount.toString(), querySize.toString(), queryTime.toString()};
                description = NLS.bind((String)BuildUIQueryMessages.BuildQueryViewInput_ViewDescription_QuerySummary_plural, (Object[])bindings, (Object[])new Object[0]);
            }
            return TextProcessor.process((String)description, (String)DESCRIPTION_BRACKETS);
        }
        return this.fDescription;
    }

    public BuildQueryRow[] getQueryRows() {
        if (this.fBuildQueryResult == null) {
            return new BuildQueryRow[0];
        }
        return this.fBuildQueryResult.getRows();
    }

    public BuildQueryRow getQueryRow(int index) {
        if (this.fBuildQueryResult != null) {
            return this.fBuildQueryResult.getRow(index);
        }
        return null;
    }

    public int getRowCount() {
        if (this.fBuildQueryResult != null) {
            return this.fBuildQueryResult.getRowCount();
        }
        return 0;
    }

    public synchronized void sort(BuildQueryRowComparator[] rowComparators) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"rowComparators", (Object[])rowComparators);
        if (this.fBuildQueryResult != null) {
            this.fBuildQueryResult.sort(rowComparators);
        }
    }

    public void attachItemManagerListener(Viewer viewer) {
        this.fViewer = viewer;
        if (this.fBuildQueryResult == null) {
            return;
        }
        IItemManager itemManager = this.fBuildQueryResult.getTeamRepository().itemManager();
        this.fItemManagerListener = this.createItemManagerListener();
        itemManager.addItemChangeListener(IBuildResult.ITEM_TYPE, (ISharedItemChangeListener)this.fItemManagerListener);
    }

    public void detachItemManagerListener() {
        this.fViewer = null;
        if (this.fBuildQueryResult == null) {
            return;
        }
        IItemManager itemManager = this.fBuildQueryResult.getTeamRepository().itemManager();
        itemManager.purgeItemChangeListener((ISharedItemChangeListener)this.fItemManagerListener);
    }

    protected synchronized void processEvents(List<ISharedItemChangeEvent> events) {
        boolean changeDetected = false;
        for (ISharedItemChangeEvent event : events) {
            IItem sharedItem = event.getSharedItem();
            if (!(sharedItem instanceof IBuildResult) || !this.handleBuildResult(event)) continue;
            changeDetected = true;
        }
        if (changeDetected) {
            this.processUnknownEngines();
            this.refreshViewer();
        }
    }

    private boolean handleBuildResult(ISharedItemChangeEvent event) {
        IBuildResult result = (IBuildResult)event.getSharedItem();
        if (event.getAfterState() == null) {
            return this.fBuildQueryResult.removeRow(result.getItemId());
        }
        return this.fBuildQueryResult.hasRowFor(result.getItemId());
    }

    protected void processUnknownEngines() {
        ArrayList<BuildQueryRow> unknownEngineRows = new ArrayList<BuildQueryRow>();
        BuildQueryRow[] rows = this.fBuildQueryResult.getRows();
        int i = 0;
        while (i < rows.length) {
            BuildQueryRow row = rows[i];
            if (this.needsLateBuildEngineFetch(row)) {
                unknownEngineRows.add(row);
            }
            ++i;
        }
        if (!unknownEngineRows.isEmpty()) {
            this.scheduleFetchUnknownEnginesJob(unknownEngineRows);
        }
    }

    public void attachResultRecordListener() {
        if (this.fBuildQueryResult != null) {
            BuildRecordEventManager.getInstance().addListener((IBuildResultRecordListener)this);
        }
    }

    public void detachResultRecordListener() {
        if (this.fBuildQueryResult != null) {
            BuildRecordEventManager.getInstance().removeListener((IBuildResultRecordListener)this);
        }
    }

    public void recordsReceived(IBuildResultRecord[] records) {
        boolean needsRefresh = false;
        IBuildResultRecord[] iBuildResultRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultRecord record = iBuildResultRecordArray[n2];
            BuildQueryRow row = this.fBuildQueryResult.getRow(record.getBuildResult().getItemId());
            if (row != null) {
                needsRefresh = true;
                row.setBuildResultRecord(record);
            }
            ++n2;
        }
        if (needsRefresh) {
            this.refreshViewer();
        }
    }

    protected void scheduleFetchUnknownEnginesJob(List<BuildQueryRow> unknownEngineRows) {
        FetchUnknownEnginesJob fetchUnknownEnginesJob = new FetchUnknownEnginesJob(unknownEngineRows);
        fetchUnknownEnginesJob.schedule();
    }

    protected boolean needsLateBuildEngineFetch(BuildQueryRow row) {
        if (row.getBuildEngine() != null) {
            return false;
        }
        if (row.getBuildRequest() == null) {
            return false;
        }
        return row.getBuildResult().getState() != BuildState.NOT_STARTED;
    }

    protected void refreshViewer() {
        if (this.fViewer == null) {
            return;
        }
        this.fBuildQueryResult.resetReferenceTime();
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildQueryViewInput.this.fViewer != null) {
                    ((TableViewer)BuildQueryViewInput.this.fViewer).setItemCount(BuildQueryViewInput.this.getRowCount());
                    BuildQueryViewInput.this.fViewer.refresh();
                }
            }
        });
    }

    protected ItemManagerListener createItemManagerListener() {
        return new ItemManagerListener();
    }

    protected class FetchUnknownEnginesJob
    extends Job {
        private final List<BuildQueryRow> fUnknownEngineRows;
        protected int fEnginesFetchedCount;

        protected FetchUnknownEnginesJob(List<BuildQueryRow> unknownEngineRows) {
            super(BuildUIQueryMessages.BuildQueryViewInput_FetchUnknownEnginesJob_fetching_engines);
            this.fEnginesFetchedCount = -1;
            ValidationHelper.validateNotNull((String)"unknownEngineRows", unknownEngineRows);
            this.setSystem(true);
            this.fUnknownEngineRows = unknownEngineRows;
        }

        public IStatus run(IProgressMonitor monitor) {
            IItemManager itemManager;
            ArrayList<String> properties;
            try {
                ArrayList<IBuildRequest> buildRequests = new ArrayList<IBuildRequest>();
                for (BuildQueryRow row : this.fUnknownEngineRows) {
                    buildRequests.add(row.getBuildRequest());
                }
                properties = new ArrayList<String>();
                properties.add(IBuildRequest.PROPERTY_HANDLER);
                itemManager = BuildQueryViewInput.this.fBuildQueryResult.getTeamRepository().itemManager();
                itemManager.fetchPartialItems(buildRequests, 1, properties, monitor);
            }
            catch (TeamRepositoryException buildRequests) {
                // empty catch block
            }
            ArrayList<IBuildEngineHandle> unknownEngineHandles = new ArrayList<IBuildEngineHandle>();
            for (BuildQueryRow row : this.fUnknownEngineRows) {
                IBuildEngineHandle engineHandle;
                if (row.getBuildEngine() != null || (engineHandle = row.getBuildRequest().getHandler()) == null) continue;
                unknownEngineHandles.add(engineHandle);
            }
            if (unknownEngineHandles.isEmpty()) {
                return Status.OK_STATUS;
            }
            try {
                properties = new ArrayList();
                properties.add(IBuildEngine.PROPERTY_ID);
                itemManager = BuildQueryViewInput.this.fBuildQueryResult.getTeamRepository().itemManager();
                List engines = itemManager.fetchPartialItems(unknownEngineHandles, 0, properties, monitor);
                this.fEnginesFetchedCount = 0;
                for (IBuildEngine buildEngine : engines) {
                    if (buildEngine == null) continue;
                    ++this.fEnginesFetchedCount;
                }
                for (BuildQueryRow row : this.fUnknownEngineRows) {
                    IBuildRequest request = row.getBuildRequest();
                    row.setBuildEngine(this.getEngineFor(engines, request));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            BuildQueryViewInput.this.refreshViewer();
            return Status.OK_STATUS;
        }

        private IBuildEngine getEngineFor(List<IBuildEngine> engines, IBuildRequest request) {
            for (IBuildEngine buildEngine : engines) {
                if (buildEngine == null || request.getHandler() == null || !buildEngine.getItemId().equals((Object)request.getHandler().getItemId())) continue;
                return buildEngine;
            }
            return null;
        }
    }

    protected class ItemManagerListener
    implements ISharedItemChangeListener {
        protected ItemManagerListener() {
        }

        public void itemsChanged(List events) {
            BuildQueryViewInput.this.processEvents(events);
        }
    }
}

