/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryForBuildQueue;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewHistory;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.internal.ui.views.query.MyBuildsMenuConfigurationDialog;
import com.ibm.team.build.internal.ui.views.query.RunBuildQueryAction;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class BuildQueryViewDropdownMenuCreator
extends RunBuildQueryAction
implements IMenuCreator {
    private Menu fDropdownMenu;
    private BuildQuery fMostRecentlyRunQuery;

    public BuildQueryViewDropdownMenuCreator(BuildQueryView buildQueryView, String toolTipText, ImageDescriptor imageDescriptor) {
        super(buildQueryView);
        this.setMenuCreator(this);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(imageDescriptor);
    }

    public Menu getMenu(Control parent) {
        if (this.fDropdownMenu != null) {
            this.fDropdownMenu.dispose();
        }
        this.fDropdownMenu = new Menu(parent);
        this.createMenuItems();
        return this.fDropdownMenu;
    }

    protected abstract void createMenuItems();

    protected void createMenuSeparator() {
        new MenuItem(this.fDropdownMenu, 2);
    }

    protected void createMenuItem(String actionName, SelectionListener listener) {
        MenuItem actionItem = new MenuItem(this.fDropdownMenu, 8);
        actionItem.setText(actionName);
        actionItem.addSelectionListener(listener);
    }

    protected MenuItem createQueryMenuItem(String actionName, BuildQuery buildQuery) {
        MenuItem actionItem = new MenuItem(this.fDropdownMenu, 8);
        actionItem.setText(actionName);
        actionItem.addSelectionListener((SelectionListener)this.createMenuItemSelectionListener(actionName, buildQuery));
        return actionItem;
    }

    protected MenuItemSelectionListener createMenuItemSelectionListener(String actionName, BuildQuery buildQuery) {
        return new MenuItemSelectionListener(actionName, buildQuery);
    }

    protected BuildQuery getMostRecentlyRunQuery() {
        return this.fMostRecentlyRunQuery;
    }

    protected void setMostRecentlyRunQuery(BuildQuery mostRecentlyRunQuery) {
        this.fMostRecentlyRunQuery = mostRecentlyRunQuery;
        this.setToolTipText(mostRecentlyRunQuery.getName());
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void dispose() {
        if (this.fDropdownMenu != null) {
            this.fDropdownMenu.dispose();
            this.fDropdownMenu = null;
        }
    }

    public static class BuildQueue
    extends BuildQueryViewDropdownMenuCreator {
        public BuildQueue(BuildQueryView buildQueryView) {
            super(buildQueryView, BuildUIQueryMessages.BuildQueryView_BUILD_QUEUE, BuildUIPlugin.getImageDescriptor("icons/elcl16/buildque.gif"));
        }

        @Override
        protected void createMenuItems() {
            List<IProjectAreaHandle> projectAreas = this.getBuildQueryView().getConnectedProjectAreas();
            for (IProjectAreaHandle projectArea : projectAreas) {
                String projectAreaName = ConnectedProjectAreaRegistryHelper.getProjectAreaName(projectArea);
                String actionName = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_BUILD_QUEUE_FOR_PROJECT, (Object)projectAreaName);
                BuildQuery query = this.getBuildQueueQueryForProjectArea(projectArea);
                this.createQueryMenuItem(actionName, query);
            }
        }

        @Override
        public BuildQuery getBuildQuery() {
            BuildQuery mostRecentlyRunQuery = this.getMostRecentlyRunQuery();
            if (mostRecentlyRunQuery != null) {
                return mostRecentlyRunQuery;
            }
            List<IProjectAreaHandle> projectAreas = this.getBuildQueryView().getConnectedProjectAreas();
            if (!projectAreas.isEmpty()) {
                mostRecentlyRunQuery = this.getBuildQueueQueryForProjectArea(projectAreas.get(0));
                this.setMostRecentlyRunQuery(mostRecentlyRunQuery);
                return mostRecentlyRunQuery;
            }
            return null;
        }

        protected BuildQuery getBuildQueueQueryForProjectArea(IProjectAreaHandle projectAreaHandle) {
            String projectAreaName = ConnectedProjectAreaRegistryHelper.getProjectAreaName(projectAreaHandle);
            String queryName = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_BUILD_QUEUE_FOR_PROJECT, (Object)projectAreaName);
            ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
            return new BuildQueryForBuildQueue(queryName, null, AdaptableBuildQueryRow.Factory, projectAreaHandle, teamRepository);
        }
    }

    public static class History
    extends BuildQueryViewDropdownMenuCreator {
        public History(BuildQueryView buildQueryView) {
            super(buildQueryView, BuildUIQueryMessages.BuildQueryView_QUERY_HISTORY, BuildUIPlugin.getImageDescriptor("icons/elcl16/recntsrch.gif"));
        }

        @Override
        protected void createMenuItems() {
            BuildQueryViewHistory history = this.getBuildQueryView().getBuildQueryViewHistory();
            for (BuildQuery buildQuery : history.getEntries()) {
                this.createQueryMenuItem(buildQuery.getName(), buildQuery);
            }
        }

        @Override
        public BuildQuery getBuildQuery() {
            BuildQueryViewHistory history = this.getBuildQueryView().getBuildQueryViewHistory();
            return history.getMostRecent();
        }
    }

    protected class MenuItemSelectionListener
    extends SelectionAdapter {
        private final String fActionName;
        private final BuildQuery fBuildQuery;

        protected MenuItemSelectionListener(String actionName, BuildQuery buildQuery) {
            this.fActionName = actionName;
            this.fBuildQuery = buildQuery;
        }

        public void widgetSelected(SelectionEvent e) {
            BuildQueryViewDropdownMenuCreator.this.setToolTipText(this.fActionName);
            BuildQueryViewDropdownMenuCreator.this.fMostRecentlyRunQuery = this.fBuildQuery;
            BuildQueryViewDropdownMenuCreator.this.getBuildQueryView().runQuery(this.fBuildQuery);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public static class MyBuilds
    extends BuildQueryViewDropdownMenuCreator
    implements ITeamRepositoryService.IRepositoryServiceListener,
    ISharedItemChangeListener {
        protected List<BuildDefinitionHandleHelper> fSelectedDefinitions;
        protected boolean fMultipleRepositories;
        protected final List<UUID> fDeletedBuildDefinitions = Collections.synchronizedList(new ArrayList());

        public MyBuilds(BuildQueryView buildQueryView) {
            super(buildQueryView, BuildUIQueryMessages.BuildQueryView_MY_BUILDS, BuildUIPlugin.getImageDescriptor("icons/elcl16/mybuild.gif"));
            ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
            teamRepositoryService.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
            ITeamRepository[] iTeamRepositoryArray = teamRepositoryService.getTeamRepositories();
            int n = iTeamRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                teamRepository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)this);
                ++n2;
            }
        }

        @Override
        public void dispose() {
            ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
            teamRepositoryService.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
            ITeamRepository[] iTeamRepositoryArray = teamRepositoryService.getTeamRepositories();
            int n = iTeamRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                teamRepository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)this);
                ++n2;
            }
        }

        public void itemsChanged(List events) {
            for (Object object : events) {
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)object;
                if (event.getAfterState() != null) continue;
                this.fDeletedBuildDefinitions.add(event.getSharedItem().getItemId());
            }
        }

        public void addedRepository(ITeamRepository repository) {
            repository.itemManager().addItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)this);
        }

        public void removedRepository(ITeamRepository repository) {
            repository.itemManager().removeItemChangeListener(IBuildDefinition.ITEM_TYPE, (ISharedItemChangeListener)this);
        }

        protected ITeamRepository[] getRepositories() {
            ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
            return teamRepositoryService.getTeamRepositories();
        }

        protected List<BuildDefinitionHandleHelper> getBuildDefinitionPreferences() {
            return BuildUIPreferencesHelper.getBuildDefinitionPreferences("build.query.view.build.definitions");
        }

        @Override
        protected void createMenuItems() {
            this.createQueries(true);
        }

        protected void createQueries(boolean createMenuItems) {
            ITeamRepository[] repositories = this.getRepositories();
            this.fMultipleRepositories = repositories.length > 1;
            ArrayList<UUID> repositoryIds = new ArrayList<UUID>();
            int i = 0;
            while (i < repositories.length) {
                repositoryIds.add(repositories[i].getId());
                ++i;
            }
            this.fSelectedDefinitions = this.getBuildDefinitionPreferences();
            Hashtable<ITeamRepository, ArrayList<IBuildDefinitionHandle>> buildDefinitionsByRepository = new Hashtable<ITeamRepository, ArrayList<IBuildDefinitionHandle>>();
            boolean detectedDefinitionChange = false;
            Iterator<BuildDefinitionHandleHelper> iterator = this.fSelectedDefinitions.iterator();
            while (iterator.hasNext()) {
                ArrayList<IBuildDefinitionHandle> definitions;
                BuildDefinitionHandleHelper helper = iterator.next();
                IBuildDefinitionHandle handle = helper.getBuildDefinitionHandle();
                ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                if (teamRepository == null || this.fDeletedBuildDefinitions.contains(handle.getItemId()) || !repositoryIds.contains(teamRepository.getId())) {
                    detectedDefinitionChange = true;
                    iterator.remove();
                    continue;
                }
                IBuildDefinition definition = (IBuildDefinition)teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
                if (definition != null && !definition.getId().equals(helper.getBuildDefinitionId())) {
                    detectedDefinitionChange = true;
                    helper.setBuildDefinitionId(definition.getId());
                }
                if (createMenuItems) {
                    String queryName = helper.getBuildDefinitionId();
                    if (this.fMultipleRepositories) {
                        queryName = NLS.bind((String)BuildUIMessages.BUILD_DEFINITION_LABEL_WITH_REPOSITORY, (Object)queryName, (Object)teamRepository.getName());
                    }
                    BuildQueryByDefinition query = new BuildQueryByDefinition(queryName, null, AdaptableBuildQueryRow.Factory, handle, teamRepository);
                    MenuItem menuItem = this.createQueryMenuItem(queryName, query);
                    menuItem.setEnabled(teamRepository.loggedIn());
                }
                if ((definitions = (ArrayList<IBuildDefinitionHandle>)buildDefinitionsByRepository.get(teamRepository)) == null) {
                    definitions = new ArrayList<IBuildDefinitionHandle>();
                    buildDefinitionsByRepository.put(teamRepository, definitions);
                }
                definitions.add(handle);
            }
            if (detectedDefinitionChange) {
                BuildUIPreferencesHelper.storeBuildDefinitionPreferences(this.fSelectedDefinitions.toArray(new BuildDefinitionHandleHelper[this.fSelectedDefinitions.size()]), "build.query.view.build.definitions");
            }
            if (this.fSelectedDefinitions.size() > 0 && createMenuItems) {
                this.createMenuSeparator();
            }
            boolean mostRecentlyRunQuerySet = createMenuItems;
            int i2 = 0;
            while (i2 < repositories.length) {
                ITeamRepository repository = repositories[i2];
                List definitions = (List)buildDefinitionsByRepository.get(repository);
                if (definitions == null) {
                    definitions = Collections.EMPTY_LIST;
                }
                String queryName = null;
                queryName = this.fMultipleRepositories ? this.getMultipleRepoQueryName(repository, definitions.size()) : NLS.bind((String)BuildUIQueryMessages.BuildQueryView_MY_BUILDS_X_SELECTED, (Object)definitions.size());
                BuildQueryByDefinition query = new BuildQueryByDefinition(queryName, null, AdaptableBuildQueryRow.Factory, definitions, repository);
                if (createMenuItems) {
                    MenuItem menuItem = this.createQueryMenuItem(queryName, query);
                    menuItem.setEnabled(repository.loggedIn());
                }
                if (!mostRecentlyRunQuerySet && (repository.loggedIn() || i2 == repositories.length - 1)) {
                    mostRecentlyRunQuerySet = true;
                    this.setMostRecentlyRunQuery(query);
                }
                ++i2;
            }
            if (createMenuItems) {
                this.createMenuSeparator();
                this.createMenuItem(BuildUIQueryMessages.BuildQueryView_CONFIGURE, this.getConfigurationListener());
            }
            this.fDeletedBuildDefinitions.clear();
        }

        protected String getMultipleRepoQueryName(ITeamRepository repo, int size) {
            String repoId = repo.getName();
            if (repoId == null || repoId.length() == 0) {
                repoId = repo.getRepositoryURI();
            }
            return NLS.bind((String)BuildUIQueryMessages.BuildQueryView_MY_BUILDS_FOR_REPOSITORY, (Object)repoId, (Object)size);
        }

        protected BuildDefinitionHandleHelper[] promptUserForBuildDefinitionPreferences() {
            MyBuildsMenuConfigurationDialog dialog = new MyBuildsMenuConfigurationDialog(this.fSelectedDefinitions, this.fMultipleRepositories, null);
            if (dialog.open() == 0) {
                List<BuildDefinitionHandleHelper> buildDefinitions = dialog.getBuildDefinitions();
                return buildDefinitions.toArray(new BuildDefinitionHandleHelper[buildDefinitions.size()]);
            }
            return null;
        }

        protected SelectionListener getConfigurationListener() {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BuildDefinitionHandleHelper[] definitions = this.promptUserForBuildDefinitionPreferences();
                    if (definitions != null) {
                        BuildUIPreferencesHelper.storeBuildDefinitionPreferences(definitions, "build.query.view.build.definitions");
                    }
                    this.createQueries(false);
                }
            };
        }

        @Override
        public BuildQuery getBuildQuery() {
            BuildQuery mostRecentlyRunQuery = this.getMostRecentlyRunQuery();
            if (mostRecentlyRunQuery != null) {
                return mostRecentlyRunQuery;
            }
            this.createQueries(false);
            return this.getMostRecentlyRunQuery();
        }
    }
}

