/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.actions.EditBuildDefinitionActionDelegate;
import com.ibm.team.build.internal.ui.helper.EnterpriseHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.internal.ui.views.query.RequestBuildAction;
import com.ibm.team.build.internal.ui.views.query.RequestRebuildAction;
import com.ibm.team.build.internal.ui.views.query.ShowHistoryAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;

public class BuildQueryViewContextMenuListener
implements IMenuListener,
MenuListener {
    private final BuildQueryView fBuildQueryView;

    public BuildQueryViewContextMenuListener(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    public void menuAboutToShow(IMenuManager manager) {
        BuildQueryRow[] selectedRows = this.getBuildQueryView().getSelectedRows();
        if (selectedRows.length > 0 && this.getBuildQueryView().areOpenableBuilds(selectedRows)) {
            manager.add((IAction)new OpenSelectedBuildsAction(selectedRows));
        }
        manager.add((IContributionItem)new Separator());
        if (selectedRows.length == 1) {
            manager.add((IAction)new ShowHistoryAction(selectedRows[0].getBuildResultRecord().getBuildDefinition()));
            IBuildDefinition buildDefinition = selectedRows[0].getBuildResultRecord().getBuildDefinition();
            if (EnterpriseHelper.canRequestFromBaseBuildUI(buildDefinition)) {
                String templateID;
                RequestBuildAction requestBuildAction = new RequestBuildAction((ISelectionProvider)this.getBuildQueryView().getViewer(), this.getBuildQueryView().getShell(), false, this.fBuildQueryView.getSite());
                manager.add((IAction)requestBuildAction);
                if (selectedRows[0].getBuildResult().getState() != BuildState.NOT_STARTED && !EnterpriseHelper.isPromotionTemplate(templateID = EnterpriseHelper.getTemplateId(buildDefinition))) {
                    RequestRebuildAction requestRebuildAction = new RequestRebuildAction((ISelectionProvider)this.getBuildQueryView().getViewer(), this.getBuildQueryView().getShell(), false, this.fBuildQueryView.getSite());
                    manager.add((IAction)requestRebuildAction);
                }
            }
        }
        manager.add((IContributionItem)new GroupMarker("buildAdminActions"));
        if (selectedRows.length > 0) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getOpenBuildDefinitionAction(selectedRows, this.getBuildQueryView().getViewSite().getPage()));
        }
        manager.add((IContributionItem)new Separator("buildScmActions"));
        manager.add((IContributionItem)new Separator("buildTransferActions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("buildDeleteActions"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void menuHidden(MenuEvent e) {
    }

    public void menuShown(MenuEvent e) {
        Object o = e.getSource();
        if (o instanceof Menu) {
            MenuItem[] allMenuItems;
            Menu menu = (Menu)o;
            MenuItem[] menuItemArray = allMenuItems = menu.getItems();
            int n = allMenuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getData() instanceof ActionContributionItem && ((ActionContributionItem)currentItem.getData()).getAction() instanceof OpenSelectedBuildsAction) {
                    menu.setDefaultItem(currentItem);
                    return;
                }
                ++n2;
            }
        }
    }

    protected BuildQueryView getBuildQueryView() {
        return this.fBuildQueryView;
    }

    protected Action getOpenBuildDefinitionAction(final BuildQueryRow[] selectedRows, final IWorkbenchPage page) {
        return new Action(){

            public void run() {
                BuildQueryRow[] buildQueryRowArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    BuildQueryRow row = buildQueryRowArray[n2];
                    EditBuildDefinitionActionDelegate.run(row.getBuildResultRecord().getBuildDefinition(), page);
                    ++n2;
                }
            }

            public String getText() {
                return BuildUIQueryMessages.BuildQueryViewContextMenuListener_OPEN_DEFINITION_ACTION;
            }
        };
    }

    public class OpenSelectedBuildsAction
    extends Action {
        private final BuildQueryRow[] fSelectedRows;

        public OpenSelectedBuildsAction(BuildQueryRow[] selectedRows) {
            super(BuildUIQueryMessages.BuildQueryView_PopupAction_Open);
            ValidationHelper.validateNotNull((String)"selectedRows", (Object[])selectedRows);
            this.fSelectedRows = selectedRows;
        }

        public void run() {
            BuildQueryViewContextMenuListener.this.getBuildQueryView().openSelectedBuilds(this.fSelectedRows);
        }
    }
}

