/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnLabelProvider;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnRegistry;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferences;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;

public class BuildQueryViewColumnSelectionMenu
extends ContributionItem {
    private final BuildQueryView fBuildQueryView;

    public BuildQueryViewColumnSelectionMenu(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    public void fill(Menu menu, int index) {
        MenuItem columnsSubMenuItem = new MenuItem(menu, 64);
        columnsSubMenuItem.setText(BuildUIQueryMessages.BuildQueryView_ColumnSelectionMenu_title);
        BuildQueryDisplayPreferences preferences = this.getPreferences();
        if (preferences == null) {
            return;
        }
        Menu columnsSubMenu = new Menu(columnsSubMenuItem);
        columnsSubMenuItem.setMenu(columnsSubMenu);
        boolean isQueryRunning = this.fBuildQueryView.isRunBuildQueryActionInProgress();
        BuildQueryColumnRegistry columnRegistry = this.getColumnRegistry();
        for (BuildQueryColumn buildQueryColumn : columnRegistry.getBuildQueryColumns()) {
            MenuItem menuItem = new MenuItem(columnsSubMenu, 32);
            menuItem.setText(buildQueryColumn.getColumnLabel());
            menuItem.setEnabled(!isQueryRunning);
            menuItem.setSelection(buildQueryColumn.isVisible());
            menuItem.addSelectionListener((SelectionListener)new ColumnMenuItemSelectionListener(buildQueryColumn, preferences));
        }
    }

    protected ColumnMenuItemSelectionListener createColumnMenuItemSelectionListener(BuildQueryColumn buildQueryColumn, BuildQueryDisplayPreferences preferences) {
        return new ColumnMenuItemSelectionListener(buildQueryColumn, preferences);
    }

    protected void addColumn(BuildQueryColumn buildQueryColumn, BuildQueryDisplayPreferences preferences) {
        TableColumn tableColumn = buildQueryColumn.createTableColumn(this.fBuildQueryView.getViewer().getTable(), preferences);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fBuildQueryView.getViewer(), tableColumn);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new BuildQueryColumnLabelProvider(buildQueryColumn));
    }

    protected void removeColumn(BuildQueryColumn buildQueryColumn) {
        buildQueryColumn.disposeColumn();
    }

    protected BuildQueryDisplayPreferences getPreferences() {
        return this.fBuildQueryView.getPreferences();
    }

    protected BuildQueryColumnRegistry getColumnRegistry() {
        return this.fBuildQueryView.getColumnRegistry();
    }

    protected void refreshViewer() {
        this.fBuildQueryView.refreshViewer();
    }

    protected class ColumnMenuItemSelectionListener
    extends SelectionAdapter {
        private final BuildQueryColumn fBuildQueryColumn;
        private final BuildQueryDisplayPreferences fPreferences;

        ColumnMenuItemSelectionListener(BuildQueryColumn buildQueryColumn, BuildQueryDisplayPreferences preferences) {
            this.fBuildQueryColumn = buildQueryColumn;
            this.fPreferences = preferences;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean newVisibility = !this.fBuildQueryColumn.isVisible();
            this.fPreferences.setBuildQueryColumnVisible(this.fBuildQueryColumn.getClass(), newVisibility);
            this.fBuildQueryColumn.setVisible(newVisibility);
            if (newVisibility) {
                BuildQueryViewColumnSelectionMenu.this.addColumn(this.fBuildQueryColumn, this.fPreferences);
            } else {
                BuildQueryViewColumnSelectionMenu.this.removeColumn(this.fBuildQueryColumn);
            }
            BuildQueryViewColumnSelectionMenu.this.refreshViewer();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

