/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.InformationBar;
import com.ibm.team.build.internal.ui.actions.CopyBuildResultActionDelegate;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.query.IBuildQueryColumnKind;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnLabelProvider;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnRegistry;
import com.ibm.team.build.internal.ui.views.query.BuildQueryContentProvider;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferences;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferencesManager;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewColumnListener;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewColumnSelectionMenu;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewContextMenuListener;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewDragSupport;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewDropdownMenuCreator;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewHistory;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewInput;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewerComparator;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.internal.ui.views.query.BuildsViewTooltipSupport;
import com.ibm.team.build.internal.ui.views.query.DefaultQueryControl;
import com.ibm.team.build.internal.ui.views.query.ProjectAreaConnectionControl;
import com.ibm.team.build.internal.ui.views.query.RequestBuildAction;
import com.ibm.team.build.internal.ui.views.query.RunBuildQueryAction;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class BuildQueryView
extends ViewPart
implements IConnectedProjectAreaRegistryListener {
    public static final String BUILD_QUERY_VIEW_DEFINITIONS_PREFERENCE_KEY = "build.query.view.build.definitions";
    private static final String CONTEXT_MENU_ID = "com.ibm.team.build.ui.queryViewContextMenu";
    private TableViewer fTableViewer;
    private BuildQueryContentProvider fContentProvider;
    private Composite fBuildResultsTable;
    protected ProjectAreaConnectionControl fProjectAreaConnectionControl;
    protected DefaultQueryControl fDefaultQueryControl;
    protected IAction fRequestBuildAction;
    private IAction fCopyAction;
    private IAction fRefreshAction;
    private IAction fCancelAction;
    private BuildQueryViewDropdownMenuCreator.History fHistoryMenuCreator;
    protected BuildQueryViewDropdownMenuCreator.MyBuilds fMyBuildsMenuCreator;
    protected BuildQueryViewDropdownMenuCreator.BuildQueue fBuildQueueMenuCreator;
    private MenuItem fTeamBuildsMenuItem;
    private MenuItem fPersonalBuildsMenuItem;
    private MenuItem fMyPersonalBuildsMenuItem;
    private InformationBar fBuildQueryInformationBar;
    private PersonalBuildsDisplayType fPersonalBuildsDisplayType = PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS;
    private static PersonalBuildsDisplayType fStaticPersonalBuildsDisplayType = PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS;
    private final BuildQueryColumnRegistry fBuildQueryColumnRegistry = new BuildQueryColumnRegistry(this);
    private final BuildQueryViewColumnListener fColumnListener = new BuildQueryViewColumnListener(this);
    private final BuildQueryViewHistory fBuildQueryViewHistory = new BuildQueryViewHistory();
    private BuildQueryDisplayPreferences fBuildQueryDisplayPreferences;
    private List<IProjectAreaHandle> fConnectedProjectAreas = Collections.emptyList();
    protected RunBuildQueryAction fCurrentRunBuildQueryAction = null;
    private boolean fDisposed;
    protected Composite fViewContentParent;
    private IMenuListener fViewDropDownMenuListener;

    public TableViewer getViewer() {
        return this.fTableViewer;
    }

    public Shell getShell() {
        return this.getSite().getShell();
    }

    protected BuildQueryColumnRegistry getColumnRegistry() {
        return this.fBuildQueryColumnRegistry;
    }

    protected BuildQueryViewColumnListener getColumnListener() {
        return this.fColumnListener;
    }

    private static BuildQueryView showView(IWorkbenchPage page) {
        try {
            return (BuildQueryView)page.showView("com.ibm.team.build.internal.ui.views.query.BuildQueryView");
        }
        catch (PartInitException exception) {
            BuildUIPlugin.log(exception);
            return null;
        }
    }

    public static void displayQuery(BuildQuery query, IWorkbenchPage page) {
        BuildQueryView.displayQuery(query, page, null);
    }

    public static void displayQuery(BuildQuery query, IWorkbenchPage page, Boolean showPersonalBuilds) {
        BuildQueryView view = BuildQueryView.showView(page);
        if (view != null) {
            if (showPersonalBuilds != null) {
                PersonalBuildsDisplayType displayType;
                PersonalBuildsDisplayType personalBuildsDisplayType = displayType = showPersonalBuilds != false ? PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS : PersonalBuildsDisplayType.TEAM_BUILDS;
                if (view.specificShowPersonalBuilds() != showPersonalBuilds.booleanValue()) {
                    view.handlePersonalBuildsChanged(displayType, false);
                } else {
                    fStaticPersonalBuildsDisplayType = displayType;
                }
            }
            view.runQuery(query);
        }
    }

    public void runQuery(final BuildQuery buildQuery) {
        if (buildQuery == null) {
            return;
        }
        RunBuildQueryAction action = new RunBuildQueryAction(this){

            @Override
            public BuildQuery getBuildQuery() {
                return buildQuery;
            }
        };
        action.run(this.specificShowPersonalBuilds(), this.specificShowMyPersonalBuilds());
    }

    public synchronized boolean isRunBuildQueryActionInProgress() {
        return this.fCurrentRunBuildQueryAction != null;
    }

    protected synchronized void startRunBuildQueryAction(RunBuildQueryAction runBuildQueryAction) {
        BuildQueryViewInput input;
        if (this.fCurrentRunBuildQueryAction != null) {
            this.fCurrentRunBuildQueryAction.cancel();
        }
        this.fCurrentRunBuildQueryAction = runBuildQueryAction;
        this.enableRunBuildQueryActions(true);
        if (this.fPersonalBuildsDisplayType != PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS && this.fBuildQueryInformationBar != null) {
            this.fBuildQueryInformationBar.show();
        }
        if ((input = this.getInput()) != null) {
            input.detachResultRecordListener();
        }
    }

    protected void finishRunBuildQueryAction(final RunBuildQueryAction runBuildQueryAction) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BuildQueryViewInput input;
                if (BuildQueryView.this.fDisposed) {
                    return;
                }
                BuildQueryView buildQueryView = BuildQueryView.this;
                synchronized (buildQueryView) {
                    if (BuildQueryView.this.fCurrentRunBuildQueryAction != runBuildQueryAction) {
                        return;
                    }
                    BuildQueryView.this.fCurrentRunBuildQueryAction = null;
                }
                BuildQueryView.this.enableRunBuildQueryActions(false);
                if (BuildQueryView.this.getCurrentQuery() != null && BuildQueryView.this.fTableViewer != null) {
                    BuildQueryView.this.updateSortColumns(BuildQueryView.this.getCurrentQuery());
                }
                if ((input = BuildQueryView.this.getInput()) != null) {
                    input.attachResultRecordListener();
                }
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    protected void enableRunBuildQueryActions(boolean enabled) {
        if (this.fCancelAction != null) {
            this.fCancelAction.setEnabled(enabled);
        }
    }

    protected void addBuildQueryViewHistoryEntry(BuildQuery buildQuery) {
        ValidationHelper.validateNotNull((String)"buildQuery", (Object)buildQuery);
        this.fBuildQueryViewHistory.addEntry(buildQuery);
        String tooltipText = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_ToolbarActionTooltip_RerunBuildQuery, (Object)buildQuery.getName());
        if (this.fHistoryMenuCreator != null) {
            this.fHistoryMenuCreator.setToolTipText(tooltipText);
        }
    }

    protected BuildQueryViewHistory getBuildQueryViewHistory() {
        return this.fBuildQueryViewHistory;
    }

    protected synchronized List<IProjectAreaHandle> getConnectedProjectAreas() {
        return this.fConnectedProjectAreas;
    }

    public void createPartControl(Composite parent) {
        this.fViewContentParent = parent;
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.initConnectedProjectAreas();
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this);
        this.fPersonalBuildsDisplayType = fStaticPersonalBuildsDisplayType;
        this.createInformationBar();
        if (this.getConnectedProjectAreas().isEmpty()) {
            this.showProjectAreaConnectionControl();
        } else {
            this.showDefaultQueryControl();
        }
        this.initGlobalActions();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fViewContentParent, "com.ibm.team.build.ui.view_builds");
        parent.layout(true);
    }

    protected void createInformationBar() {
        this.fBuildQueryInformationBar = new InformationBar(this.fViewContentParent, 1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fBuildQueryInformationBar);
        this.updateInformationBarMessage();
        this.fBuildQueryInformationBar.addLinkListener(new InformationBar.IInformationBarListener(){

            @Override
            public void clicked(String ref) {
                if (ref.equals(BuildUIQueryMessages.BuildQueryView_SHOW_PERSONAL_BUILDS_LINK)) {
                    BuildQueryView.this.handlePersonalBuildsChanged(PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS, true);
                }
            }

            @Override
            public void closed() {
            }
        });
        this.fBuildQueryInformationBar.setVisible(false);
    }

    private void updateInformationBarMessage() {
        String message = this.fPersonalBuildsDisplayType == PersonalBuildsDisplayType.MY_PERSONAL_BUILDS ? NLS.bind((String)BuildUIQueryMessages.BuildQueryView_NOT_SHOWING_ALL_PERSONAL_BUILDS_MESSAGE, (Object)BuildUIQueryMessages.BuildQueryView_SHOW_PERSONAL_BUILDS_LINK) : NLS.bind((String)BuildUIQueryMessages.BuildQueryView_NOT_SHOWING_PERSONAL_BUILDS_MESSAGE, (Object)BuildUIQueryMessages.BuildQueryView_SHOW_PERSONAL_BUILDS_LINK);
        this.fBuildQueryInformationBar.setMessage(message, 1);
    }

    protected void showBuildResultsTable() {
        if (this.fDefaultQueryControl != null) {
            this.fDefaultQueryControl.dispose();
            this.fDefaultQueryControl = null;
        }
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
            this.fProjectAreaConnectionControl = null;
        }
        this.fTableViewer = new TableViewer(this.fViewContentParent, 268501762);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTableViewer.getTable());
        this.fContentProvider = new BuildQueryContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setUseHashlookup(true);
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        new BuildsViewTooltipSupport(table);
        new BuildQueryViewDragSupport(this.fTableViewer);
        this.initToolbarActions();
        this.initContextMenuActions();
        this.initMenuActions();
        this.fTableViewer.addOpenListener((IOpenListener)new OpenListener());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildQueryView.this.fCopyAction.setEnabled(BuildQueryView.this.fCopyAction.isEnabled());
            }
        });
        BuildQueryViewerComparator viewerComparator = new BuildQueryViewerComparator(this.fTableViewer);
        this.fTableViewer.setComparator((ViewerComparator)viewerComparator);
        this.fBuildResultsTable = this.fTableViewer.getTable();
        this.setToolBarActionsEnabled(true);
        if (this.fBuildQueryInformationBar != null) {
            this.fBuildQueryInformationBar.moveAbove((Control)this.fBuildResultsTable);
        }
        this.fViewContentParent.layout(true);
    }

    protected void showProjectAreaConnectionControl() {
        if (this.fDefaultQueryControl != null) {
            this.fDefaultQueryControl.dispose();
            this.fDefaultQueryControl = null;
        }
        if (this.fBuildResultsTable != null) {
            IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
            menuManager.removeAll();
            menuManager.removeMenuListener(this.fViewDropDownMenuListener);
            this.getViewSite().getActionBars().updateActionBars();
            this.fBuildResultsTable.dispose();
            this.fBuildResultsTable = null;
            this.fTableViewer = null;
        }
        this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
        this.fProjectAreaConnectionControl = new ProjectAreaConnectionControl();
        this.fProjectAreaConnectionControl.create(this.fViewContentParent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fProjectAreaConnectionControl.getContentContainer());
    }

    private void showDefaultQueryControl() {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
            this.fProjectAreaConnectionControl = null;
        }
        this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
        this.fDefaultQueryControl = new DefaultQueryControl();
        this.fDefaultQueryControl.create(this.fViewContentParent, (IWorkbenchSite)this.getViewSite(), this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fDefaultQueryControl.getContentContainer());
        this.initToolbarActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        BuildQueryView buildQueryView = this;
        synchronized (buildQueryView) {
            this.fConnectedProjectAreas = Collections.unmodifiableList(new ArrayList(projectAreas));
        }
    }

    private void setToolBarActionsEnabled(boolean enabled) {
        this.fMyBuildsMenuCreator.setEnabled(enabled);
        this.fBuildQueueMenuCreator.setEnabled(enabled);
        this.fHistoryMenuCreator.setEnabled(enabled);
        this.fRefreshAction.setEnabled(enabled);
        this.fRequestBuildAction.setEnabled(enabled);
    }

    private void initGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        final CopyBuildResultActionDelegate delegate = new CopyBuildResultActionDelegate();
        this.fCopyAction = new Action(){

            public void run() {
                if (BuildQueryView.this.fTableViewer != null) {
                    delegate.selectionChanged(null, BuildQueryView.this.fTableViewer.getSelection());
                    delegate.run((IAction)this);
                }
            }

            public boolean isEnabled() {
                return BuildQueryView.this.fTableViewer != null && !BuildQueryView.this.fTableViewer.getSelection().isEmpty();
            }
        };
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.fCopyAction);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.fRefreshAction);
        Action disabledAction = new Action(){

            public boolean isEnabled() {
                return false;
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)disabledAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)disabledAction);
        bars.updateActionBars();
    }

    private void initToolbarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        if (this.fMyBuildsMenuCreator != null) {
            this.fMyBuildsMenuCreator.dispose();
        }
        this.fMyBuildsMenuCreator = new BuildQueryViewDropdownMenuCreator.MyBuilds(this);
        toolBarManager.add((IAction)this.fMyBuildsMenuCreator);
        this.fBuildQueueMenuCreator = new BuildQueryViewDropdownMenuCreator.BuildQueue(this);
        toolBarManager.add((IAction)this.fBuildQueueMenuCreator);
        this.fHistoryMenuCreator = new BuildQueryViewDropdownMenuCreator.History(this);
        toolBarManager.add((IAction)this.fHistoryMenuCreator);
        this.fRefreshAction = this.addRefreshAction(toolBarManager);
        this.fCancelAction = this.addCancelAction(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        this.fRequestBuildAction = new RequestBuildAction((ISelectionProvider)this.fTableViewer, this.getShell(), true, this.getSite());
        this.fRequestBuildAction.setEnabled(true);
        this.fRequestBuildAction.setToolTipText(BuildUIQueryMessages.BuildQueryView_REQUEST_BUILD_ACTION_TOOLTIP);
        toolBarManager.add(this.fRequestBuildAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private Action addRefreshAction(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                BuildQuery query = BuildQueryView.this.fBuildQueryViewHistory.getMostRecent();
                if (query != null) {
                    BuildQueryView.this.runQuery(query);
                }
            }
        };
        action.setToolTipText(BuildUIQueryMessages.BuildQueryView_REFRESH);
        action.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
        toolBarManager.add((IAction)action);
        return action;
    }

    private Action addCancelAction(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                this.setEnabled(false);
                if (BuildQueryView.this.fCurrentRunBuildQueryAction != null) {
                    BuildQueryView.this.fCurrentRunBuildQueryAction.cancel();
                }
            }
        };
        action.setToolTipText(BuildUIQueryMessages.BuildQueryView_CANCEL_ACTION_TOOLTIP);
        action.setImageDescriptor(BuildUIPlugin.getImageDescriptor("icons/elcl16/stop_bldrslt.gif"));
        if (this.isRunBuildQueryActionInProgress()) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
        toolBarManager.add((IAction)action);
        return action;
    }

    private void initContextMenuActions() {
        MenuManager contextMenuManager = new MenuManager("#PopupMenu");
        contextMenuManager.setRemoveAllWhenShown(true);
        BuildQueryViewContextMenuListener listener = new BuildQueryViewContextMenuListener(this);
        contextMenuManager.addMenuListener((IMenuListener)listener);
        Menu contextMenu = contextMenuManager.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(contextMenu);
        contextMenu.addMenuListener((MenuListener)listener);
        this.getSite().registerContextMenu(CONTEXT_MENU_ID, contextMenuManager, (ISelectionProvider)this.fTableViewer);
    }

    protected ContributionItem getTeamBuildsMenuItem() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                BuildQueryView.this.fTeamBuildsMenuItem = new MenuItem(menu, 16);
                BuildQueryView.this.fTeamBuildsMenuItem.setText(BuildUIQueryMessages.BuildQueryView_SHOW_TEAM_BUILDS);
                BuildQueryView.this.fTeamBuildsMenuItem.setEnabled(true);
                BuildQueryView.this.fTeamBuildsMenuItem.setSelection(!BuildQueryView.this.specificShowMyPersonalBuilds() && !BuildQueryView.this.specificShowPersonalBuilds());
                BuildQueryView.this.fTeamBuildsMenuItem.addSelectionListener(BuildQueryView.this.getPersonalBuildsMenuItemListener(PersonalBuildsDisplayType.TEAM_BUILDS));
            }
        };
    }

    protected ContributionItem getShowPersonalBuildsMenuItem() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                BuildQueryView.this.fPersonalBuildsMenuItem = new MenuItem(menu, 16);
                BuildQueryView.this.fPersonalBuildsMenuItem.setText(BuildUIQueryMessages.BuildQueryView_SHOW_PERSONAL_BUILDS);
                BuildQueryView.this.fPersonalBuildsMenuItem.setEnabled(true);
                BuildQueryView.this.fPersonalBuildsMenuItem.setSelection(BuildQueryView.this.specificShowPersonalBuilds());
                BuildQueryView.this.fPersonalBuildsMenuItem.addSelectionListener(BuildQueryView.this.getPersonalBuildsMenuItemListener(PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS));
            }
        };
    }

    protected ContributionItem getShowMyPersonalBuildsMenuItem() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                BuildQueryView.this.fMyPersonalBuildsMenuItem = new MenuItem(menu, 16);
                BuildQueryView.this.fMyPersonalBuildsMenuItem.setText(BuildUIQueryMessages.BuildQueryView_SHOW_MY_PERSONAL_BUILDS);
                BuildQueryView.this.fMyPersonalBuildsMenuItem.setEnabled(true);
                BuildQueryView.this.fMyPersonalBuildsMenuItem.setSelection(BuildQueryView.this.specificShowMyPersonalBuilds());
                BuildQueryView.this.fMyPersonalBuildsMenuItem.addSelectionListener(BuildQueryView.this.getPersonalBuildsMenuItemListener(PersonalBuildsDisplayType.MY_PERSONAL_BUILDS));
            }
        };
    }

    protected SelectionListener getPersonalBuildsMenuItemListener(final PersonalBuildsDisplayType displayType) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildQueryView.this.handlePersonalBuildsChanged(displayType, true);
            }
        };
    }

    private void initMenuActions() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.setRemoveAllWhenShown(true);
        this.fViewDropDownMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)BuildQueryView.this.getTeamBuildsMenuItem());
                manager.add((IContributionItem)BuildQueryView.this.getShowMyPersonalBuildsMenuItem());
                manager.add((IContributionItem)BuildQueryView.this.getShowPersonalBuildsMenuItem());
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new BuildQueryViewColumnSelectionMenu(BuildQueryView.this));
            }
        };
        menuManager.addMenuListener(this.fViewDropDownMenuListener);
        menuManager.add((IAction)new Action(null){});
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected boolean areOpenableBuilds(BuildQueryRow[] rows) {
        BuildQueryRow[] buildQueryRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            BuildQueryRow row = buildQueryRowArray[n2];
            IBuildResult result = row.getBuildResult();
            if (result.getState() == BuildState.NOT_STARTED) {
                return false;
            }
            if (result.getState() == BuildState.CANCELED) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void initColumns(BuildQuery buildQuery) {
        Table table = this.fTableViewer.getTable();
        this.fColumnListener.setEnabled(false);
        List<BuildQueryColumn> buildQueryColumns = this.fBuildQueryColumnRegistry.getBuildQueryColumns();
        for (BuildQueryColumn buildQueryColumn : buildQueryColumns) {
            buildQueryColumn.disposeColumn();
        }
        if (buildQuery != null) {
            boolean isBuildDefQuery = false;
            List<IBuildDefinition> buildDefinitions = null;
            if (buildQuery instanceof BuildQueryByDefinition) {
                isBuildDefQuery = true;
                buildDefinitions = this.getBuildDefinitions(((BuildQueryByDefinition)buildQuery).getBuildDefinitionHandles());
            }
            String preferencesKey = buildQuery.getDisplayPreferencesKey();
            BuildQueryDisplayPreferencesManager preferencesManager = BuildQueryDisplayPreferencesManager.getDefault();
            BuildQueryDisplayPreferences preferences = preferencesManager.getPreferences(preferencesKey);
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : preferences.getBuildQueryColumnOrder()) {
                BuildQueryColumn buildQueryColumn = this.fBuildQueryColumnRegistry.getBuildQueryColumn(buildQueryColumnType);
                boolean isVisible = preferences.isBuildQueryColumnVisible(buildQueryColumnType);
                if (isBuildDefQuery && isVisible && buildDefinitions != null && this.fBuildQueryColumnRegistry.isExtensionBuildQueryColumn(buildQueryColumn)) {
                    isVisible = this.fBuildQueryColumnRegistry.isExtensionBuildQueryColumnApplicable(buildQueryColumn, buildDefinitions);
                }
                buildQueryColumn.setVisible(isVisible);
                if (!buildQueryColumn.isVisible()) continue;
                TableColumn tableColumn = buildQueryColumn.createTableColumn(table, preferences);
                TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fTableViewer, tableColumn);
                tableViewerColumn.setLabelProvider((CellLabelProvider)new BuildQueryColumnLabelProvider(buildQueryColumn));
            }
        }
        this.fColumnListener.setEnabled(true);
    }

    private List<IBuildDefinition> getBuildDefinitions(List<IBuildDefinitionHandle> handles) {
        ArrayList<IBuildDefinition> buildDefintions = new ArrayList<IBuildDefinition>();
        if (handles != null) {
            for (IBuildDefinitionHandle handle : handles) {
                IBuildDefinition buildDefinition;
                ITeamRepository repository = this.getOrigin(handle);
                if (repository == null || (buildDefinition = (IBuildDefinition)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle)) == null || !buildDefinition.isPropertySet(IBuildDefinition.PROPERTY_ID)) continue;
                buildDefintions.add(buildDefinition);
            }
        }
        return buildDefintions;
    }

    private ITeamRepository getOrigin(IBuildDefinitionHandle buildItemHandle) {
        return (ITeamRepository)buildItemHandle.getOrigin();
    }

    private void updateSortColumns(BuildQuery buildQuery) {
        BuildQueryViewerComparator viewerComparator = (BuildQueryViewerComparator)this.fTableViewer.getComparator();
        IBuildQueryColumnKind[] defaultSortColumns = buildQuery.getDefaultSortColumns();
        if (defaultSortColumns != null) {
            boolean firstColumn = true;
            int i = 0;
            while (i < defaultSortColumns.length) {
                BuildQueryColumn column = this.getBuildQueryColumn(defaultSortColumns[i]);
                if (column != null) {
                    if (firstColumn) {
                        viewerComparator.promoteComparatorFor(column, true);
                        firstColumn = false;
                    } else {
                        viewerComparator.promoteComparatorFor(column, false);
                    }
                }
                ++i;
            }
            if (!firstColumn) {
                viewerComparator.indicatePrimarySortColumn();
            }
        }
    }

    protected BuildQueryColumn getBuildQueryColumn(IBuildQueryColumnKind buildQueryColumnKind) {
        List<BuildQueryColumn> buildQueryColumns = this.fBuildQueryColumnRegistry.getBuildQueryColumns();
        for (BuildQueryColumn buildQueryColumn : buildQueryColumns) {
            if (buildQueryColumnKind != buildQueryColumn.getKind()) continue;
            return buildQueryColumn;
        }
        return null;
    }

    protected void openSelectedBuilds(BuildQueryRow[] rows) {
        ValidationHelper.validateNotNull((String)"rows", (Object[])rows);
        int i = 0;
        while (i < rows.length) {
            BuildQueryRow row = rows[i];
            BuildUI.getDefault().open((IBuildResultHandle)row.getBuildResult(), row.getTeamRepository(), this.getSite().getPage());
            ++i;
        }
    }

    protected BuildQueryRow[] getSelectedRows() {
        ISelection sel = this.getViewer().getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)sel;
            BuildQueryRow[] rows = new BuildQueryRow[ssel.size()];
            int index = 0;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                rows[index++] = (BuildQueryRow)i.next();
            }
            return rows;
        }
        return new BuildQueryRow[0];
    }

    protected BuildQueryDisplayPreferences getPreferences() {
        return this.fBuildQueryDisplayPreferences;
    }

    protected boolean setPreferences(BuildQuery buildQuery) {
        BuildQueryDisplayPreferences oldPreferences = this.fBuildQueryDisplayPreferences;
        if (buildQuery == null) {
            this.fBuildQueryDisplayPreferences = null;
        } else {
            String preferencesKey = buildQuery.getDisplayPreferencesKey();
            this.fBuildQueryDisplayPreferences = this.lookupBuildQueryDisplayPreferences(preferencesKey);
        }
        return oldPreferences != this.fBuildQueryDisplayPreferences;
    }

    protected BuildQueryDisplayPreferences lookupBuildQueryDisplayPreferences(String preferencesKey) {
        BuildQueryDisplayPreferencesManager preferencesManager = BuildQueryDisplayPreferencesManager.getDefault();
        return preferencesManager.getPreferences(preferencesKey);
    }

    public BuildQuery getCurrentQuery() {
        BuildQueryViewInput input = this.getInput();
        if (input == null || input.getBuildQueryResult() == null) {
            return null;
        }
        return input.getBuildQueryResult().getBuildQuery();
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        return (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
    }

    protected BuildQueryViewInput getInput() {
        if (this.fTableViewer == null) {
            return null;
        }
        return (BuildQueryViewInput)this.fTableViewer.getInput();
    }

    protected void setInput(final RunBuildQueryAction runBuildQueryAction, final BuildQueryViewInput input) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildQueryView.this.fViewContentParent != null && !BuildQueryView.this.fViewContentParent.isDisposed() && BuildQueryView.this.fCurrentRunBuildQueryAction == runBuildQueryAction) {
                    BuildQueryView.this.setInput(input);
                }
            }
        });
    }

    protected void setInput(BuildQueryViewInput input) {
        if (input == null) {
            this.setContentDescription(BuildUIQueryMessages.BuildQueryView_no_input);
        } else {
            this.setContentDescription(input.getDescription());
            if (input.getBuildQueryResult() != null) {
                BuildQuery buildQuery = input.getBuildQueryResult().getBuildQuery();
                boolean preferencesChanged = this.setPreferences(buildQuery);
                if (this.fBuildResultsTable == null) {
                    this.showBuildResultsTable();
                    this.initColumns(buildQuery);
                } else if (preferencesChanged || buildQuery instanceof BuildQueryByDefinition && this.fBuildQueryColumnRegistry.isExtensionColumnsRegistered()) {
                    this.initColumns(buildQuery);
                }
            } else if (this.fDefaultQueryControl != null) {
                this.fDefaultQueryControl.dispose();
                this.fDefaultQueryControl = null;
            }
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.getTable().setSortDirection(0);
            this.fTableViewer.setItemCount(0);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection());
            this.fTableViewer.setInput((Object)input);
        }
    }

    protected void updateBuildQueryViewLabelAndRowCount(final RunBuildQueryAction runBuildQueryAction, final String label, final int rowCount) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildQueryView.this.fViewContentParent != null && !BuildQueryView.this.fViewContentParent.isDisposed() && BuildQueryView.this.fCurrentRunBuildQueryAction == runBuildQueryAction) {
                    BuildQueryView.this.setContentDescription(label);
                    BuildQueryView.this.fTableViewer.setItemCount(rowCount);
                }
            }
        });
    }

    protected void refreshViewer() {
        TableViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    public void setFocus() {
        if (this.fViewContentParent != null && !this.fViewContentParent.isDisposed()) {
            this.fViewContentParent.setFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        BuildQueryView buildQueryView = this;
        synchronized (buildQueryView) {
            if (this.fCurrentRunBuildQueryAction != null) {
                this.fCurrentRunBuildQueryAction.cancel();
                this.fCurrentRunBuildQueryAction = null;
            }
        }
        this.fDisposed = true;
        this.fContentProvider = null;
        this.fTableViewer = null;
        this.fViewContentParent = null;
        if (this.fMyBuildsMenuCreator != null) {
            this.fMyBuildsMenuCreator.dispose();
            this.fMyBuildsMenuCreator = null;
        }
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this);
        super.dispose();
    }

    public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        this.initConnectedProjectAreas();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildQueryView.this.handleProjectAreasChanged();
            }
        });
    }

    protected void handleProjectAreasChanged() {
        if (this.fViewContentParent != null && !this.fViewContentParent.isDisposed()) {
            if (this.fProjectAreaConnectionControl != null) {
                if (this.getConnectedProjectAreas().size() > 0) {
                    this.showDefaultQueryControl();
                }
            } else if (this.fDefaultQueryControl != null) {
                if (this.getConnectedProjectAreas().size() > 0) {
                    this.fDefaultQueryControl.updateQueryLinks();
                } else {
                    this.showProjectAreaConnectionControl();
                }
            } else if (this.fBuildResultsTable != null && this.getConnectedProjectAreas().size() == 0) {
                this.showProjectAreaConnectionControl();
                this.setToolBarActionsEnabled(false);
            }
            this.fViewContentParent.layout(true);
        }
    }

    public static boolean globalShowPersonalBuilds() {
        return fStaticPersonalBuildsDisplayType == PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS;
    }

    public static boolean globalShowMyPersonalBuilds() {
        return fStaticPersonalBuildsDisplayType == PersonalBuildsDisplayType.MY_PERSONAL_BUILDS;
    }

    protected boolean specificShowPersonalBuilds() {
        return this.fPersonalBuildsDisplayType == PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS;
    }

    protected boolean specificShowMyPersonalBuilds() {
        return this.fPersonalBuildsDisplayType == PersonalBuildsDisplayType.MY_PERSONAL_BUILDS;
    }

    protected void handlePersonalBuildsChanged(PersonalBuildsDisplayType displayType, boolean shouldRefreshResult) {
        this.fPersonalBuildsDisplayType = displayType;
        fStaticPersonalBuildsDisplayType = displayType;
        if (this.fBuildQueryInformationBar != null) {
            if (this.fPersonalBuildsDisplayType == PersonalBuildsDisplayType.ALL_PERSONAL_BUILDS) {
                this.fBuildQueryInformationBar.hide(false);
            } else {
                this.updateInformationBarMessage();
            }
        }
        if (shouldRefreshResult && this.getCurrentQuery() != null) {
            this.runQuery(this.getCurrentQuery());
        }
    }

    public class OpenListener
    implements IOpenListener {
        public void open(OpenEvent event) {
            BuildQueryRow[] rows = BuildQueryView.this.getSelectedRows();
            if (BuildQueryView.this.areOpenableBuilds(rows)) {
                BuildQueryView.this.openSelectedBuilds(rows);
            }
        }
    }

    public static enum PersonalBuildsDisplayType {
        TEAM_BUILDS,
        MY_PERSONAL_BUILDS,
        ALL_PERSONAL_BUILDS;

    }
}

