/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnExt;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildResultViewColumnExtension;
import com.ibm.team.build.internal.ui.views.query.BuildResultViewColumnExtensionManager;
import com.ibm.team.build.internal.ui.views.query.IBuildQueryColumnProvider;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class BuildQueryColumnRegistry {
    private static ArrayList<Class<? extends BuildQueryColumn>> fBuildQueryColumnTypes;
    private static ArrayList<Class<? extends BuildQueryColumn>> fDefaultHiddenBuildQueryColumnTypes;
    private static ArrayList<ExtensionBuildQueryColumnData> fAllExtensionBuildQueryColumnData;
    private static ArrayList<Class<? extends BuildQueryColumn>> fHiddenExtensionBuildQueryColumnnTypes;
    private static HashMap<String, Class<? extends BuildQueryColumn>> fBuildQueryColumnTypeBySimpleName;
    private final BuildQueryView fBuildQueryView;
    private final HashMap<Class<? extends BuildQueryColumn>, BuildQueryColumn> fBuildQueryColumns = new HashMap();
    private final TreeMap<String, BuildQueryColumn> fSortedBuildQueryColumns = new TreeMap(Collator.getInstance());

    public static Class<? extends BuildQueryColumn> getBuildQueryColumnType(String buildQueryColumnSimpleName) {
        if (fBuildQueryColumnTypeBySimpleName == null) {
            fBuildQueryColumnTypeBySimpleName = new HashMap();
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : BuildQueryColumnRegistry.getAllBuildQueryColumnTypes()) {
                fBuildQueryColumnTypeBySimpleName.put(buildQueryColumnType.getSimpleName(), buildQueryColumnType);
            }
        }
        return fBuildQueryColumnTypeBySimpleName.get(buildQueryColumnSimpleName);
    }

    public static List<Class<? extends BuildQueryColumn>> getAllBuildQueryColumnTypes() {
        if (fBuildQueryColumnTypes == null) {
            fBuildQueryColumnTypes = new ArrayList();
            fBuildQueryColumnTypes.add(BuildQueryColumn.Status.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.State.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.BuildDefinition.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Label.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Progress.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.EstimatedCompletionTime.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.StartTime.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.TimeTaken.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Tags.class);
            fBuildQueryColumnTypes.addAll(BuildQueryColumnRegistry.getDefaultHiddenBuildQueryColumnTypes());
            fBuildQueryColumnTypes.addAll(BuildQueryColumnRegistry.getColumnsByExtensions());
        }
        return new ArrayList<Class<? extends BuildQueryColumn>>(fBuildQueryColumnTypes);
    }

    public static List<Class<? extends BuildQueryColumn>> getDefaultHiddenBuildQueryColumnTypes() {
        if (fDefaultHiddenBuildQueryColumnTypes == null) {
            fDefaultHiddenBuildQueryColumnTypes = new ArrayList();
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.BuildEngineId.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.CompletionTime.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.Requestor.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.TimeInQueue.class);
        }
        return fDefaultHiddenBuildQueryColumnTypes;
    }

    public static List<Class<? extends BuildQueryColumn>> getAllDefaultHiddenBuildQueryColumnTypes() {
        ArrayList<Class<? extends BuildQueryColumn>> hColumns = new ArrayList<Class<? extends BuildQueryColumn>>();
        hColumns.addAll(BuildQueryColumnRegistry.getDefaultHiddenBuildQueryColumnTypes());
        hColumns.addAll(BuildQueryColumnRegistry.getHiddenColumnsByExtensions());
        return hColumns;
    }

    public boolean isExtensionColumnsRegistered() {
        return fAllExtensionBuildQueryColumnData != null && !fAllExtensionBuildQueryColumnData.isEmpty();
    }

    public boolean isExtensionBuildQueryColumn(BuildQueryColumn buildColumn) {
        return buildColumn instanceof BuildQueryColumnExt;
    }

    public boolean isExtensionBuildQueryColumnApplicable(BuildQueryColumn buildColumn, List<IBuildDefinition> buildDefinitions) {
        if (this.isExtensionBuildQueryColumn(buildColumn)) {
            return ExtensionBuildQueryColumnData.isColumnApplicable(buildColumn, buildDefinitions, fAllExtensionBuildQueryColumnData);
        }
        return false;
    }

    private static Collection<? extends Class<? extends BuildQueryColumn>> getHiddenColumnsByExtensions() {
        if (fAllExtensionBuildQueryColumnData == null) {
            BuildQueryColumnRegistry.getColumnsByExtensions();
        }
        if (fHiddenExtensionBuildQueryColumnnTypes != null) {
            return fHiddenExtensionBuildQueryColumnnTypes;
        }
        return new ArrayList(0);
    }

    private static Collection<? extends Class<? extends BuildQueryColumn>> getColumnsByExtensions() {
        BuildResultViewColumnExtension[] availableExtensions;
        if (fAllExtensionBuildQueryColumnData == null) {
            fAllExtensionBuildQueryColumnData = new ArrayList();
            fHiddenExtensionBuildQueryColumnnTypes = new ArrayList();
        }
        ArrayList<Class<? extends BuildQueryColumnExt>> fAvailableContributions = new ArrayList<Class<? extends BuildQueryColumnExt>>();
        BuildResultViewColumnExtension[] buildResultViewColumnExtensionArray = availableExtensions = BuildResultViewColumnExtensionManager.getInstance().getContributionExtensions();
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            BuildResultViewColumnExtension extension = buildResultViewColumnExtensionArray[n2];
            if (extension != null) {
                try {
                    IBuildQueryColumnProvider cClass = extension.createColumnView();
                    if (cClass != null) {
                        Class<? extends BuildQueryColumnExt> cProvider = cClass.getBuildColumnProvider();
                        fAvailableContributions.add(cProvider);
                        ExtensionBuildQueryColumnData cData = new ExtensionBuildQueryColumnData(cProvider, extension.getTemplateIdAttribute(), extension.getConfigIdAttribute(), extension.getDefaultVisibility());
                        fAllExtensionBuildQueryColumnData.add(cData);
                        if (!cData.fDefaultVisibility) {
                            fHiddenExtensionBuildQueryColumnnTypes.add(cProvider);
                        }
                    }
                }
                catch (Exception exception) {
                    BuildUIPlugin.log(exception);
                }
            }
            ++n2;
        }
        return fAvailableContributions;
    }

    public BuildQueryColumnRegistry(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
        this.init(BuildQueryColumnRegistry.getAllBuildQueryColumnTypes());
    }

    private void init(List<Class<? extends BuildQueryColumn>> buildQueryColumnTypes) {
        try {
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : buildQueryColumnTypes) {
                if (buildQueryColumnType.getSuperclass().equals(BuildQueryColumnExt.class)) continue;
                BuildQueryColumn buildQueryColumn = buildQueryColumnType.newInstance();
                buildQueryColumn.initBuildQueryView(this.fBuildQueryView);
                this.fBuildQueryColumns.put(buildQueryColumn.getClass(), buildQueryColumn);
                this.fSortedBuildQueryColumns.put(buildQueryColumn.getColumnLabel(), buildQueryColumn);
            }
            if (fAllExtensionBuildQueryColumnData != null) {
                for (ExtensionBuildQueryColumnData cData : fAllExtensionBuildQueryColumnData) {
                    cData.fBuildColumn = cData.fType.newInstance();
                    cData.fBuildColumn.initBuildQueryView(this.fBuildQueryView);
                    this.fBuildQueryColumns.put(cData.fBuildColumn.getClass(), cData.fBuildColumn);
                    this.fSortedBuildQueryColumns.put(cData.fBuildColumn.getColumnLabel(), cData.fBuildColumn);
                }
            }
        }
        catch (Exception exception) {
            BuildUIPlugin.log(exception);
        }
    }

    public List<BuildQueryColumn> getBuildQueryColumns() {
        return new ArrayList<BuildQueryColumn>(this.fSortedBuildQueryColumns.values());
    }

    public BuildQueryColumn getBuildQueryColumn(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        return this.fBuildQueryColumns.get(buildQueryColumnType);
    }

    private static class ExtensionBuildQueryColumnData {
        public Class<? extends BuildQueryColumnExt> fType;
        public BuildQueryColumnExt fBuildColumn;
        public String[] fTemplateIds;
        public String[] fConfigIds;
        public boolean fDefaultVisibility;

        public ExtensionBuildQueryColumnData(Class<? extends BuildQueryColumnExt> type, String templateId, String configId, boolean defaultVisibility) {
            this.fType = type;
            if (templateId != null) {
                this.fTemplateIds = templateId.split(",");
            }
            if (configId != null) {
                this.fConfigIds = configId.split(",");
            }
            this.fDefaultVisibility = defaultVisibility;
        }

        public static boolean isColumnApplicable(BuildQueryColumn bColumn, List<IBuildDefinition> buildDefinitions, List<ExtensionBuildQueryColumnData> data) {
            ExtensionBuildQueryColumnData eData = null;
            if (data != null) {
                for (ExtensionBuildQueryColumnData columnData : data) {
                    if (columnData.fBuildColumn != bColumn) continue;
                    eData = columnData;
                    break;
                }
            }
            boolean isApplicable = true;
            if (eData != null) {
                for (IBuildDefinition buildDefinition : buildDefinitions) {
                    if (eData.fTemplateIds != null) {
                        String templateId = buildDefinition.getPropertyValue("com.ibm.team.build.internal.template.id", null);
                        isApplicable = ExtensionBuildQueryColumnData.isTemplateIdMatches(templateId, eData.fTemplateIds);
                    }
                    if (isApplicable && eData.fConfigIds != null && eData.fConfigIds.length > 0) {
                        isApplicable = ExtensionBuildQueryColumnData.hasConfigurarationProperty(buildDefinition, eData.fConfigIds);
                    }
                    if (!isApplicable) break;
                }
            }
            return isApplicable;
        }

        private static boolean hasConfigurarationProperty(IBuildDefinition buildDefinition, String[] configIds) {
            if (configIds != null && configIds.length > 0) {
                String[] stringArray = configIds;
                int n = configIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id != null && buildDefinition.getConfigurationElement(id.trim()) != null) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private static boolean isTemplateIdMatches(String buildDefTemplateId, String[] templateIds) {
            if (templateIds != null && templateIds.length > 0) {
                String[] stringArray = templateIds;
                int n = templateIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id != null && id.trim().equals(buildDefTemplateId)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

