/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.model.dto.DtoFactory;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildQueryBySelectedProcessAreas
extends BuildQuery {
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryBySelectedProcessAreas(String name, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, null, AdaptableBuildQueryRow.Factory, teamRepository);
        this.fProjectAreaHandle = projectAreaHandle;
    }

    @Override
    protected IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        List<IProcessAreaHandle> selectedProcessAreas = this.getSelectedProcessAreas();
        return selectedProcessAreas.isEmpty() ? null : DtoFactory.eINSTANCE.createBuildResultSearchCriteria().inProcessAreas(selectedProcessAreas);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    @Override
    public String getDescription() {
        String description = null;
        List<IProcessAreaHandle> selectedProcessAreas = this.getSelectedProcessAreas();
        String projectAreaName = this.getProjectAreaName();
        IProjectArea projectArea = this.getSharedProjectAreaIfKnown();
        if (projectArea != null) {
            int totalProcessAreaCount = projectArea.getTeamAreas().size() + 1;
            description = MessageFormat.format(BuildUIQueryMessages.BuildQueryBySelectedProcessAreas_QUERY_DESCRIPTION_KNOWN_TOTAL, selectedProcessAreas.size(), totalProcessAreaCount, projectAreaName);
        } else {
            description = selectedProcessAreas.size() == 1 ? NLS.bind((String)BuildUIQueryMessages.BuildQueryBySelectedProcessAreas_QUERY_DESCRIPTION_SINGULAR_UNKNOWN_TOTAL, (Object)selectedProcessAreas.size(), (Object)projectAreaName) : NLS.bind((String)BuildUIQueryMessages.BuildQueryBySelectedProcessAreas_QUERY_DESCRIPTION_PLURAL_UNKNOWN_TOTAL, (Object)selectedProcessAreas.size(), (Object)projectAreaName);
        }
        return description;
    }

    protected List<IProcessAreaHandle> getSelectedProcessAreas() {
        return ConnectedProjectAreaRegistry.getDefault().getSelectedProcessAreas(this.fProjectAreaHandle);
    }

    protected String getProjectAreaName() {
        return ConnectedProjectAreaRegistryHelper.getProjectAreaName(this.fProjectAreaHandle);
    }

    protected IProjectArea getSharedProjectAreaIfKnown() {
        return (IProjectArea)this.getTeamRepository().itemManager().getSharedItemIfKnown((IItemHandle)this.fProjectAreaHandle);
    }
}

