/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultSearchCriteria;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryByContributorProcessAreas
extends BuildQuery {
    private IContributor fUser;

    public BuildQueryByContributorProcessAreas(String name, IContributor user, ITeamRepository teamRepository) {
        super(name, null, AdaptableBuildQueryRow.Factory, teamRepository);
        this.fUser = user;
    }

    protected IProjectAreaHandle[] getConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.getTeamRepository());
        return projectAreas.toArray(new IProjectAreaHandle[projectAreas.size()]);
    }

    @Override
    protected IBuildResultSearchCriteria getBuildQueryCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle[] projectAreas = this.getConnectedProjectAreas();
        if (this.fUser == null || projectAreas.length == 0) {
            return null;
        }
        if (BuildUIPreferencesHelper.getBuildDefinitionPreferences("build.query.view.build.definitions").size() == 0) {
            IBuildDefinitionStatusRecord[] records = this.getRecordClient().getBuildDefinitionStatusRecords(this.fUser, projectAreas, monitor);
            IBuildDefinition[] definitions = new IBuildDefinition[records.length];
            int i = 0;
            while (i < records.length) {
                definitions[i] = records[i].getBuildDefinition();
                ++i;
            }
            BuildUIPreferencesHelper.storeBuildDefinitionPreferences(definitions, "build.query.view.build.definitions");
            return IBuildResultSearchCriteria.BUILDER.forDefinitions(Arrays.asList(definitions));
        }
        return IBuildResultSearchCriteria.BUILDER.inProjectAreas(Arrays.asList(projectAreas)).withMember((IContributorHandle)this.fUser);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    @Override
    public String getDescription() {
        return BuildUIQueryMessages.BuildQueryByContributorTeamAreas_QUERY_DESCRIPTION;
    }
}

